/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.period.api;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.psd.business.service.period.api.ISchePeriodCalculator;
import kd.tmc.psd.business.service.period.calc.AbstractSchePeriodCalc;
import kd.tmc.psd.business.service.period.calc.DailySchePeriodCalc;
import kd.tmc.psd.business.service.period.calc.FixedSchePeriodCalc;
import kd.tmc.psd.business.service.period.calc.MonthlySchePeriodCalc;
import kd.tmc.psd.business.service.period.calc.TenDaySchePeriodCalc;
import kd.tmc.psd.business.service.period.calc.WeeklySchePeriodCalc;
import kd.tmc.psd.business.service.period.model.ScheCalcResult;
import kd.tmc.psd.business.service.period.model.SchePeriod;
import kd.tmc.psd.common.enums.AutoScheTypeEnum;

public class SchePeriodCalcFactory {
    public static ISchePeriodCalculator initCalculator(DynamicObject obj) {
        AbstractSchePeriodCalc schePeriodCalculator = null;
        String autoScheType = obj.getString("autoschetype");
        List<ScheCalcResult> calcResult = ScheCalcResult.fromDynamicObject(obj);
        SchePeriod schePeriod = SchePeriod.fromDynamicObject(obj);
        schePeriodCalculator = new MonthlySchePeriodCalc(calcResult, schePeriod);
        if (!AutoScheTypeEnum.MONTH.getValue().equals(autoScheType)) {
            if (AutoScheTypeEnum.WEEK.getValue().equals(autoScheType)) {
                schePeriodCalculator = new WeeklySchePeriodCalc(calcResult, schePeriod);
            } else if (AutoScheTypeEnum.PERIOD.getValue().equals(autoScheType)) {
                schePeriodCalculator = new TenDaySchePeriodCalc(calcResult, schePeriod);
            } else if (AutoScheTypeEnum.CUSTOM.getValue().equals(autoScheType)) {
                schePeriodCalculator = new DailySchePeriodCalc(calcResult, schePeriod);
            } else if (AutoScheTypeEnum.FIXED.getValue().equals(autoScheType)) {
                schePeriodCalculator = new FixedSchePeriodCalc(calcResult, schePeriod);
            }
        }
        return schePeriodCalculator;
    }
}

