/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.period.calc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.period.api.ISchePeriodCalculator;
import kd.tmc.psd.business.service.period.model.ScheCalcResult;
import kd.tmc.psd.business.service.period.model.ScheCalcResultBuilder;
import kd.tmc.psd.business.service.period.model.SchePeriod;

public abstract class AbstractSchePeriodCalc
implements ISchePeriodCalculator {
    protected List<ScheCalcResult> calcResult;
    protected SchePeriod schePeriod;

    public AbstractSchePeriodCalc(List<ScheCalcResult> calcResult, SchePeriod schePeriod) {
        this.calcResult = calcResult;
        this.schePeriod = schePeriod;
    }

    protected abstract void calculate(List<ScheCalcResult> var1, SchePeriod var2);

    @Override
    public List<ScheCalcResult> calculate() {
        this.calcResult.clear();
        this.calculate(this.calcResult, this.schePeriod);
        List needSetIdData = this.calcResult.stream().filter(v -> EmptyUtil.isEmpty((Long)v.getPeriodId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(needSetIdData)) {
            long[] pkValues = DB.genLongIds((String)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill").getAlias(), (int)needSetIdData.size());
            for (int i = 0; i < needSetIdData.size(); ++i) {
                ((ScheCalcResult)needSetIdData.get(i)).setPeriodId(pkValues[i]);
            }
        }
        return this.calcResult;
    }

    @Override
    public List<ScheCalcResult> change(Integer index, Date startDate, Date endDate) {
        endDate = DateUtils.getDataFormat((Date)endDate, (boolean)true);
        ScheCalcResult nextRow = this.calcResult.get(index + 1);
        Date nextStartDay = nextRow.getStartDate();
        if (DateUtils.getDataFormat((Date)DateUtils.getLastDay((Date)nextStartDay, (int)1), (boolean)true).compareTo(endDate) > 0) {
            nextRow.setStartDate(DateUtils.getNextDay((Date)endDate, (int)1));
            nextRow.setDiffDays(DateUtils.getDiffDays((Date)nextRow.getStartDate(), (Date)nextRow.getEndDate()));
            ScheCalcResult currRow = this.calcResult.get(index);
            currRow.setDiffDays(DateUtils.getDiffDays((Date)currRow.getStartDate(), (Date)currRow.getEndDate()));
            return this.calcResult;
        }
        ArrayList<ScheCalcResult> results = new ArrayList<ScheCalcResult>();
        int len = this.calcResult.size();
        for (int i = 0; i < len; ++i) {
            ScheCalcResult result = this.calcResult.get(i);
            if (i <= index) {
                results.add(result);
                if (i != index) continue;
                result.setPeriodNum(i + 1);
                result.setName(this.getPeriodName(this.schePeriod.getYear(), i + 1));
                result.setDiffDays(DateUtils.getDiffDays((Date)result.getStartDate(), (Date)result.getEndDate()));
                continue;
            }
            Date currStartDate = DateUtils.getDataFormat((Date)result.getStartDate(), (boolean)true);
            Date currEndDate = DateUtils.getDataFormat((Date)result.getEndDate(), (boolean)true);
            if (endDate.compareTo(currStartDate) == 0 || endDate.compareTo(currEndDate) < 0 && endDate.compareTo(currStartDate) > 0) {
                result.setStartDate(DateUtils.getNextDay((Date)endDate, (int)1));
                result.setPeriodNum(results.size());
                result.setName(this.getPeriodName(this.schePeriod.getYear(), result.getPeriodNum() + 1));
                result.setDiffDays(DateUtils.getDiffDays((Date)result.getStartDate(), (Date)result.getEndDate()));
                results.add(result);
                continue;
            }
            if (endDate.compareTo(currStartDate) >= 0) continue;
            result.setPeriodNum(results.size());
            result.setName(this.getPeriodName(this.schePeriod.getYear(), result.getPeriodNum() + 1));
            results.add(result);
        }
        return results;
    }

    @Override
    public List<ScheCalcResult> delete(Integer index) {
        int len = this.calcResult.size();
        for (int i = index.intValue(); i < len; ++i) {
            ScheCalcResult result = this.calcResult.get(i);
            if (i == index) {
                DateUtils.getNextDay((Date)this.calcResult.get(i - 1).getEndDate(), (int)1);
                result.setStartDate(DateUtils.getNextDay((Date)this.calcResult.get(i - 1).getEndDate(), (int)1));
                result.setDiffDays(DateUtils.getDiffDays((Date)result.getStartDate(), (Date)result.getEndDate()));
            }
            result.setPeriodNum(i + 1);
            result.setName(this.getPeriodName(DateUtils.getYear((Date)result.getStartDate()), i + 1));
        }
        return this.calcResult;
    }

    @Override
    public List<ScheCalcResult> insert(Integer index) {
        long pkValue = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill").getAlias());
        ScheCalcResult lastEntry = this.calcResult.get(index - 1);
        ScheCalcResult insertRow = ScheCalcResultBuilder.create().periodId(pkValue).periodNum(index).name(this.getPeriodName(this.schePeriod.getYear(), index)).startDate(DateUtils.getNextDay((Date)lastEntry.getEndDate(), (int)1)).endDate(DateUtils.getNextDay((Date)lastEntry.getEndDate(), (int)1)).diffDays(1).build();
        this.calcResult.add(index, insertRow);
        ScheCalcResult nextResult = this.calcResult.get(index + 1);
        nextResult.setStartDate(DateUtils.getNextDay((Date)nextResult.getStartDate(), (int)1));
        nextResult.setDiffDays(DateUtils.getDiffDays((Date)nextResult.getStartDate(), (Date)nextResult.getEndDate()));
        if (nextResult.getDiffDays() <= 0) {
            this.calcResult.remove(nextResult);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index - 1);
        }
        int len = this.calcResult.size();
        for (int i = index.intValue(); i < len; ++i) {
            ScheCalcResult result = this.calcResult.get(i);
            result.setPeriodNum(i + 1);
            result.setName(this.getPeriodName(this.schePeriod.getYear(), i + 1));
        }
        return this.calcResult;
    }

    protected List<ScheCalcResult> getCaclResult() {
        return this.calcResult;
    }

    protected SchePeriod getSchePeriod() {
        return this.schePeriod;
    }

    public String getPeriodName(int year, int periodNum) {
        String num = String.valueOf(1000 + periodNum).substring(1, 4);
        return String.format(ResManager.loadKDString((String)"%1$s\u5e74%2$s\u671f", (String)"AbstractSchePeriodCalc_0", (String)"tmc-psd-business", (Object[])new Object[0]), year, num);
    }
}

