/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.period.calc;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.business.service.period.calc.AbstractSchePeriodCalc;
import kd.tmc.psd.business.service.period.model.ScheCalcResult;
import kd.tmc.psd.business.service.period.model.ScheCalcResultBuilder;
import kd.tmc.psd.business.service.period.model.SchePeriod;
import kd.tmc.psd.common.enums.ScheCycleEnum;
import kd.tmc.psd.common.enums.WorkCalendarTypeEnum;
import org.apache.commons.lang3.tuple.Pair;

public class DailySchePeriodCalc
extends AbstractSchePeriodCalc {
    private static Log logger = LogFactory.getLog(DailySchePeriodCalc.class);

    public DailySchePeriodCalc(List<ScheCalcResult> calcResult, SchePeriod schePeriod) {
        super(calcResult, schePeriod);
    }

    @Override
    protected void calculate(List<ScheCalcResult> calcResult, SchePeriod schePeriod) {
        Integer year = schePeriod.getYear();
        Date startDate = schePeriod.getStartDate();
        Date endDate = schePeriod.getEndDate();
        boolean isMerge = schePeriod.isMerge();
        Integer periodDay = schePeriod.getPeriodDay();
        Boolean isSkipHol = schePeriod.getIsSkipHol();
        List<Pair<Date, Boolean>> datePairs = this.getWorkDayCalendar();
        HashMap<Object, Integer> datePairsIndex = new HashMap<Object, Integer>(datePairs.size());
        for (int i = 0; i < datePairs.size(); ++i) {
            datePairsIndex.put(datePairs.get(i).getLeft(), i);
        }
        String cycle = schePeriod.getCycle();
        boolean isCrossMonth = ScheCycleEnum.YEAR.getValue().equals(cycle);
        Date currMaxDay = null;
        Date tempEndDate = null;
        int num = 1;
        int startIndex = 0;
        if (isSkipHol.booleanValue()) {
            for (int i = 0; i < datePairs.size() - 1 && ((Boolean)datePairs.get(i).getRight()).booleanValue(); ++i) {
                ++startIndex;
            }
        }
        int endIndex = startIndex + periodDay - 1;
        while (startDate.compareTo(endDate) <= 0) {
            int i;
            currMaxDay = DateUtils.getDataFormat((Date)DateUtils.getMaxMonthDate((Date)startDate), (boolean)true);
            for (i = startIndex; i < Math.min(endIndex, datePairs.size() - 1); ++i) {
                Pair<Date, Boolean> pair = datePairs.get(i);
                if (!((Boolean)pair.getRight()).booleanValue() || !isSkipHol.booleanValue()) continue;
                ++endIndex;
            }
            endIndex = Math.min(endIndex, datePairs.size() - 1);
            tempEndDate = (Date)datePairs.get(endIndex).getLeft();
            if (isSkipHol.booleanValue()) {
                for (i = endIndex + 1; i < datePairs.size() - 1 && ((Boolean)datePairs.get(i).getRight()).booleanValue(); ++i) {
                    ++endIndex;
                }
            }
            tempEndDate = (Date)datePairs.get(endIndex).getLeft();
            if (isMerge) {
                if (tempEndDate.compareTo(DateUtils.getLastDay((Date)endDate, (int)1)) == 0 && periodDay != 1) {
                    tempEndDate = endDate;
                }
                if (tempEndDate.compareTo(DateUtils.getLastDay((Date)currMaxDay, (int)1)) == 0 && periodDay != 1) {
                    tempEndDate = currMaxDay;
                }
            }
            if (!isCrossMonth && currMaxDay.compareTo(tempEndDate) <= 0) {
                tempEndDate = currMaxDay;
            }
            try {
                endIndex = (Integer)datePairsIndex.get(tempEndDate);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            ScheCalcResult result = ScheCalcResultBuilder.create().periodNum(num).name(this.getPeriodName(year, num)).startDate(startDate).endDate(tempEndDate).diffDays(periodDay).build();
            calcResult.add(result);
            startDate = DateUtils.getNextDay((Date)tempEndDate, (int)1);
            ++num;
            startIndex = endIndex + 1;
            endIndex = startIndex + periodDay - 1;
        }
    }

    @Override
    public List<ScheCalcResult> change(Integer index, Date startDate, Date endDate) {
        List<ScheCalcResult> calcResults = super.change(index, startDate, endDate);
        Boolean isSkipHol = this.schePeriod.getIsSkipHol();
        if (isSkipHol.booleanValue()) {
            this.resetDiffDays(calcResults, index);
        }
        return calcResults;
    }

    @Override
    public List<ScheCalcResult> delete(Integer index) {
        List<ScheCalcResult> calcResults = super.delete(index);
        Boolean isSkipHol = this.schePeriod.getIsSkipHol();
        if (isSkipHol.booleanValue()) {
            this.resetDiffDays(calcResults, index);
        }
        return calcResults;
    }

    @Override
    public List<ScheCalcResult> insert(Integer index) {
        List<ScheCalcResult> calcResults = super.insert(index);
        Boolean isSkipHol = this.schePeriod.getIsSkipHol();
        if (isSkipHol.booleanValue()) {
            this.resetDiffDays(calcResults, index);
        }
        return calcResults;
    }

    private void resetDiffDays(List<ScheCalcResult> calcResults, int index) {
        List<Pair<Date, Boolean>> datePairs = this.getWorkDayCalendar();
        int len = calcResults.size();
        for (int i = index; i < len; ++i) {
            ScheCalcResult result = calcResults.get(i);
            Integer diffDays = DateUtils.getDiffDays((Date)result.getStartDate(), (Date)result.getEndDate());
            int holiDays = this.calcWorkDays(datePairs, result.getStartDate(), result.getEndDate());
            result.setDiffDays(diffDays - holiDays);
        }
    }

    private int calcWorkDays(List<Pair<Date, Boolean>> datePairs, Date startDate, Date endDate) {
        int count = 0;
        Map<Date, Pair> datePairsIndex = datePairs.stream().collect(Collectors.toMap(Pair::getLeft, v -> v));
        while (startDate.compareTo(endDate) <= 0) {
            if (!((Boolean)datePairsIndex.get(DateUtils.getDataFormat((Date)startDate, (boolean)true)).getRight()).booleanValue()) {
                ++count;
            }
            startDate = DateUtils.getNextDay((Date)startDate, (int)1);
        }
        return count;
    }

    private List<Pair<Date, Boolean>> getWorkDayCalendar() {
        ArrayList<Pair<Date, Boolean>> datePairs = new ArrayList<Pair<Date, Boolean>>();
        if (this.schePeriod.getWorkCalandarId().compareTo(Long.valueOf("0")) == 0) {
            this.createPeriod(datePairs);
        } else {
            DynamicObject workCalendar = BusinessDataServiceHelper.loadSingle((Object)this.schePeriod.getWorkCalandarId(), (String)"tbd_workcalendar");
            DynamicObjectCollection dateEntrys = workCalendar.getDynamicObjectCollection("entitys");
            for (DynamicObject dateEntry : dateEntrys) {
                Date workDate = dateEntry.getDate("workdate");
                if (workDate.compareTo(this.schePeriod.getStartDate()) < 0 || workDate.compareTo(this.schePeriod.getEndDate()) > 0) continue;
                datePairs.add((Pair<Date, Boolean>)Pair.of((Object)workDate, (Object)dateEntry.getString("datetype").equals(WorkCalendarTypeEnum.RESTDAY.getValue())));
            }
            if (CollectionUtils.isEmpty(datePairs)) {
                this.createPeriod(datePairs);
            }
            Map dateMap = datePairs.stream().collect(Collectors.toMap(Pair::getLeft, v -> v, (o1, o2) -> o1, HashMap::new));
            Date tempStartDate = this.schePeriod.getStartDate();
            while (tempStartDate.compareTo(DateUtils.getCurrentDate()) < 0 && dateMap.get(tempStartDate) == null) {
                datePairs.add((Pair<Date, Boolean>)Pair.of((Object)tempStartDate, (Object)false));
                tempStartDate = DateUtils.getNextDay((Date)tempStartDate, (int)1);
            }
        }
        Collections.sort(datePairs, new Comparator<Pair<Date, Boolean>>(){

            @Override
            public int compare(Pair<Date, Boolean> arg0, Pair<Date, Boolean> arg1) {
                return ((Date)arg0.getLeft()).compareTo((Date)arg1.getLeft());
            }
        });
        return datePairs;
    }

    private void createPeriod(List<Pair<Date, Boolean>> datePairs) {
        Date tempDate = this.schePeriod.getStartDate();
        while (tempDate.compareTo(this.schePeriod.getEndDate()) <= 0) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(tempDate);
            datePairs.add((Pair<Date, Boolean>)Pair.of((Object)tempDate, (Object)(cal.get(7) == 7 || cal.get(7) == 1 ? 1 : 0)));
            tempDate = DateUtils.getNextDay((Date)tempDate, (int)1);
        }
    }
}

