/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.period.calc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.business.service.period.calc.AbstractSchePeriodCalc;
import kd.tmc.psd.business.service.period.model.ScheCalcResult;
import kd.tmc.psd.business.service.period.model.ScheCalcResultBuilder;
import kd.tmc.psd.business.service.period.model.SchePeriod;

public class FixedSchePeriodCalc
extends AbstractSchePeriodCalc {
    public FixedSchePeriodCalc(List<ScheCalcResult> calcResult, SchePeriod schePeriod) {
        super(calcResult, schePeriod);
    }

    @Override
    protected void calculate(List<ScheCalcResult> calcResult, SchePeriod schePeriod) {
        String[] fixedDays = schePeriod.getFixedDay();
        boolean containLastDay = false;
        ArrayList<Integer> fixeds = new ArrayList<Integer>();
        for (String day : fixedDays) {
            if (day.equals(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u5929", (String)"FixedSchePeriodCalc_0", (String)"tmc-psd-business", (Object[])new Object[0]))) {
                containLastDay = true;
                continue;
            }
            fixeds.add(Integer.valueOf(day));
        }
        Date startDate = schePeriod.getStartDate();
        Date endDate = schePeriod.getEndDate();
        Integer year = schePeriod.getYear();
        List<Date> splitDates = this.splitDate(startDate, endDate, fixeds, containLastDay);
        int len = splitDates.size() - 1;
        for (int k = 0; k < len; ++k) {
            startDate = k == 0 ? splitDates.get(k) : DateUtils.getNextDay((Date)splitDates.get(k), (int)1);
            endDate = splitDates.get(k + 1);
            ScheCalcResult result = ScheCalcResultBuilder.create().periodNum(k + 1).name(this.getPeriodName(year, k + 1)).startDate(startDate).endDate(endDate).diffDays(DateUtils.getDiffDays((Date)startDate, (Date)endDate)).build();
            calcResult.add(result);
        }
    }

    public List<Date> splitDate(Date startDate, Date endDate, List<Integer> fixedDays, boolean containLastDay) {
        ArrayList<Date> splitDates = new ArrayList<Date>();
        splitDates.add(startDate);
        int year = DateUtils.getYear((Date)startDate);
        int currMonth = DateUtils.getMonth((Date)startDate);
        int index = 1;
        Date pointDate = DateUtils.getNextDay((Date)startDate, (int)1);
        boolean isLoop = true;
        while (isLoop) {
            List<Integer> tempFixedDays = this.resetFixedDays(fixedDays, year, currMonth, containLastDay);
            int len = tempFixedDays.size();
            for (int i = 0; i < len; ++i) {
                if (index == 1 && i == 0) {
                    int firstIndex = this.getFirstEndDate(startDate, tempFixedDays);
                    if (firstIndex == -1) break;
                    i = firstIndex;
                }
                if ((pointDate = DateUtils.getAppointDay((int)year, (int)currMonth, (int)tempFixedDays.get(i))).after(endDate)) {
                    if (!splitDates.contains(endDate)) {
                        splitDates.add(endDate);
                    }
                    isLoop = false;
                    break;
                }
                splitDates.add(pointDate);
            }
            ++index;
            if (++currMonth <= 12) continue;
            currMonth = 1;
            ++year;
        }
        int size = splitDates.size();
        if (DateUtils.getDiffDays((Date)DateUtils.getNextDay((Date)((Date)splitDates.get(size - 2)), (int)1), (Date)((Date)splitDates.get(size - 1))) == 1) {
            splitDates.remove(size - 2);
        }
        return splitDates;
    }

    private List<Integer> resetFixedDays(List<Integer> fixedDays, int year, int currMonth, boolean containLastDay) {
        ArrayList<Integer> fixeds = new ArrayList<Integer>();
        int maxDays = DateUtils.getDaysByYearMonth((int)year, (int)currMonth);
        fixedDays.stream().filter(v -> v <= maxDays).forEach(o -> fixeds.add((Integer)o));
        if (containLastDay && !fixeds.contains(maxDays)) {
            fixeds.add(maxDays);
        }
        return fixeds;
    }

    private int getFirstEndDate(Date startDate, List<Integer> fixedDays) {
        int day = DateUtils.getDay((Date)startDate);
        int len = fixedDays.size();
        for (int i = 0; i < len; ++i) {
            Integer fixed = fixedDays.get(i);
            if (day < fixed) {
                return i;
            }
            if (day != fixed) continue;
            return i == len - 1 ? -1 : i + 1;
        }
        return -1;
    }
}

