/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.period.calc;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.business.service.period.calc.AbstractSchePeriodCalc;
import kd.tmc.psd.business.service.period.model.ScheCalcResult;
import kd.tmc.psd.business.service.period.model.ScheCalcResultBuilder;
import kd.tmc.psd.business.service.period.model.SchePeriod;

public class MonthlySchePeriodCalc
extends AbstractSchePeriodCalc {
    public MonthlySchePeriodCalc(List<ScheCalcResult> calcResult, SchePeriod schePeriod) {
        super(calcResult, schePeriod);
    }

    @Override
    protected void calculate(List<ScheCalcResult> calcResult, SchePeriod schePeriod) {
        Integer year = schePeriod.getYear();
        String periodTypeId = schePeriod.getPeriodTypeId();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("periodyear", "=", (Object)year));
        filters.add(new QFilter("periodtype", "=", (Object)Long.valueOf(periodTypeId)));
        filters.add(new QFilter("isadjustperiod", "=", (Object)"0"));
        DynamicObject[] periods = TmcDataServiceHelper.load((String)"bd_period", (String)"id,name,begindate,enddate,isadjustperiod,periodnumber", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (periods.length > 0) {
            int len = periods.length;
            for (int j = 0; j < len; ++j) {
                DynamicObject period = periods[j];
                ScheCalcResult result = ScheCalcResultBuilder.create().periodNum(j + 1).name(this.getPeriodName(year, j + 1)).startDate(period.getDate("begindate")).endDate(period.getDate("enddate")).diffDays(DateUtils.getDiffDays((Date)period.getDate("begindate"), (Date)period.getDate("enddate"))).build();
                calcResult.add(result);
            }
        } else {
            Date startDate = DateUtils.getYearFirst((int)year);
            for (int i = 1; i < 13; ++i) {
                Date endDate = DateUtils.getMaxMonthDate((Date)startDate);
                ScheCalcResult result = ScheCalcResultBuilder.create().periodNum(i).name(this.getPeriodName(year, i)).startDate(startDate).endDate(endDate).diffDays(DateUtils.getDiffDays((Date)startDate, (Date)endDate)).build();
                startDate = DateUtils.getNextDay((Date)endDate, (int)1);
                calcResult.add(result);
            }
        }
    }
}

