/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.service.period.calc;

import java.util.Date;
import java.util.List;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.business.service.period.calc.AbstractSchePeriodCalc;
import kd.tmc.psd.business.service.period.model.ScheCalcResult;
import kd.tmc.psd.business.service.period.model.ScheCalcResultBuilder;
import kd.tmc.psd.business.service.period.model.SchePeriod;

public class TenDaySchePeriodCalc
extends AbstractSchePeriodCalc {
    public TenDaySchePeriodCalc(List<ScheCalcResult> calcResult, SchePeriod schePeriod) {
        super(calcResult, schePeriod);
    }

    @Override
    protected void calculate(List<ScheCalcResult> calcResult, SchePeriod schePeriod) {
        Integer year = schePeriod.getYear();
        Date startDate = schePeriod.getStartDate();
        Date endDate = schePeriod.getEndDate();
        int periodDay = 10;
        for (int i = 1; i < 37; ++i) {
            if (i % 3 != 0) {
                periodDay = 10;
                endDate = DateUtils.getNextDay((Date)startDate, (int)(periodDay - 1));
            } else {
                endDate = DateUtils.getLastDayOfMonth((Date)startDate);
                periodDay = DateUtils.getDiffDays((Date)startDate, (Date)endDate);
            }
            ScheCalcResult result = ScheCalcResultBuilder.create().periodNum(i).name(this.getPeriodName(year, i)).startDate(startDate).endDate(endDate).diffDays(periodDay).build();
            calcResult.add(result);
            startDate = DateUtils.getNextDay((Date)endDate, (int)1);
        }
    }
}

