/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.task;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.psd.business.service.paysche.service.impl.PayScheDiffSplitService;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class DiffSplitTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(DiffSplitTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("----- \u5f00\u59cb\u6267\u884c\u5dee\u989d\u62c6\u5206\u7684\u81ea\u52a8\u4efb\u52a1 -----");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("balanceamt", "!=", (Object)BigDecimal.ZERO));
        filters.add(new QFilter("schedulstatus", "in", (Object)new String[]{ScheStatusEnum.YETSCHEDULE.getValue(), ScheStatusEnum.PAYING.getValue(), ScheStatusEnum.YETPAY.getValue()}));
        filters.add(new QFilter("nextscheduleid", "=", (Object)0));
        filters.add(new QFilter("freezestatus", "=", (Object)FreezeStatusEnum.UnFrozen.getValue()));
        DynamicObjectCollection scheBillArr = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        logger.info("\u5f53\u524d\u67e5\u8be2\u5230\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u7684\u6570\u91cf\u4e3a: {}", (Object)scheBillArr.size());
        Set ids = scheBillArr.stream().filter(Objects::nonNull).map(o -> o.getLong("id")).collect(Collectors.toSet());
        logger.info("\u5f00\u59cb\u8fdb\u884c\u672c\u6b21\u81ea\u52a8\u5dee\u989d\u62c6\u5206\u4efb\u52a1\u5904\u7406\u3002");
        DynamicObjectCollection scheBills = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        new PayScheDiffSplitService().dealDiffSplitOfPaySche(Arrays.asList(scheBills.toArray((Object[])new DynamicObject[0])));
        logger.info("\u672c\u6b21\u81ea\u52a8\u5dee\u989d\u62c6\u5206\u4efb\u52a1\u5904\u7406\u4efb\u52a1\u7ed3\u675f\u3002");
        logger.info("----- \u6267\u884c\u5dee\u989d\u62c6\u5206\u7684\u81ea\u52a8\u4efb\u52a1\u7ed3\u675f -----");
    }
}

