/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.task;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.psd.common.enums.PayScheRespEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayStatusFixTask
extends AbstractTask {
    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        DynamicObjectCollection idResult;
        Set payScheIdSet;
        Object retryCntParam = params.get("retry_cnt");
        int retryCnt = 5;
        if (retryCntParam != null) {
            try {
                retryCnt = Integer.parseInt(retryCntParam.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (retryCnt <= 0) {
                retryCnt = 5;
            }
        }
        if ((payScheIdSet = (idResult = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id", (QFilter[])this.getFilters(retryCnt))).stream().map(o -> o.getLong("id")).collect(Collectors.toSet())).size() > 0) {
            TmcOperateServiceHelper.execOperate((String)"fixstatus", (String)"psd_schedulebill", (Object[])payScheIdSet.toArray(), (OperateOption)OperateOption.create());
        }
    }

    private QFilter[] getFilters(int retryCnt) {
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        QFilter scheStatusFilter = new QFilter("schedulstatus", "=", (Object)ScheStatusEnum.PAYING.getValue());
        QFilter waitStatusFilter = new QFilter("payrespstatus", "in", Arrays.asList(PayScheRespEnum.UNKNOWN_ERR.getValue(), PayScheRespEnum.PUSH_ERR.getValue()));
        QFilter retryCntFilter = new QFilter("fixcnt", "<", (Object)retryCnt);
        return new QFilter[]{statusFilter, scheStatusFilter, waitStatusFilter, retryCntFilter};
    }
}

