/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.utils;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.DraftAmountLockSubInfo;
import kd.tmc.psd.business.service.paysche.data.DraftLockInfo;
import kd.tmc.psd.business.service.paysche.data.LockResult;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PaySchePropVal;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.service.DraftLockServiceHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.LoggerPrintHelper;
import kd.tmc.psd.common.untils.StringUtils;

public class PayScheduleUtil {
    private static final String ID = "id";
    private static Log logger = LogFactory.getLog(PayScheduleUtil.class);

    public static Map<Long, Boolean> isEntrust(List<Long> scheduleBillIds) {
        DynamicObjectCollection scheduleBills = QueryServiceHelper.query((String)"psd_schedulebill", (String)String.join((CharSequence)",", ID, "entrustpayid"), (QFilter[])new QFilter(ID, "in", scheduleBillIds).toArray());
        HashMap<Long, Boolean> isEntrustMap = new HashMap<Long, Boolean>(16);
        scheduleBills.forEach(paySchedule -> isEntrustMap.put(paySchedule.getLong(ID), EmptyUtil.isNoEmpty((Long)paySchedule.getLong("entrustpayid"))));
        return isEntrustMap;
    }

    public static Set<Long> getEntrustPayIdSet(List<Long> scheduleBillIds) {
        DynamicObjectCollection scheduleBills = QueryServiceHelper.query((String)"psd_schedulebill", (String)String.join((CharSequence)",", ID, "entrustpayid"), (QFilter[])new QFilter(ID, "in", scheduleBillIds).toArray());
        return scheduleBills.stream().filter(scheduleBill -> EmptyUtil.isNoEmpty((Long)scheduleBill.getLong("entrustpayid"))).map(scheduleBill -> scheduleBill.getLong("entrustpayid")).collect(Collectors.toSet());
    }

    public static List<Long> addSameEntrustScheduleId(List<Long> scheduleBillIds) {
        Set<Long> entrustPayIdSet = PayScheduleUtil.getEntrustPayIdSet(scheduleBillIds);
        if (EmptyUtil.isNoEmpty(entrustPayIdSet)) {
            HashSet<String> scheduleStatusSet = new HashSet<String>(8);
            scheduleStatusSet.add(ScheStatusEnum.TONEXT.getValue());
            scheduleStatusSet.add(ScheStatusEnum.AFRESHSCHE.getValue());
            scheduleStatusSet.add(ScheStatusEnum.YETCHARGEBACK.getValue());
            DynamicObjectCollection scheduleBills = QueryServiceHelper.query((String)"psd_schedulebill", (String)ID, (QFilter[])new QFilter[]{new QFilter("entrustpayid", "in", entrustPayIdSet), new QFilter("schedulstatus", "not in", scheduleStatusSet), new QFilter(ID, "not in", scheduleBillIds)});
            return EmptyUtil.isNoEmpty((DynamicObjectCollection)scheduleBills) ? scheduleBills.stream().map(s -> s.getLong(ID)).collect(Collectors.toList()) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public static DynamicObjectCollection querySameEntrustScheduleBill(List<Long> scheduleBillIds) {
        Set<Long> entrustPayIdSet = PayScheduleUtil.getEntrustPayIdSet(scheduleBillIds);
        if (EmptyUtil.isNoEmpty(entrustPayIdSet)) {
            HashSet<String> scheduleStatusSet = new HashSet<String>(8);
            scheduleStatusSet.add(ScheStatusEnum.TONEXT.getValue());
            scheduleStatusSet.add(ScheStatusEnum.AFRESHSCHE.getValue());
            scheduleStatusSet.add(ScheStatusEnum.YETCHARGEBACK.getValue());
            return QueryServiceHelper.query((String)"psd_schedulebill", (String)String.join((CharSequence)",", ID, "entrustpayid", "billno"), (QFilter[])new QFilter[]{new QFilter("entrustpayid", "in", entrustPayIdSet), new QFilter("schedulstatus", "not in", scheduleStatusSet)});
        }
        return null;
    }

    public static String getEntrustScheduleValidateMsg(ListSelectedRowCollection listSelectedData, String msg) {
        List<Long> selectedList = listSelectedData.stream().map(row -> Long.parseLong(row.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        Map<Long, Boolean> isEntrustMap = PayScheduleUtil.isEntrust(selectedList);
        return PayScheduleUtil.getEntrustScheduleValidateMsg(isEntrustMap, listSelectedData, msg);
    }

    public static String getEntrustScheduleValidateMsg(Map<Long, Boolean> isEntrustMap, ListSelectedRowCollection listSelectedData, String msg) {
        StringBuilder errMsg = new StringBuilder();
        listSelectedData.forEach(row -> {
            boolean isEntrust = isEntrustMap.getOrDefault(Long.parseLong(row.getPrimaryKeyValue().toString()), false);
            if (isEntrust) {
                if (EmptyUtil.isNoEmpty((String)errMsg.toString())) {
                    errMsg.append("\r\n");
                }
                errMsg.append(String.format(msg, row.getBillNo()));
            }
        });
        return errMsg.toString();
    }

    public static String getEntrustScheduleValidateMsg(List<DynamicObject> entrustScheduleList, String msg) {
        StringBuilder errMsg = new StringBuilder();
        entrustScheduleList.forEach(paySchedule -> {
            if (EmptyUtil.isNoEmpty((Long)paySchedule.getLong("e_entrustpayid"))) {
                if (EmptyUtil.isNoEmpty((String)errMsg.toString())) {
                    errMsg.append("\r\n");
                }
                errMsg.append(String.format(msg, paySchedule.getString("e_billno")));
            }
        });
        return errMsg.toString();
    }

    public static void processPayScheduleBillDelete(DynamicObject[] payScheBills, DraftLockServiceHelper draftLockServiceHelper) {
        ArrayList<DraftLockInfo> waitReleaseDraftInfos = new ArrayList<DraftLockInfo>(8);
        ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>(payScheBills.length);
        for (DynamicObject payScheBill : payScheBills) {
            String scheStatus;
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setSourceBillType(payScheBill.getDataEntityType().getName());
            draftLockInfo.setBizBillNo(payScheBill.getString("billno"));
            draftLockInfo.setSourceBillId(payScheBill.getLong(ID));
            String draftPayMethod = payScheBill.getString("draftpaymethod");
            boolean isDraftBook = "draftbook".equals(draftPayMethod);
            Object draftInfoEntrys = payScheBill.getDynamicObjectCollection("draftinfoentry");
            boolean isOld = false;
            if (EmptyUtil.isEmpty((Collection)draftInfoEntrys) && (payScheBill.getBoolean("ismasterdata") || !EmptyUtil.isNoEmpty((String)payScheBill.getString("batchnum")))) {
                DynamicObjectCollection draftnos = payScheBill.getDynamicObjectCollection("draftno");
                List draftnoIds = draftnos.stream().map(v -> v.getDynamicObject("fbasedataid").getLong(ID)).collect(Collectors.toList());
                DynamicObjectCollection draftArr = QueryServiceHelper.query((String)"cdm_draftbillf7", (String)"id,amount", (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)draftnoIds)});
                draftInfoEntrys = new ArrayList(draftArr);
                isOld = true;
            }
            ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (DynamicObject draftInfoEntry : draftInfoEntrys) {
                DraftAmountLockSubInfo needReleaseDraftAmountLockInfo = PayScheHelper.getReleaseLockInfo(payScheBill, isDraftBook, false, draftInfoEntry, isOld);
                draftAmountLockSubInfoList.add(needReleaseDraftAmountLockInfo);
            }
            if (EmptyUtil.isNoEmpty(draftAmountLockSubInfoList)) {
                draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
                waitReleaseDraftInfos.add(draftLockInfo);
            }
            if ((scheStatus = payScheBill.getString("schedulstatus")).equals(ScheStatusEnum.SCHEDULING.getValue())) {
                logger.info("\u6392\u7a0b\u4e2d\u7684\u6392\u7a0b\u5904\u7406\u5355\uff0c\u72b6\u6001\u6539\u4e3a\u672a\u6392\u7a0b\uff0c\u91d1\u989d\u7968\u636e\u6e05\u96f6");
                payScheBill.set("schedulstatus", (Object)ScheStatusEnum.NOSCHEDULE.getValue());
                payScheBill.set("amount", (Object)BigDecimal.ZERO);
                payScheBill.set("draftamt", (Object)BigDecimal.ZERO);
                payScheBill.set("scheduletotalamt", (Object)BigDecimal.ZERO);
                payScheBill.set("draftno", null);
                payScheBill.set("lcarrivalno", null);
            }
            Boolean isBillBids = payScheBill.getBoolean("isbilldibs");
            DynamicObject receiveBill = (DynamicObject)payScheBill.get("dibsbalance");
            if (isBillBids.booleanValue() && EmptyUtil.isNoEmpty((DynamicObject)receiveBill)) {
                JSONObject object = new JSONObject();
                object.put("receiveBillId", receiveBill.get(ID));
                object.put("isUsed", (Object)false);
                String batchNum = payScheBill.getString("batchnum");
                if (StringUtils.isNotEmpty((String)batchNum)) {
                    object.put("batchNum", (Object)batchNum);
                } else {
                    object.put("usesourcebill", (Object)payScheBill.getLong(ID));
                }
                jsonObjectList.add(object);
            }
            payScheBill.set("schedealid", null);
            payScheBill.set("scheduleeditnum", null);
            payScheBill.set("summaryid", null);
            payScheBill.set("batchnum", null);
            payScheBill.set("ismasterdata", (Object)false);
            if (isBillBids.booleanValue()) {
                payScheBill.set("isbilldibs", (Object)false);
                payScheBill.set("dibsbalance", null);
                payScheBill.set("balance", (Object)BigDecimal.ZERO);
            }
            DynamicObjectCollection draftinfoEntryCol = payScheBill.getDynamicObjectCollection("draftinfoentry");
            draftinfoEntryCol.clear();
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("mode", "proc_del");
        TmcOperateServiceHelper.execOperate((String)"save", (String)"psd_schedulebill", (DynamicObject[])payScheBills, (OperateOption)option);
        if (!waitReleaseDraftInfos.isEmpty()) {
            List<LockResult> lockResults = draftLockServiceHelper.releaseOrLockDraft(waitReleaseDraftInfos);
            logger.info("PayScheduleUtil Discard Result => " + LoggerPrintHelper.printCollectionLogger(lockResults));
        }
        logger.info("PayScheduleUtil:Release the receiving information::{}", (Object)((Object)jsonObjectList).toString());
        PayScheHelper.releaseReceiveBills(jsonObjectList);
    }

    public static List<PayScheCalcModel> getNotMergerScheduleDataList(List<PayScheCalcModel> allScheDataList) {
        return allScheDataList.stream().filter(Objects::nonNull).filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
    }

    public static void processExpectDate(List<PayScheCalcModel> scheDatas) {
        scheDatas.stream().forEach(scheData -> {
            Map<String, PaySchePropVal> dataMap = scheData.getDataMap();
            PaySchePropVal paySchePropVal = dataMap.get("e_expectdate");
            String payScheDataConfig = paySchePropVal.getPayScheDataSetting().trim();
            Object val = paySchePropVal.getData();
            if (!EmptyUtil.isEmpty((String)payScheDataConfig) && !"paysche".equals(payScheDataConfig)) {
                if ("0".equals(payScheDataConfig)) {
                    String timestamp = String.format("%s %s", DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd"), "00:00:00.000");
                    val = Timestamp.valueOf(timestamp);
                } else if (payScheDataConfig.trim().matches("[0-9]+")) {
                    Date nextDay = DateUtils.getNextDay((Date)new Date(), (int)Integer.parseInt(payScheDataConfig));
                    String timestamp = String.format("%s %s", DateUtils.formatString((Date)nextDay, (String)"yyyy-MM-dd"), "00:00:00.000");
                    val = Timestamp.valueOf(timestamp);
                } else {
                    throw new KDBizException(String.format("not support paysche data type: %s", payScheDataConfig));
                }
            }
            paySchePropVal.setData(val);
        });
    }
}

