/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.autoschedule;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.common.helper.PayScheHelper;
import org.apache.commons.lang3.ObjectUtils;

public class AutoScheduleRuleSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        HashSet orgIds = new HashSet(16);
        ArrayList autouleIds = new ArrayList(dataEntities.length);
        Arrays.stream(dataEntities).forEach(v -> {
            Date expiredDate;
            DynamicObject dataEntity = v.getDataEntity();
            Date enableDate = dataEntity.getDate("enabledate");
            if (enableDate != null && (expiredDate = dataEntity.getDate("expireddate")) != null && DateUtils.truncateDate((Date)expiredDate).before(DateUtils.truncateDate((Date)enableDate))) {
                this.addErrorMessage((ExtendedDataEntity)v, ResManager.loadKDString((String)"\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u542f\u7528\u65f6\u95f4\u3002", (String)"AutoScheduleRuleSaveValidator_8", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection applyOrgs = dataEntity.getDynamicObjectCollection("orgentryentity");
            Set applyOrgIds = applyOrgs.stream().filter(Objects::nonNull).map(o -> {
                Object obj = o.get("org");
                if (obj instanceof DynamicObject) {
                    return ((DynamicObject)obj).getLong("id");
                }
                if (obj instanceof Long) {
                    return (Long)obj;
                }
                return null;
            }).collect(Collectors.toSet());
            orgIds.addAll(applyOrgIds);
            autouleIds.add(dataEntity.getLong("id"));
        });
        if (0 == orgIds.size()) {
            DynamicObjectCollection validateAutoRules = QueryServiceHelper.query((String)"psd_autoschedule_rule", (String)"name,number,orgentryentity.org,enabledate,expireddate", (QFilter[])new QFilter[]{new QFilter("id", "not in", autouleIds), QFilter.isNull((String)"orgentryentity.org.id"), new QFilter("enable", "=", (Object)"1"), PayScheHelper.buildAutoRuleEffDateFilter()});
            if (0 < validateAutoRules.size()) {
                boolean needShowTips = Boolean.FALSE;
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject newRule = dataEntity.getDataEntity();
                    for (DynamicObject validateAutoRule : validateAutoRules) {
                        if (!PayScheHelper.effDateIsCoincident((DynamicObject)newRule, (DynamicObject)validateAutoRule)) continue;
                        needShowTips = Boolean.TRUE;
                        break;
                    }
                    if (!needShowTips) continue;
                    String name = validateAutoRules.stream().map(rule -> rule.getString("number")).collect(Collectors.joining(","));
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u9002\u7528\u7ec4\u7ec7\u4e3a\u7a7a\u7684\u89c4\u5219(%s)\uff0c\u6709\u6548\u65f6\u95f4\u5b58\u5728\u91cd\u53e0\u3002", (String)"AutoScheduleRuleSaveValidator_7", (String)"tmc-psd-business", (Object[])new Object[0]), name));
                }
            }
        } else {
            DynamicObject[] validateAutoRules = BusinessDataServiceHelper.load((String)"psd_autoschedule_rule", (String)"name,number,orgentryentity.org,enabledate,expireddate", (QFilter[])new QFilter[]{new QFilter("id", "not in", autouleIds), new QFilter("orgentryentity.org.id", "in", orgIds), new QFilter("enable", "=", (Object)"1")});
            if (0 < validateAutoRules.length) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject newRule = dataEntity.getDataEntity();
                    for (DynamicObject validateRule : validateAutoRules) {
                        String sameOrgName = PayScheHelper.hadSameOrg((DynamicObject)newRule, (DynamicObject)validateRule);
                        if (sameOrgName == null || !PayScheHelper.effDateIsCoincident((DynamicObject)newRule, (DynamicObject)validateRule)) continue;
                        String tipsFmt = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u542f\u7528\u72b6\u6001\u7684\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\u201c%2$s\u201d\u4e0e\u201c%3$s\u201d\u5b58\u5728\u542f\u7528\u671f\u95f4\u91cd\u53e0\uff0c\u8bf7\u8c03\u6574\u542f\u7528\u65e5\u671f\u8303\u56f4\u3002", (String)"PSD-E-842811", (String)"tmc-psd-business", (Object[])new Object[0]);
                        this.addErrorMessage(dataEntity, String.format(tipsFmt, sameOrgName, validateRule.getString("name"), newRule.getString("name")));
                    }
                }
            }
        }
        this.checkEntryOneKeySche(dataEntities);
    }

    private void checkEntryOneKeySche(ExtendedDataEntity[] dataEntities) {
        block0: for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject rule = dataEntity.getDataEntity();
            DynamicObjectCollection entryList = rule.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryList) {
                String msgFmt;
                boolean oneKeySche = entry.getBoolean("onekeysche");
                if (!oneKeySche) continue;
                BigDecimal scheRadio = (BigDecimal)ObjectUtils.defaultIfNull((Object)entry.getBigDecimal("scheradio"), (Object)BigDecimal.ZERO);
                BigDecimal scheDraftRadio = (BigDecimal)ObjectUtils.defaultIfNull((Object)entry.getBigDecimal("schedraftradio"), (Object)BigDecimal.ZERO);
                if (BigDecimal.ONE.compareTo(scheDraftRadio) != 0 && BigDecimal.ONE.compareTo(scheRadio) != 0) {
                    msgFmt = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u5f00\u542f\u4e00\u952e\u81ea\u52a8\u6392\u7a0b\u65f6,\u4ec5\u652f\u6301\u5168\u989d100%%\u6392\u6b3e\u6216\u5168\u989d100%%\u6392\u7968,\u8bf7\u91cd\u65b0\u786e\u8ba4\u89c4\u5219\u9879\u3010%s\u3011\u3002", (String)"AutoScheduleRuleSaveValidator_10", (String)"tmc-psd-business", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(msgFmt, entry.getString("e_rulename")));
                    continue block0;
                }
                if (BigDecimal.ONE.compareTo(scheRadio) == 0 && entry.get("rowchengtrule") == null) {
                    msgFmt = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u6392\u6b3e100%%\u65f6,\u89c4\u5219\u9879\u3010%s\u3011\u7684\u6392\u6b3e\u89c4\u5219\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AutoScheduleRuleSaveValidator_11", (String)"tmc-psd-business", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(msgFmt, entry.getString("e_rulename")));
                    continue block0;
                }
                DynamicObject ticketRule = entry.getDynamicObject("rowticketrule");
                if (BigDecimal.ONE.compareTo(scheDraftRadio) == 0 && ticketRule == null) {
                    String msgFmt2 = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u6392\u7968100%%\u65f6,\u89c4\u5219\u9879\u3010%s\u3011\u7684\u6392\u7968\u89c4\u5219\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"AutoScheduleRuleSaveValidator_12", (String)"tmc-psd-business", (Object[])new Object[0]);
                    this.addErrorMessage(dataEntity, String.format(msgFmt2, entry.getString("e_rulename")));
                    continue block0;
                }
                if (ticketRule == null || "draftpay".equals(ticketRule.getString("billpaytype"))) continue;
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u4e00\u952e\u6392\u7a0b\u8fdb\u884c\u5168\u989d\u6392\u7968\u65f6\u4ec5\u652f\u6301\u9009\u62e9 \u7968\u636e\u4ed8\u6b3e\u65b9\u5f0f=\u5f00\u7968\u4ed8\u6b3e \u7684\u6392\u7968\u89c4\u5219,\u8bf7\u786e\u8ba4\u3002", (String)"AutoScheduleRuleSaveValidator_13", (String)"tmc-psd-business", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg);
                continue block0;
            }
        }
    }
}

