/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.defaultacc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.psd.common.enums.EffectReasonEnum;

public class DefaultAccountSetSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entryentity");
        selector.add("entryentity.org");
        selector.add("entryentity.currency");
        selector.add("entryentity.banktype");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject dyObj = dataEntity.getDataEntity();
            String effectReason = dyObj.getString("effectreason");
            if (effectReason == null || !new ArrayList<String>(Arrays.asList(effectReason.split(","))).contains(EffectReasonEnum.ORG.getValue())) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f71\u54cd\u56e0\u7d20\u7ec4\u7ec7\u4e0d\u53ef\u53d6\u6d88\u3002", (String)"DefaultAccountSetSaveValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection entryData = dyObj.getDynamicObjectCollection("entryentity");
            HashMap<String, Integer> uniqueMap = new HashMap<String, Integer>(5);
            for (int i = 0; i < entryData.size(); ++i) {
                Integer put;
                DynamicObjectCollection payBillType;
                DynamicObjectCollection bankColl;
                StringBuilder sb = new StringBuilder();
                DynamicObject currObj = (DynamicObject)entryData.get(i);
                if (currObj.get("org") == null) continue;
                Object orgPkValue = currObj.getDynamicObject("org").getPkValue();
                sb.append(orgPkValue.toString());
                DynamicObjectCollection currencyColl = currObj.getDynamicObjectCollection("currency");
                if (currencyColl != null && currencyColl.size() > 0) {
                    List currencyIdList = currencyColl.stream().map(e -> e.getString("fbasedataid.id")).sorted(String::compareTo).collect(Collectors.toList());
                    sb.append(String.join((CharSequence)",", currencyIdList));
                }
                if ((bankColl = currObj.getDynamicObjectCollection("banktype")) != null && bankColl.size() > 0) {
                    List bankIdList = bankColl.stream().map(e -> e.getString("fbasedataid.id")).sorted(String::compareTo).collect(Collectors.toList());
                    sb.append(String.join((CharSequence)",", bankIdList));
                }
                if ((payBillType = currObj.getDynamicObjectCollection("paybilltype")) != null && payBillType.size() > 0) {
                    List payBillTypeIdList = payBillType.stream().map(e -> e.getString("fbasedataid.id")).sorted(String::compareTo).collect(Collectors.toList());
                    sb.append(String.join((CharSequence)",", payBillTypeIdList));
                }
                if ((put = uniqueMap.put(sb.toString(), i)) == null) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u6761\u4ef6\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002\u8bf7\u786e\u4fdd\u8d26\u6237\u6620\u5c04\u6761\u4ef6\u4e0d\u91cd\u590d\u3002", (String)"DefaultAccountSetSaveValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]), i + 1, put + 1));
            }
        }
    }
}

