/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PaySchBillChangeDateSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(2);
        selector.add("entryentity");
        selector.add("entryentity.schbillid");
        selector.add("entryentity.olddate");
        selector.add("entryentity.newdate");
        return selector;
    }

    public ValidateResult getValidateResult() {
        return super.getValidateResult();
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        List idList = Arrays.stream(extendedDataEntities).filter(i -> !Long.valueOf(0L).equals(i.getDataEntity().getPkValue())).map(i -> i.getDataEntity().getPkValue()).collect(Collectors.toList());
        Map dbDataMap = null;
        if (idList.size() > 0) {
            DynamicObject[] dbDataArr = TmcDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"psd_changedatebill"));
            dbDataMap = Arrays.stream(dbDataArr).collect(Collectors.toMap(i -> i.getPkValue(), Function.identity()));
        }
        List schBillIdList = Arrays.stream(extendedDataEntities).map(e -> e.getDataEntity().getDynamicObjectCollection("entryentity")).flatMap(Collection::stream).map(e -> Long.valueOf(e.get("schbillid").toString())).collect(Collectors.toList());
        DynamicObject[] schBillDataArr = TmcDataServiceHelper.load((Object[])schBillIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"));
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            Optional<DynamicObject> first = dataEntity.getDynamicObjectCollection("entryentity").stream().filter(i -> DateUtils.isSameDay((Date)i.getDate("olddate"), (Date)i.getDate("newdate"))).findFirst();
            if (first.isPresent()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53d8\u66f4\u540e\u6392\u7a0b\u4ed8\u6b3e\u65e5\u671f\u4e0d\u5f97\u7b49\u4e8e\u53d8\u66f4\u524d\u6392\u7a0b\u4ed8\u6b3e\u65e5\u671f\u3002", (String)"PaySchBillChangeDateSaveValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            if (dbDataMap != null && dbDataMap.get(dataEntity.getPkValue()) != null) continue;
            List currSchBillIdList = dataEntity.getDynamicObjectCollection("entryentity").stream().map(e -> e.getLong("schbillid")).collect(Collectors.toList());
            if (Arrays.stream(schBillDataArr).filter(e -> currSchBillIdList.contains(e.getPkValue()) && !ScheStatusEnum.NOSCHEDULE.getValue().equals(e.get("schedulstatus")) && !ScheStatusEnum.YETSCHEDULE.getValue().equals(e.get("schedulstatus"))).findFirst().isPresent()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u672a\u6392\u7a0b\u6216\u5df2\u6392\u7a0b\u7684\u6392\u7a0b\u5355\u624d\u80fd\u53d1\u8d77\u6539\u671f\u3002", (String)"PayScheBillErrorCode_6", (String)"tmc-psd-common", (Object[])new Object[0]));
            }
            if (!Arrays.stream(schBillDataArr).filter(e -> StringUtils.isNotEmpty((CharSequence)e.getString("batchnum"))).findFirst().isPresent()) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6392\u7a0b\u5355\u5df2\u5408\u5e76\uff0c\u65e0\u6cd5\u53d1\u8d77\u6539\u671f\u3002", (String)"PayScheBillErrorCode_7", (String)"tmc-psd-common", (Object[])new Object[0]));
        }
    }
}

