/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.errorcode.PayScheBillErrorCode;
import kd.tmc.psd.common.exception.PsdException;

public class PaySchBillChangeDateValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(5);
        selector.add("schedulstatus");
        selector.add("company");
        selector.add("batchnum");
        selector.add("freezestatus");
        selector.add("billno");
        return selector;
    }

    public ValidateResult getValidateResult() {
        return super.getValidateResult();
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        PayScheBillErrorCode payScheBillErrorCode = new PayScheBillErrorCode();
        long size = Arrays.stream(extendedDataEntities).map(e -> e.getDataEntity().getDynamicObject("company").get("id")).distinct().count();
        if (size > 1L) {
            throw new PsdException(payScheBillErrorCode.CHANGE_DATE_NOT_EQUALS_ORG());
        }
        if (Arrays.stream(extendedDataEntities).filter(e -> !ScheStatusEnum.NOSCHEDULE.getValue().equals(e.getDataEntity().get("schedulstatus")) && !ScheStatusEnum.YETSCHEDULE.getValue().equals(e.getDataEntity().get("schedulstatus"))).findFirst().isPresent()) {
            throw new PsdException(payScheBillErrorCode.CHANGE_DATE_STATUES());
        }
        if (Arrays.stream(extendedDataEntities).filter(e -> StringUtils.isNotEmpty((CharSequence)e.getDataEntity().getString("batchnum"))).findFirst().isPresent()) {
            throw new PsdException(payScheBillErrorCode.CHANGE_DATE_BATCHNUM());
        }
        boolean checkFreeze = Arrays.stream(extendedDataEntities).filter(e -> !FreezeStatusEnum.UnFrozen.getValue().equals(e.getDataEntity().getString("freezestatus"))).findFirst().isPresent();
        if (checkFreeze) {
            throw new PsdException(payScheBillErrorCode.FREEZE_STATUS_CHANGEDATE());
        }
        List<String> billNos = Arrays.stream(extendedDataEntities).map(e -> e.getDataEntity().getString("billno")).collect(Collectors.toList());
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u6539\u671f", (String)"PaySchBillChangeDateValidator_01", (String)"tmc-psd-business", (Object[])new Object[0]));
    }
}

