/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheBillAfreshScheValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("company");
        selector.add("schedulstatus");
        selector.add("batchnum");
        selector.add("paymenttype");
        selector.add("balanceamt");
        selector.add("schedealid");
        selector.add("expectdate");
        selector.add("applydate");
        selector.add("applyamt");
        selector.add("waitpayamt");
        selector.add("scheduletotalamt");
        selector.add("checktotalamt");
        selector.add("amount");
        selector.add("checkamt");
        selector.add("draftamt");
        selector.add("checkdraftamt");
        selector.add("draftno");
        selector.add("withdrawamt");
        selector.add("draftwithdrawamt");
        selector.add("withdrawtotalamt");
        selector.add("paymentno");
        selector.add("paybillstatus");
        selector.add("draftpayno");
        selector.add("draftpaystatus");
        selector.add("schedealid");
        selector.add("scheduleeditnum");
        selector.add("nopayamt");
        selector.add("draftnopayamt");
        selector.add("srcschedulenum");
        selector.add("prescheduleid");
        selector.add("sourcescheduleid");
        selector.add("createtime");
        selector.add("modifytime");
        selector.add("auditdate");
        selector.add("creator");
        selector.add("modifier");
        selector.add("auditor");
        selector.add("payeename");
        selector.add("itempayee");
        selector.add("billno");
        selector.add("payeebankname");
        selector.add("payeebanknum");
        selector.add("paycurrency");
        selector.add("currency");
        selector.add("settletype");
        selector.add("fundflowitem");
        selector.add("paymentchannel");
        selector.add("draftpaymethod");
        selector.add("draftpaychannel");
        selector.add("payeetype");
        selector.add("payeeacct");
        selector.add("payeebank");
        selector.add("sourcebilltype");
        selector.add("sourcebillnumber");
        selector.add("sourcebillid");
        selector.add("freezestatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Set dataEntitys = Arrays.stream(extendedDataEntities).filter(Objects::nonNull).filter(this.distinctByKey(o -> o.getDataEntity().getString("company"))).collect(Collectors.toSet());
        if (dataEntitys.size() > 1) {
            dataEntitys.stream().forEach(o -> this.addErrorMessage((ExtendedDataEntity)o, ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u6765\u81ea\u591a\u4e2a\u7ec4\u7ec7\u3002\u6bcf\u6b21\u53ea\u80fd\u9488\u5bf9\u540c\u4e00\u7ec4\u7ec7\u7684\u6392\u7a0b\u5355\u53d1\u8d77\u91cd\u6392\u3002", (String)"PayScheBillAfreshScheValidator_01", (String)"tmc-psd-business", (Object[])new Object[0])));
        }
        boolean result = true;
        ArrayList<String> billNos = new ArrayList<String>(extendedDataEntities.length);
        for (ExtendedDataEntity dataEntity : extendedDataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            String schedulStatus = data.getString("schedulstatus");
            billNos.add(data.getString("billno"));
            if (!ScheStatusEnum.YETSCHEDULE.getValue().equals(schedulStatus)) {
                result = false;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u91cd\u65b0\u6392\u7a0b\uff0c\u53ea\u6709\u5df2\u6392\u7a0b\u672a\u4ed8\u6b3e\u7684\u6392\u7a0b\u5355\u5141\u8bb8\u53d1\u8d77\u91cd\u6392\u3002", (String)"PayScheBillAfreshScheValidator_02", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            String freezeStatus = data.getString("freezestatus");
            if (FreezeStatusEnum.UnFrozen.getValue().equals(freezeStatus)) continue;
            result = false;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6392\u7a0b\u5355\u5df2\u51bb\u7ed3\uff0c\u65e0\u6cd5\u91cd\u65b0\u6392\u7a0b\u3002\u53ea\u6709\u672a\u51bb\u7ed3\u7684\u6392\u7a0b\u5355\u53ef\u53d1\u8d77\u91cd\u6392\u3002", (String)"PayScheBillAfreshScheValidator_05", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u91cd\u65b0\u6392\u7a0b", (String)"PayScheBillAfreshScheValidator_06", (String)"tmc-psd-business", (Object[])new Object[0]));
        if (result) {
            Arrays.stream(extendedDataEntities).filter(Objects::nonNull).forEach(o -> this.addMessage((ExtendedDataEntity)o, ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"PayScheBillAfreshScheValidator_03", (String)"tmc-psd-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u91cd\u65b0\u6392\u7a0b\u540e\u65e0\u6cd5\u53d6\u6d88\u91cd\u6392\u3002", (String)"PayScheBillAfreshScheValidator_04", (String)"tmc-psd-business", (Object[])new Object[0]), ErrorLevel.Warning));
        }
    }

    private <T> Predicate<T> distinctByKey(Function<? super T, Object> key) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(key.apply(t), Boolean.TRUE) == null;
    }
}

