/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheBillDiffSplitValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("expectpaydate");
        selector.add("expectdate");
        selector.add("waitpayamt");
        selector.add("applyamt");
        selector.add("batchnum");
        selector.add("issplit");
        selector.add("nextscheduleid");
        selector.add("prescheduleid");
        selector.add("schedulstatus");
        selector.add("balanceamt");
        selector.add("id");
        selector.add("freezestatus");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        ArrayList<String> billNos = new ArrayList<String>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dataEntityDy = dataEntity.getDataEntity();
            billNos.add(dataEntityDy.getString("billno"));
            BigDecimal balanceAmt = dataEntityDy.getBigDecimal("balanceamt");
            if (balanceAmt.compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6392\u7a0b\u4f59\u989d\u4e0d\u7b49\u4e8e0\u7684\u6392\u7a0b\u5355\u624d\u80fd\u8fdb\u884c\u5dee\u989d\u62c6\u5206\u3002", (String)"PayScheBillDiffSplitValidator_01", (String)"tmc-psd-business", (Object[])new Object[0]));
                continue;
            }
            String status = dataEntityDy.getString("schedulstatus");
            if (ScheStatusEnum.NOSCHEDULE.getValue().equals(status) || ScheStatusEnum.SCHEDULING.getValue().equals(status) || ScheStatusEnum.YETCHARGEBACK.getValue().equals(status) || ScheStatusEnum.TONEXT.getValue().equals(status) || ScheStatusEnum.AFRESHSCHE.getValue().equals(status) || ScheStatusEnum.CHANGEDATE.getValue().equals(status)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6392\u7a0b\u72b6\u6001\u4e3a\u5df2\u6392\u7a0b\u3001\u4ed8\u6b3e\u4e2d\u6216\u5df2\u4ed8\u6b3e\u7684\u6392\u7a0b\u5355\u624d\u80fd\u8fdb\u884c\u5dee\u989d\u62c6\u5206\u3002", (String)"PayScheBillDiffSplitValidator_02", (String)"tmc-psd-business", (Object[])new Object[0]));
                continue;
            }
            Long nextScheduleId = dataEntityDy.getLong("nextscheduleid");
            if (nextScheduleId != null && nextScheduleId != 0L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u672a\u8f6c\u4e0b\u671f\u7684\u6392\u7a0b\u5355\u53ef\u4ee5\u8fdb\u884c\u5dee\u989d\u62c6\u5206\u3002", (String)"PayScheBillDiffSplitValidator_03", (String)"tmc-psd-business", (Object[])new Object[0]));
                continue;
            }
            String freezeStatus = dataEntityDy.getString("freezestatus");
            if (FreezeStatusEnum.UnFrozen.getValue().equals(freezeStatus)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u672a\u51bb\u7ed3\u7684\u6392\u7a0b\u5355\u624d\u80fd\u8fdb\u884c\u5dee\u989d\u62c6\u5206", (String)"PayScheBillDiffSplitValidator_04", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u5dee\u989d\u62c6\u5206", (String)"PayScheBillDiffSplitValidator_05", (String)"tmc-psd-business", (Object[])new Object[0]));
    }
}

