/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.common.enums.PayScheRespEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheBillFixEntryValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("payrespstatus");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        ArrayList<String> billNos = new ArrayList<String>(extendedDataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject data = extendedDataEntity.getDataEntity();
            String scheStatus = data.getString("schedulstatus");
            String respStatus = data.getString("payrespstatus");
            billNos.add(data.getString("billno"));
            if (ScheStatusEnum.PAYING.getValue().equals(scheStatus) && (PayScheRespEnum.UNKNOWN_ERR.getValue().equals(respStatus) || PayScheRespEnum.PUSH_ERR.getValue().equals(respStatus))) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u4ed8\u6b3e\u4e2d\u4e14\u4ed8\u6b3e\u54cd\u5e94\u72b6\u6001\u4e0d\u4e3a\u7a7a\u7684\u6392\u7a0b\u5355\uff0c\u624d\u80fd\u4fee\u590d\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"PayScheBillFixEntryValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8865\u507f", (String)"PayScheBillFixEntryValidator_01", (String)"tmc-psd-business", (Object[])new Object[0]));
    }
}

