/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheBillOneKeyScheExpectDateValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>();
        selector.add("schedulstatus");
        selector.add("acctbank");
        selector.add("settletype");
        selector.add("paymentchannel");
        selector.add("expectdate");
        selector.add("freezestatus");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Map<ExtendedDataEntity, DynamicObject> map = this.convertMap(extendedDataEntities);
        for (Map.Entry<ExtendedDataEntity, DynamicObject> entry : map.entrySet()) {
            if (this.checkPreConditions(entry.getValue())) continue;
            ExtendedDataEntity extendedDataEntity = entry.getKey();
            DynamicObject payScheBill = entry.getValue();
            if (payScheBill.getDate("expectdate").compareTo(DateUtils.getCurrentDate()) >= 0) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u7684\u4ed8\u6b3e\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"PayScheBillPreOneKeyScheValidator_6", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
    }

    private boolean checkPreConditions(DynamicObject payScheBill) {
        boolean hasError = false;
        if (!Objects.equals(payScheBill.get("schedulstatus"), ScheStatusEnum.NOSCHEDULE.getValue())) {
            hasError = true;
        }
        if (Objects.isNull(payScheBill.get("acctbank"))) {
            hasError = true;
        }
        if (Objects.isNull(payScheBill.get("settletype"))) {
            hasError = true;
        }
        if (Objects.isNull(payScheBill.get("paymentchannel"))) {
            hasError = true;
        }
        return hasError;
    }

    private Map<ExtendedDataEntity, DynamicObject> convertMap(ExtendedDataEntity[] extendedDataEntities) {
        Object[] pkIds = Arrays.stream(extendedDataEntities).map(e -> e.getDataEntity().getPkValue()).toArray();
        DynamicObjectCollection scheBills = QueryServiceHelper.query((String)"psd_schedulebill", (String)"id,expectdate,schedulstatus,acctbank,settletype,paymentchannel,freezestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
        HashMap<ExtendedDataEntity, DynamicObject> map = new HashMap<ExtendedDataEntity, DynamicObject>();
        for (DynamicObject scheBill : scheBills) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                if (!Objects.equals(scheBill.get("id"), extendedDataEntity.getBillPkId())) continue;
                map.put(extendedDataEntity, scheBill);
            }
        }
        return map;
    }
}

