/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BankInterFaceEnum;
import kd.tmc.fbp.common.enums.PayBusinessTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.PayChannelEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.enums.SettleMentTypeEnum;

public class PayScheBillOneKeyScheValidator
extends AbstractTmcBizOppValidator {
    private boolean hasError = false;

    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(8);
        selector.add("schedulstatus");
        selector.add("acctbank");
        selector.add("settletype");
        selector.add("paymentchannel");
        selector.add("expectdate");
        selector.add("freezestatus");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Map<ExtendedDataEntity, DynamicObject> map = this.convertMap(extendedDataEntities);
        for (Map.Entry<ExtendedDataEntity, DynamicObject> entry : map.entrySet()) {
            this.checkPreConditions(entry.getKey(), entry.getValue());
        }
        List<String> billNos = Arrays.stream(extendedDataEntities).map(e -> e.getDataEntity().getString("billno")).collect(Collectors.toList());
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u4e00\u952e\u6392\u7a0b", (String)"PayScheBillPreOneKeyScheValidator_12", (String)"tmc-psd-business", (Object[])new Object[0]));
        if (this.hasError) {
            return;
        }
        this.checkBusiness(map);
    }

    private Map<ExtendedDataEntity, DynamicObject> convertMap(ExtendedDataEntity[] extendedDataEntities) {
        Object[] pkIds = Arrays.stream(extendedDataEntities).map(e -> e.getDataEntity().getPkValue()).toArray();
        DynamicObject[] scheBills = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        HashMap<ExtendedDataEntity, DynamicObject> map = new HashMap<ExtendedDataEntity, DynamicObject>();
        for (DynamicObject scheBill : scheBills) {
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                if (!Objects.equals(scheBill.getPkValue(), extendedDataEntity.getBillPkId())) continue;
                map.put(extendedDataEntity, scheBill);
            }
        }
        return map;
    }

    private void checkPreConditions(ExtendedDataEntity extendedDataEntity, DynamicObject payScheBill) {
        if (!Objects.equals(payScheBill.get("schedulstatus"), ScheStatusEnum.NOSCHEDULE.getValue())) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u672a\u6392\u7a0b\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u3002", (String)"PayScheBillPreOneKeyScheValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
            this.hasError = true;
        }
        ArrayList<String> errList = new ArrayList<String>();
        DynamicObject settleType = payScheBill.getDynamicObject("settletype");
        if (Objects.isNull(payScheBill.get("acctbank"))) {
            errList.add(ResManager.loadKDString((String)"\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237", (String)"PayScheBillPreOneKeyScheValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        if (Objects.isNull(settleType)) {
            errList.add(ResManager.loadKDString((String)"\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f", (String)"PayScheBillPreOneKeyScheValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        if (Objects.isNull(payScheBill.get("paymentchannel"))) {
            errList.add(ResManager.loadKDString((String)"\u6392\u6b3e\u652f\u4ed8\u6e20\u9053", (String)"PayScheBillPreOneKeyScheValidator_3", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        if (settleType != null && StringUtils.equals((CharSequence)SettleMentTypeEnum.DIGITALWALLET.getValue(), (CharSequence)settleType.getString("settlementtype"))) {
            String businessType = payScheBill.getString("businesstype");
            if (EmptyUtil.isEmpty((String)businessType)) {
                errList.add(ResManager.loadKDString((String)"\u6392\u7a0b\u4e1a\u52a1\u7c7b\u578b", (String)"PayScheBillPreOneKeyScheValidator_13", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            if (StringUtils.equals((CharSequence)businessType, (CharSequence)PayBusinessTypeEnum.WALLETUP.getValue())) {
                if (EmptyUtil.isEmpty((String)payScheBill.getString("institutioncode"))) {
                    errList.add(ResManager.loadKDString((String)"\u6392\u6b3e\u8fd0\u8425\u5546\u673a\u6784\u7f16\u53f7", (String)"PayScheBillPreOneKeyScheValidator_14", (String)"tmc-psd-business", (Object[])new Object[0]));
                }
                if (EmptyUtil.isEmpty((String)payScheBill.getString("institutionname"))) {
                    errList.add(ResManager.loadKDString((String)"\u6392\u6b3e\u8fd0\u8425\u5546\u673a\u6784\u540d\u79f0", (String)"PayScheBillPreOneKeyScheValidator_15", (String)"tmc-psd-business", (Object[])new Object[0]));
                }
            }
        }
        if (!errList.isEmpty()) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheBillPreOneKeyScheValidator_4", (String)"tmc-psd-business", (Object[])new Object[0]), String.join((CharSequence)"\u3001", errList)));
            this.hasError = true;
        }
    }

    private void checkBusiness(Map<ExtendedDataEntity, DynamicObject> map) {
        for (Map.Entry<ExtendedDataEntity, DynamicObject> entry : map.entrySet()) {
            String paymentChannel;
            ExtendedDataEntity extendedDataEntity = entry.getKey();
            DynamicObject payScheBill = entry.getValue();
            this.checkExpectDate(extendedDataEntity, payScheBill);
            DynamicObject accountBank = payScheBill.getDynamicObject("acctbank");
            DynamicObjectCollection currencyCollection = accountBank.getDynamicObjectCollection("currency");
            List currencyIds = currencyCollection.stream().map(c -> c.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            if (!currencyIds.contains(payScheBill.getDynamicObject("paycurrency").getPkValue())) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u7684\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u6240\u9009\u7684\u4ed8\u6b3e\u5e01\u79cd\u3002", (String)"PayScheBillPreOneKeyScheValidator_7", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            DynamicObject settleType = payScheBill.getDynamicObject("settletype");
            DynamicObjectCollection settleTypeCollection = accountBank.getDynamicObjectCollection("settlementtype");
            List settleTypeIds = settleTypeCollection.stream().map(c -> c.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList());
            if (!settleTypeCollection.isEmpty() && !settleTypeIds.contains(settleType.getPkValue())) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u7684\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u7ed3\u7b97\u65b9\u5f0f\u201c%s\u201d\u3002", (String)"PayScheBillPreOneKeyScheValidator_8", (String)"tmc-psd-business", (Object[])new Object[0]), settleType.getString("name")));
            }
            if (Objects.equals(paymentChannel = payScheBill.getString("paymentchannel"), PayChannelEnum.BEI.getValue()) && !Objects.equals(accountBank.get("issetbankinterface"), BankInterFaceEnum.CONNECT.getValue())) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u76f4\u8fde\u3002", (String)"PayScheBillPreOneKeyScheValidator_9", (String)"tmc-psd-business", (Object[])new Object[0]));
            } else if (Objects.equals(paymentChannel, PayChannelEnum.ONLINEBANK.getValue()) && !accountBank.getBoolean("isopenbank")) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u7f51\u4e0a\u94f6\u884c\u3002", (String)"PayScheBillPreOneKeyScheValidator_10", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            String freezeStatus = payScheBill.getString("freezestatus");
            if (FreezeStatusEnum.UnFrozen.getValue().equals(freezeStatus)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u51bb\u7ed3\u7684\u6570\u636e\u65e0\u6cd5\u8fdb\u884c\u4e00\u952e\u6392\u7a0b\u64cd\u4f5c\u3002", (String)"PayScheBillPreOneKeyScheValidator_11", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
    }

    private void checkExpectDate(ExtendedDataEntity extendedDataEntity, DynamicObject payScheBill) {
        if (Objects.isNull(payScheBill.get("expectdate"))) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u7684\u6392\u7a0b\u4ed8\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheBillPreOneKeyScheValidator_5", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
    }
}

