/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.common.enums.PsdParamEnum;
import kd.tmc.psd.common.helper.PsdParameterHelper;

public class PayScheBillSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebilltype");
        selector.add("billno");
        selector.add("company");
        selector.add("sourcebillid");
        selector.add("srcpaytotalamt");
        selector.add("sourcebillentryid");
        selector.add("schedulstatus");
        selector.add("applyamt");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        boolean enablePaySche = true;
        Map variables = this.getOption().getVariables();
        if (variables != null && !variables.isEmpty() && variables.containsKey("isEnablePayScheCheck")) {
            enablePaySche = Optional.ofNullable(variables.get("isEnablePayScheCheck")).map(o -> Boolean.valueOf(o)).orElseGet(() -> true);
        }
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject companyDO;
            boolean sysParm;
            DynamicObject payScheBill = data.getDataEntity();
            String sourcebilltype = payScheBill.getString("sourcebilltype");
            if (EmptyUtil.isEmpty((String)sourcebilltype) || payScheBill.getDataEntityState().getFromDatabase() || (sysParm = PsdParameterHelper.getAppBoolParameter((long)((Long)(companyDO = payScheBill.getDynamicObject("company")).getPkValue()), (String)PsdParamEnum.PSD001.getValue())) || !enablePaySche) continue;
            String errorMessage = ResManager.loadKDString((String)"%s\uff1a\u8be5\u7ec4\u7ec7\u6ca1\u6709\u5f00\u542f\u662f\u5426\u542f\u7528\u4ed8\u6b3e\u6392\u7a0b\u53c2\u6570\uff0c\u4e0d\u80fd\u4e0b\u63a8\u4ed8\u6b3e\u6392\u7a0b\u5355\u3002", (String)"PayScheBillSaveValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(errorMessage, data.getBillNo()));
        }
    }
}

