/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.business.service.period.PeriodHelper;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.errorcode.PayScheBillErrorCode;
import kd.tmc.psd.common.exception.PsdException;
import kd.tmc.psd.common.helper.PsdParameterHelper;

public class PayScheBillStartScheValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("company");
        selector.add("schedulstatus");
        selector.add("expectdate");
        selector.add("freezestatus");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List freezeBillLst;
        PayScheBillErrorCode payScheBillErrorCode = new PayScheBillErrorCode();
        List payScheBills = Arrays.stream(dataEntity).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        List illegalStatusBills = payScheBills.stream().filter(v -> !v.getString("schedulstatus").equals(ScheStatusEnum.NOSCHEDULE.getValue())).map(v -> v).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(illegalStatusBills)) {
            throw new PsdException(payScheBillErrorCode.ILLEGAL_STATUS());
        }
        List orgIdList = payScheBills.stream().map(v -> v.getDynamicObject("company").getPkValue()).distinct().collect(Collectors.toList());
        if (orgIdList.size() > 1) {
            throw new PsdException(payScheBillErrorCode.MUTEX_ORG_EXIST());
        }
        List expectDates = payScheBills.stream().map(v -> DateUtils.getDataFormat((Date)v.getDate("expectdate"), (boolean)true)).collect(Collectors.toList());
        Date maxExpectDate = (Date)expectDates.get(0);
        Date minExpectDate = (Date)expectDates.get(0);
        for (Date expectDate : expectDates) {
            minExpectDate = expectDate.compareTo(minExpectDate) < 0 ? expectDate : minExpectDate;
            maxExpectDate = expectDate.compareTo(maxExpectDate) > 0 ? expectDate : maxExpectDate;
        }
        boolean isOnTimeSche = PsdParameterHelper.getAppBoolParameter((long)((Long)orgIdList.get(0)), (String)"ontimesche");
        if (isOnTimeSche) {
            DynamicObject[] schePeriods = PeriodHelper.getPeriodByDates(orgIdList.get(0), minExpectDate, maxExpectDate);
            if (schePeriods.length == 0) {
                throw new PsdException(payScheBillErrorCode.PERIOD_NOT_EXIST());
            }
            if (schePeriods.length > 1) {
                throw new PsdException(payScheBillErrorCode.MUTEX_EXPECTDATE_EXIST());
            }
            Date currentDate = DateUtils.getDataFormat((Date)DateUtils.getCurrentDate(), (boolean)true);
            DynamicObject schePeriod = schePeriods[0];
            if (schePeriod.getDate("enddate").compareTo(currentDate) < 0) {
                throw new PsdException(payScheBillErrorCode.EXPECTDATE_BEFORE_CURR());
            }
        }
        if ((freezeBillLst = payScheBills.stream().filter(Objects::nonNull).filter(v -> !v.getString("freezestatus").equals(FreezeStatusEnum.UnFrozen.getValue())).map(v -> v).collect(Collectors.toList())).size() > 0) {
            throw new PsdException(payScheBillErrorCode.FREEZE_STATUS());
        }
        List<String> billNos = Arrays.stream(dataEntity).map(e -> e.getDataEntity().getString("billno")).collect(Collectors.toList());
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u53d1\u8d77\u6392\u7a0b", (String)"PayScheBillStartScheValidator_01", (String)"tmc-psd-business", (Object[])new Object[0]));
    }
}

