/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.common.enums.PriorityEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheCancelPayValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selectors = new ArrayList<String>(1);
        selectors.add("billno");
        return selectors;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        List payScheBills = Arrays.stream(dataEntity).map(v -> v.getDataEntity()).collect(Collectors.toList());
        List opBillIds = payScheBills.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        ArrayList<String> batchNums = new ArrayList<String>(dataEntity.length);
        ArrayList<String> billNos = new ArrayList<String>(dataEntity.length);
        for (DynamicObject payScheBill : payScheBills) {
            String batchNum = payScheBill.getString("batchnum");
            if (!EmptyUtil.isNotEmpty((CharSequence)batchNum)) continue;
            batchNums.add(batchNum);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"psd_schedulebill");
        DynamicObject[] combineBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("batchnum", "in", batchNums), new QFilter("id", "not in", opBillIds)});
        Stream.of(combineBills).forEach(p -> opBillIds.add(p.getPkValue()));
        if (opBillIds.size() > 0) {
            combineBills = TmcDataServiceHelper.load((Object[])opBillIds.toArray(), (DynamicObjectType)targetMainType);
        }
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject payScheBill = data.getDataEntity();
            String scheStatus = payScheBill.getString("schedulstatus");
            billNos.add(payScheBill.getString("billno"));
            if (!scheStatus.equals(ScheStatusEnum.PAYING.getValue())) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u4e2d\u5355\u636e\u624d\u5141\u8bb8\u64a4\u56de", (String)"PayScheCancelPayValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            DynamicObjectCollection entrys = payScheBill.getDynamicObjectCollection("entrys");
            for (DynamicObject entry : entrys) {
                String type = entry.getString("e_billtype");
                if (!"paybill".equals(type)) continue;
                String payId = entry.getString("e_payid");
                DynamicObject payBillObj = BusinessDataServiceHelper.loadSingle((Object)payId, (String)"cas_paybill", (String)"id,number,priority");
                if (!PriorityEnum.DEFER.getValue().equals(payBillObj.getString("priority"))) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6682\u7f13\u4ed8\u6b3e\u5355\u636e\u4e0d\u5141\u8bb8\u64a4\u56de\u3002", (String)"PayScheCancelPayValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
        }
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u64a4\u56de", (String)"PayScheCancelPayValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]));
    }
}

