/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheDelValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("scheduleeditnum");
        selector.add("expectdate");
        selector.add("currency");
        selector.add("fundflowitem");
        selector.add("amount");
        selector.add("settletype");
        selector.add("acctbank");
        selector.add("paymentchannel");
        selector.add("draftamt");
        selector.add("draftpaymethod");
        selector.add("draftsettletype");
        selector.add("draftno");
        selector.add("applyamt");
        selector.add("balanceamt");
        selector.add("payid");
        selector.add("payentryid");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        selector.add("sourcebillentryid");
        selector.add("acctbanktype");
        selector.add("scheduletotalamt");
        selector.add("paymentno");
        selector.add("draftpaystatus");
        selector.add("paybillstatus");
        selector.add("nopayamt");
        selector.add("batchnum");
        selector.add("entrys");
        selector.add("e_payid");
        selector.add("e_payentryid");
        selector.add("e_billtype");
        selector.add("paycurrency");
        selector.add("draftpaychannel");
        selector.add("exchangerate");
        selector.add("exratetable");
        selector.add("draftno");
        selector.add("waitpayamt");
        selector.add("transferpost");
        selector.add("issplit");
        selector.add("isexistchangedate");
        selector.add("splitno");
        selector.add("prescheduleid");
        selector.add("paymenttype");
        selector.add("sourcebilltype");
        selector.add("entrustpayid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntitys) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            boolean isChangeDate;
            DynamicObject payScheBill = dataEntity.getDataEntity();
            String schedulStatus = payScheBill.getString("schedulstatus");
            if (!ScheStatusEnum.NOSCHEDULE.getValue().equals(schedulStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u672a\u6392\u7a0b\u7684\u6570\u636e\u624d\u5141\u8bb8\u5220\u9664\u64cd\u4f5c\u3002", (String)"PayScheDelValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            if (isChangeDate = payScheBill.getBoolean("isexistchangedate")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u4ed8\u6b3e\u6392\u7a0b\u5355\u5b58\u5728\u6539\u671f\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PayScheDelValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            if (EmptyUtil.isNoEmpty((Long)payScheBill.getLong("prescheduleid"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u4ed8\u6b3e\u6392\u7a0b\u5355\u4e3a\u8f6c\u671f\u751f\u6210\u7684\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PayScheDelValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
            if (!EmptyUtil.isNoEmpty((Long)payScheBill.getLong("entrustpayid"))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c{0}\u201d\u7531\u59d4\u6258\u4ed8\u6b3e\u751f\u6210\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u6216\u53d6\u6d88\u5408\u5e76\u6216\u5220\u9664\u3002", (String)"PayScheDelValidator_4", (String)"tmc-psd-business", (Object[])new Object[]{payScheBill.getString("billno")}));
        }
    }
}

