/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.common.enums.PayScheRespEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheDiscardValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("schedulstatus");
        selector.add("payrespstatus");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        ArrayList<String> billNos = new ArrayList<String>(dataEntity.length);
        for (ExtendedDataEntity entity : dataEntity) {
            String payRespStatus = entity.getDataEntity().getString("payrespstatus");
            String scheStatus = entity.getDataEntity().getString("schedulstatus");
            billNos.add(entity.getDataEntity().getString("billno"));
            if (ScheStatusEnum.PAYING.getValue().equals(scheStatus) && PayScheRespEnum.PUSH_ERR.getValue().equals(payRespStatus)) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u53ea\u6709\u4ed8\u6b3e\u72b6\u6001\u4e3a\u201c\u4ed8\u6b3e\u4e2d\u201d\u4e14\u4ed8\u6b3e\u54cd\u5e94\u72b6\u6001\u4e3a\u201c\u4e0b\u63a8\u4ed8\u6b3e\u5931\u8d25\u201d\u7684\u6392\u7a0b\u5355\u624d\u80fd\u4f5c\u5e9f\u3002", (String)"PayScheDiscardValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"PayScheDiscardValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]));
    }
}

