/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PayScheSaveDraftValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Set payscheIds = Arrays.stream(extendedDataEntities).map(o -> o.getDataEntity().getPkValue()).collect(Collectors.toSet());
        DynamicObject[] payScheBillFromDB = TmcDataServiceHelper.load((Object[])payscheIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedulebill"));
        HashMap payScheBillFromDBMap = Arrays.stream(payScheBillFromDB).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v, (o1, o2) -> o1, HashMap::new));
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject scheBill = extendedDataEntity.getDataEntity();
            String batchNum = scheBill.getString("batchnum");
            boolean isMasterData = scheBill.getBoolean("ismasterdata");
            if (batchNum != null && EmptyUtil.isNoEmpty((String)batchNum) && !isMasterData) continue;
            DynamicObject scheBillFromDB = (DynamicObject)payScheBillFromDBMap.get(scheBill.getPkValue());
            Set<Object> lockedDraftnoFromDB = this.getDraftIds(scheBillFromDB);
            Set<Object> currNeedLockDraftno = this.getDraftIds(scheBill);
            HashSet<Object> tempDraftIds = new HashSet<Object>();
            tempDraftIds.clear();
            tempDraftIds.addAll(currNeedLockDraftno);
            tempDraftIds.removeAll(lockedDraftnoFromDB);
            if (CollectionUtils.isEmpty(tempDraftIds)) continue;
            ArrayList<String> errMsgs = new ArrayList<String>(tempDraftIds.size());
            DynamicObject[] draftDBInfoArr = TmcDataServiceHelper.load((String)"cdm_payandrecdraft_f7", (String)"id,draftbillno,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", tempDraftIds)});
            Map<Object, List<DynamicObject>> draftInfosFormDB = Arrays.stream(draftDBInfoArr).collect(Collectors.groupingBy(o -> o.getPkValue()));
            DynamicObjectCollection draftEntrys = scheBill.getDynamicObjectCollection("draftinfoentry");
            for (DynamicObject draftEntry : draftEntrys) {
                BigDecimal currAvailableAmount;
                DynamicObject draftInfoFormDB;
                BigDecimal currTransferAmt = draftEntry.getBigDecimal("de_transferamt");
                Object draftId = draftEntry.get("de_draftinfo");
                if (draftId instanceof DynamicObject) {
                    draftId = ((DynamicObject)draftId).getPkValue();
                }
                if (draftInfosFormDB.get(draftId) == null || (draftInfoFormDB = draftInfosFormDB.get(draftId).get(0)) == null || (currAvailableAmount = draftInfoFormDB.getBigDecimal("availableamount")).compareTo(currTransferAmt) >= 0) continue;
                String errMsg = String.format(ResManager.loadKDString((String)"%1$s \u6392\u7a0b\u5355\u5bf9\u5e94 %2$s \u7968\u9762\u4fe1\u606f\u8f6c\u8ba9\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7968\u636e\u7684\u53ef\u7528\u91d1\u989d\uff0c\u5f53\u524d\u8f6c\u8ba9\u91d1\u989d\u4e3a %3$s\uff0c\u53ef\u7528\u91d1\u989d\u4e3a %4$s\uff0c\u8bf7\u4fee\u6539", (String)"PayScheSaveOfDraftInfoValidator_4", (String)"tmc-psd-business", (Object[])new Object[0]), scheBill.getString("billno"), draftInfoFormDB.getString("draftbillno"), currTransferAmt, currAvailableAmount.toPlainString());
                errMsgs.add(errMsg);
            }
            if (errMsgs.isEmpty()) continue;
            this.addErrorMessage(extendedDataEntity, errMsgs.stream().collect(Collectors.joining("\r\n")));
        }
    }

    private Set<Object> getDraftIds(DynamicObject scheBill) {
        if (null == scheBill) {
            return new HashSet<Object>();
        }
        DynamicObjectCollection draftnoList = scheBill.getDynamicObjectCollection("draftno");
        Set<Object> draftnoIds = draftnoList.stream().filter(v -> v.getDynamicObject("fbasedataid") != null).map(v -> v.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
        return draftnoIds;
    }
}

