/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheDraftInfo;

public class PayScheSaveOrSubmitOfDraftInfoValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        String cacheDateStr = this.getOption().getVariableValue("key_payschemodel", "");
        if (EmptyUtil.isNoEmpty((String)cacheDateStr)) {
            List<PayScheCalcModel> scheDataList = PayScheCalcModel.deserializeList(cacheDateStr);
            scheDataList = scheDataList.stream().filter(o -> EmptyUtil.isNoEmpty(o.getPayScheDraftInfos())).filter(o -> o.isArchiveMerger() || EmptyUtil.isEmpty((String)o.getBatchnum())).collect(Collectors.toList());
            for (PayScheCalcModel payScheCalcModel : scheDataList) {
                List<PayScheDraftInfo> payScheDraftInfos;
                List lessZeroTransferAmtModel;
                String mark = payScheCalcModel.isArchiveMerger() ? String.format("BatchNo=%s", payScheCalcModel.getBatchnum()) : payScheCalcModel.getScheNumber();
                Optional<PayScheDraftInfo> anyEmptyTransferAmtOp = payScheCalcModel.getPayScheDraftInfos().stream().filter(o -> EmptyUtil.isEmpty((BigDecimal)o.getTransferAmt())).findAny();
                if (anyEmptyTransferAmtOp.isPresent()) {
                    this.addErrorMessage(extendedDataEntities[0], String.format(ResManager.loadKDString((String)"%s \u6392\u7a0b\u5355\u5bf9\u5e94\u7684\u7968\u9762\u4fe1\u606f\u5185\u7684\u7968\u636e\u8f6c\u8ba9\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (String)"PayScheSaveOfDraftInfoValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
                }
                if (payScheCalcModel.isBillDibs().booleanValue()) continue;
                BigDecimal draftBillAmt = payScheCalcModel.getDraftBillAmt();
                if (EmptyUtil.isEmpty((BigDecimal)draftBillAmt)) {
                    draftBillAmt = BigDecimal.ZERO;
                }
                if (!(lessZeroTransferAmtModel = (payScheDraftInfos = payScheCalcModel.getPayScheDraftInfos()).stream().filter(o -> BigDecimal.ZERO.compareTo(o.getTransferAmt()) > 0).collect(Collectors.toList())).isEmpty()) {
                    String errMsg = lessZeroTransferAmtModel.stream().map(draftinfo -> String.format(ResManager.loadKDString((String)"%1$s \u6392\u7a0b\u5355\u5bf9\u5e94\u7968\u9762\u4fe1\u606f\u8f6c\u8ba9\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u5f53\u524d\u91d1\u989d\u4e3a %2$s\uff0c\u8bf7\u4fee\u6539", (String)"PayScheSaveOfDraftInfoValidator_3", (String)"tmc-psd-business", (Object[])new Object[0]), mark, draftinfo.getTransferAmt())).collect(Collectors.joining("/r/n"));
                    this.addErrorMessage(extendedDataEntities[0], errMsg);
                    continue;
                }
                BigDecimal draftTransferAmtSum = payScheCalcModel.getPayScheDraftInfos().stream().filter(Objects::nonNull).map(PayScheDraftInfo::getTransferAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (draftBillAmt.compareTo(draftTransferAmtSum) == 0) continue;
                this.addErrorMessage(extendedDataEntities[0], String.format(ResManager.loadKDString((String)"%s \u6392\u7a0b\u5355\u5bf9\u5e94\u7684\u7968\u9762\u4fe1\u606f\u5185\u7684\u7968\u636e\u8f6c\u8ba9\u91d1\u989d\u4e0e\u6392\u7968\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u4fee\u6539", (String)"PayScheSaveOfDraftInfoValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
            }
        }
    }
}

