/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payschebill;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleLog;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class ScheduleBillFreezeValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(4);
        selector.add("freezestatus");
        selector.add("schedulstatus");
        selector.add("batchnum");
        selector.add("billno");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntityArr) throws KDBizException {
        ArrayList<String> billNos = new ArrayList<String>(dataEntityArr.length);
        for (ExtendedDataEntity dataEntity : dataEntityArr) {
            DynamicObject scheduleBill = dataEntity.getDataEntity();
            billNos.add(scheduleBill.getString("billno"));
            String freezeStatus = scheduleBill.getString("freezestatus");
            if (null != freezeStatus && !freezeStatus.trim().equals("") && !FreezeStatusEnum.UnFrozen.getValue().equals(freezeStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u9700\u4e3a\u672a\u51bb\u7ed3\u72b6\u6001\u65b9\u53ef\u51bb\u7ed3\u3002", (String)"ScheduleBillFreezeValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]));
                continue;
            }
            String scheduleStatus = scheduleBill.getString("schedulstatus");
            if (ScheStatusEnum.NOSCHEDULE.getValue().equals(scheduleStatus) || ScheStatusEnum.YETSCHEDULE.getValue().equals(scheduleStatus)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u5fc5\u987b\u662f\u672a\u6392\u7a0b\u6216\u5df2\u6392\u7a0b\u72b6\u6001\uff0c\u624d\u80fd\u8fdb\u884c\u51bb\u7ed3\u3002", (String)"ScheduleBillFreezeValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        PayScheduleLog.getInstance().logPaySchedule(billNos, ResManager.loadKDString((String)"\u51bb\u7ed3", (String)"ScheduleBillFreezeValidator_3", (String)"tmc-psd-business", (Object[])new Object[0]));
    }
}

