/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payscheprocessor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.business.service.paysche.service.impl.AbstractPayScheProcessorCreator;
import kd.tmc.psd.business.service.paysche.service.impl.PayScheProcessorCreator;
import kd.tmc.psd.business.service.paysche.service.impl.PayScheProcessorDirectByStartEndDateCreator;
import kd.tmc.psd.business.service.period.PeriodHelper;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.PsdParameterHelper;

public class PayScheBillAutoStartValidator
extends AbstractTmcBizOppValidator {
    private static Log logger = LogFactory.getLog(PayScheBillAutoStartValidator.class);

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        Map<Long, List<ExtendedDataEntity>> orgIdDObjMap;
        try {
            ArrayList<ExtendedDataEntity> needAutoScheBills = new ArrayList<ExtendedDataEntity>(dataEntity.length);
            for (ExtendedDataEntity entity : dataEntity) {
                if (!this.checkStatusCompanyCur(entity)) continue;
                needAutoScheBills.add(entity);
            }
            logger.info("need auto sche bills: ", (Object)needAutoScheBills.size(), needAutoScheBills);
            orgIdDObjMap = needAutoScheBills.stream().collect(Collectors.groupingBy(v -> v.getDataEntity().getDynamicObject("company").getLong("id")));
        }
        catch (Throwable e) {
            logger.error("PayScheBillAutoStartValidator filter and group error:", e);
            for (ExtendedDataEntity extendedDataEntity : dataEntity) {
                this.addErrorMessage(extendedDataEntity, "error msg: " + e.getMessage());
            }
            throw new KDBizException(e.getMessage());
        }
        for (Map.Entry<Long, List<ExtendedDataEntity>> orgIdDObj : orgIdDObjMap.entrySet()) {
            List<ExtendedDataEntity> scheDObjList = orgIdDObj.getValue();
            try {
                PayScheProcessResult<Object> validateResult;
                AbstractPayScheProcessorCreator payScheProcessorCreator;
                Long orgId = orgIdDObj.getKey();
                boolean isOnTimeSche = PsdParameterHelper.getAppBoolParameter((long)orgId, (String)"ontimesche");
                if (isOnTimeSche) {
                    DynamicObject currPeriod = PeriodHelper.getCurrPeriod(orgId);
                    if (currPeriod == null) {
                        String msg = ResManager.loadKDString((String)"\u6309\u671f\u6392\u7a0b,\u7ec4\u7ec7\u7684\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\u6ca1\u6709\u53ef\u7528\u7684\u6392\u7a0b\u5468\u671f\u3002", (String)"PayScheBillAutoStartValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]);
                        throw new KDBizException(msg);
                    }
                    long periodId = currPeriod.getLong("id");
                    Set currencyIds = scheDObjList.stream().map(o -> o.getDataEntity().getDynamicObject("currency").getLong("id")).collect(Collectors.toSet());
                    payScheProcessorCreator = new PayScheProcessorCreator(orgId, periodId, new ArrayList<Long>(currencyIds));
                } else {
                    List<Long> scheBillIds = scheDObjList.stream().map(o -> (Long)o.getBillPkId()).collect(Collectors.toList());
                    payScheProcessorCreator = new PayScheProcessorDirectByStartEndDateCreator(scheBillIds);
                }
                if ((validateResult = payScheProcessorCreator.validateWithResult()).isSuccess()) continue;
                for (ExtendedDataEntity extendedDataEntity : scheDObjList) {
                    this.addErrorMessage(extendedDataEntity, String.join((CharSequence)",", validateResult.getErrMsgList()));
                }
            }
            catch (Exception e) {
                logger.error("payScheBill auto start valid error", (Throwable)e);
                for (ExtendedDataEntity extendedDataEntity : scheDObjList) {
                    this.addErrorMessage(extendedDataEntity, "error:" + e.getMessage());
                }
            }
        }
    }

    private boolean checkStatusCompanyCur(ExtendedDataEntity entity) {
        boolean isOk = true;
        if (!ScheStatusEnum.NOSCHEDULE.getValue().equals(entity.getValue("schedulstatus"))) {
            isOk = false;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u6392\u7a0b\u72b6\u6001\u4e0d\u662f\u672a\u6392\u7a0b", (String)"PayScheBillAutoScheService_14", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        if (!BillStatusEnum.AUDIT.getValue().equals(entity.getValue("billstatus"))) {
            isOk = false;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838", (String)"PayScheBillAutoScheService_15", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)entity.getValue("company"))) {
            isOk = false;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayScheBillAutoScheService_16", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((Object)entity.getValue("currency"))) {
            isOk = false;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u80fd\u4e3a\u7a7a", (String)"PayScheBillAutoScheService_17", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
        return isOk;
    }
}

