/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payscheprocessor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcAmountHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.provider.PayScheBaseDataProvider;
import kd.tmc.psd.business.service.paysche.helper.PayScheduleHelper;
import kd.tmc.psd.common.enums.DraftPayTypeEnum;
import kd.tmc.psd.common.enums.FreezeStatusEnum;
import kd.tmc.psd.common.enums.PayChannelEnum;
import kd.tmc.psd.common.enums.ScheStatusEnum;
import kd.tmc.psd.common.helper.PayScheHelper;

public class PayScheProcSubmitValidator
extends AbstractTmcBizOppValidator {
    private Map<Object, DynamicObject> draftBillMap = new HashMap<Object, DynamicObject>();
    private static final String DRAFT_TYPE_ARRIVAL = "7";

    public List<String> getSelector() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("entryentity");
        list.add("entryentity.e_billno");
        list.add("entryentity.e_sourcebilltype");
        list.add("entryentity.e_balanceamt");
        list.add("entryentity.e_acctbanktype");
        list.add("entryentity.e_acctbank");
        list.add("entryentity.e_settletype");
        list.add("entryentity.e_amount");
        list.add("entryentity.e_draftamt");
        list.add("entryentity.e_draftpayacct");
        list.add("entryentity.e_draftsettletype");
        list.add("entryentity.e_settletype");
        list.add("entryentity.e_businesstype");
        list.add("entryentity.e_institutioncode");
        list.add("entryentity.e_institutionname");
        return list;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        String cacheDateStr = this.getOption().getVariableValue("key_payschemodel", "");
        if (EmptyUtil.isNoEmpty((String)cacheDateStr)) {
            this.editFormValidate(cacheDateStr, dataEntity);
            List<PayScheCalcModel> scheDataList = PayScheCalcModel.deserializeList(cacheDateStr);
            this.fullAmountValidate(scheDataList);
        }
        HashSet<String> sourceBillNos = new HashSet<String>(16);
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject dynamic = data.getDataEntity();
            DynamicObjectCollection entryEntities = dynamic.getDynamicObjectCollection("entryentity");
            String errMsg = this.checkEntrustScheduleBill(entryEntities);
            if (EmptyUtil.isNoEmpty((String)errMsg)) {
                this.addErrorMessage(data, errMsg);
            }
            for (DynamicObject dynamicObject : entryEntities) {
                String sourceBillType;
                BigDecimal draftAmount;
                DynamicObject settleType;
                DynamicObject acctBank;
                String acctBankType;
                String billNo = dynamicObject.getString("e_billno");
                BigDecimal amount = dynamicObject.getBigDecimal("e_amount");
                if (amount.compareTo(BigDecimal.ZERO) > 0 && "bd_accountbanks".equals(acctBankType = dynamicObject.getString("e_acctbanktype")) && null != (acctBank = this.getAccountBank(dynamicObject, "e_acctbank"))) {
                    BigDecimal singlelimit;
                    settleType = dynamicObject.getDynamicObject("e_settletype");
                    this.checkSettleType(acctBank, settleType, data, billNo, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u5728\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u7684\u9650\u5b9a\u7ed3\u7b97\u65b9\u5f0f\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PayScheProcSubmitValidator_33", (String)"tmc-psd-business", (Object[])new Object[0]));
                    DynamicObject strategy = acctBank.getDynamicObject("strategy");
                    if (EmptyUtil.isNoEmpty((DynamicObject)strategy) && EmptyUtil.isNoEmpty((BigDecimal)(singlelimit = strategy.getBigDecimal("singlelimit"))) && amount.compareTo(singlelimit) > 0) {
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u6392\u6b3e\u91d1\u989d\u8d85\u51fa\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u7684\u5355\u7b14\u652f\u4ed8\u9650\u989d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PayScheProcSubmitValidator_34", (String)"tmc-psd-business", (Object[])new Object[0]), billNo));
                    }
                }
                if ((draftAmount = dynamicObject.getBigDecimal("e_draftamt")).compareTo(BigDecimal.ZERO) > 0 && null != (acctBank = this.getAccountBank(dynamicObject, "e_draftpayacct"))) {
                    settleType = dynamicObject.getDynamicObject("e_draftsettletype");
                    this.checkSettleType(acctBank, settleType, data, billNo, ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u5728\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u7684\u9650\u5b9a\u7ed3\u7b97\u65b9\u5f0f\u8303\u56f4\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PayScheProcSubmitValidator_35", (String)"tmc-psd-business", (Object[])new Object[0]));
                }
                if (!"cas_payapplybill".equals(sourceBillType = dynamicObject.getString("e_sourcebilltype"))) continue;
                String sourceBillNo = dynamicObject.getString("e_sourcebillnumber");
                sourceBillNos.add(sourceBillNo);
            }
        }
        Map isPartPaymentMap = new HashMap(16);
        if (sourceBillNos.size() > 0) {
            isPartPaymentMap = PayScheHelper.isPartPaymentBySourceBillNo(sourceBillNos);
        }
        if (isPartPaymentMap.size() == 0) {
            return;
        }
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject dynamic = data.getDataEntity();
            DynamicObjectCollection entryEntities = dynamic.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryEntities) {
                String sourceBillNo;
                String sourceBillType = dynamicObject.getString("e_sourcebilltype");
                if (!"cas_payapplybill".equals(sourceBillType) || !isPartPaymentMap.containsKey(sourceBillNo = dynamicObject.getString("e_sourcebillnumber")) || ((Boolean)isPartPaymentMap.get(sourceBillNo)).booleanValue()) continue;
                BigDecimal balanceAmount = dynamicObject.getBigDecimal("e_balanceamt");
                BigDecimal amount = dynamicObject.getBigDecimal("e_amount");
                BigDecimal draftAmount = dynamicObject.getBigDecimal("e_draftamt");
                Boolean isSchePartPayment = PayScheHelper.isSchePartPayment((BigDecimal)balanceAmount, (BigDecimal)draftAmount, (BigDecimal)amount);
                if (!isSchePartPayment.booleanValue()) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d44\u91d1\u4ed8\u6b3e\u7533\u8bf7\u5355\u4e0d\u5141\u8bb8\u62c6\u5206\uff0c\u4e0d\u53ef\u540c\u65f6\u6392\u6b3e\u6392\u7968\uff0c\u4e5f\u4e0d\u53ef\u90e8\u5206\u6392\u6b3e\u6216\u90e8\u5206\u6392\u7968\u3002", (String)"PayScheProcSubmitValidator_27", (String)"tmc-psd-business", (Object[])new Object[0]));
            }
        }
    }

    private String checkEntrustScheduleBill(DynamicObjectCollection entryEntities) {
        StringBuilder errMsg = new StringBuilder();
        entryEntities.forEach(e -> {
            if (EmptyUtil.isNoEmpty((Long)e.getLong("e_entrustpayid"))) {
                BigDecimal balanceAmount = e.getBigDecimal("e_balanceamt");
                BigDecimal amount = e.getBigDecimal("e_amount");
                BigDecimal draftAmount = e.getBigDecimal("e_draftamt");
                if (PayScheHelper.isSchePartPayment((BigDecimal)balanceAmount, (BigDecimal)draftAmount, (BigDecimal)amount)) {
                    if (EmptyUtil.isNoEmpty((String)errMsg.toString())) {
                        errMsg.append("\r\n");
                    }
                    errMsg.append(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c{0}\u201d\u7531\u59d4\u6258\u4ed8\u6b3e\u751f\u6210\uff0c\u4e0d\u652f\u6301\u90e8\u5206\u6392\u6b3e\u3001\u90e8\u5206\u6392\u7968\u3001\u540c\u65f6\u6392\u6b3e\u6392\u7968\u3001\u6279\u91cf\u6392\u6b3e\u3001\u6279\u91cf\u6392\u7968\u3001\u81ea\u52a8\u6392\u7a0b\u3001\u6c47\u603b\u6392\u7a0b\u3002", (String)"PayScheProcSubmitValidator_39", (String)"tmc-psd-business", (Object[])new Object[]{e.getString("e_billno")}));
                }
            }
        });
        return errMsg.toString();
    }

    private void checkSettleType(DynamicObject acctBank, DynamicObject settleType, ExtendedDataEntity data, String billNo, String errorMsg) {
        Set settlementTypeIds;
        DynamicObjectCollection settlementType = acctBank.getDynamicObjectCollection("settlementtype");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleType) && EmptyUtil.isNoEmpty((DynamicObjectCollection)settlementType) && !(settlementTypeIds = settlementType.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet())).contains(settleType.getLong("id"))) {
            this.addErrorMessage(data, String.format(errorMsg, billNo));
        }
    }

    private DynamicObject getAccountBank(DynamicObject dynamicObject, String acctbankName) {
        DynamicObject acctBank = dynamicObject.getDynamicObject(acctbankName);
        if (EmptyUtil.isEmpty((DynamicObject)acctBank)) {
            return null;
        }
        Long acctBankId = acctBank.getLong("id");
        return TmcDataServiceHelper.loadSingleFromCache((Object)acctBankId, (String)"bd_accountbanks", (String)"id,settlementtype,strategy");
    }

    private void fullAmountValidate(List<PayScheCalcModel> scheDataList) {
        List<PayScheCalcModel> mergeDataList = scheDataList.parallelStream().filter(o -> Objects.nonNull(o) && o.isArchiveMerger() && o.isBillDibs() == false).collect(Collectors.toList());
        Map<String, BigDecimal> batchScheAmount = PayScheduleHelper.getBatchApplyAmount(scheDataList);
        if (EmptyUtil.isNoEmpty(mergeDataList)) {
            Map scaleMap = TmcAmountHelper.getScaleMap(mergeDataList.stream().map(PayScheCalcModel::getCurrencyId).collect(Collectors.toSet()));
            HashSet batchnumSet = new HashSet();
            mergeDataList.forEach(data -> {
                BigDecimal totalAmt;
                String batchNum = data.getBatchnum();
                BigDecimal applyAmt = data.getApplyAmt().multiply(data.getExchangerate()).setScale((int)((Integer)scaleMap.get(data.getCurrencyId())), 4);
                BigDecimal dealApplyAmt = (BigDecimal)batchScheAmount.get(batchNum);
                if (dealApplyAmt != null) {
                    applyAmt = dealApplyAmt;
                }
                if (applyAmt.compareTo(totalAmt = data.getScheAmt().add(data.getDraftBillAmt()).setScale((int)((Integer)scaleMap.get(data.getCurrencyId())), 4)) != 0) {
                    batchnumSet.add(data.getBatchnum());
                }
            });
            if (EmptyUtil.isNoEmpty(batchnumSet)) {
                String numStr = batchnumSet.stream().collect(Collectors.joining(","));
                String errormsg = String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u5408\u5e76\u6279\u6b21\u53f7[%s]\u672a\u5168\u989d\u6392\u7a0b\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"PayScheBillFullAmountValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]), numStr);
                throw new KDBizException(errormsg);
            }
        }
    }

    private void editFormValidate(String cacheDateStr, ExtendedDataEntity[] dataEntity) {
        List<PayScheCalcModel> scheDataList = PayScheCalcModel.deserializeList(cacheDateStr);
        ArrayList<PayScheCalcModel> toValidate = new ArrayList<PayScheCalcModel>();
        Set batchNumbers = scheDataList.stream().filter(Objects::nonNull).filter(o -> o.isArchiveMerger()).map(o -> o.getBatchnum()).collect(Collectors.toSet());
        List mergeModel = scheDataList.stream().filter(Objects::nonNull).filter(o -> o.isArchiveMerger()).collect(Collectors.toList());
        for (PayScheCalcModel payScheCalcModel : scheDataList) {
            String batchNum = payScheCalcModel.getBatchnum();
            if (batchNumbers.contains(batchNum)) continue;
            toValidate.add(payScheCalcModel);
        }
        scheDataList = scheDataList.stream().filter(Objects::nonNull).filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
        toValidate.addAll(mergeModel);
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (PayScheCalcModel payScheCalcModel : scheDataList) {
            totalAmt = totalAmt.add(payScheCalcModel.getScheAmt().abs()).add(payScheCalcModel.getDraftBillAmt().abs());
        }
        if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
            this.addErrorMessage(dataEntity[0], ResManager.loadKDString((String)"\u6392\u7a0b\u603b\u989d\u4e3a0\uff0c\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"PayScheProcSubmitValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
            return;
        }
        List list = scheDataList.stream().filter(v -> EmptyUtil.isNoEmpty(v.getDraftBillIds())).map(p -> p.getDraftBillIds()).flatMap(v -> v.stream()).collect(Collectors.toList());
        if (list.size() > 0) {
            DynamicObject[] draftBills = TmcDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cdm_draftbillf7"));
            this.draftBillMap = Stream.of(draftBills).collect(Collectors.toMap(DataEntityBase::getPkValue, o -> o));
        }
        this.validateSubmit(dataEntity[0], scheDataList);
        this.checkBids(dataEntity[0], toValidate);
    }

    private void checkBids(ExtendedDataEntity entity, List<PayScheCalcModel> toValidate) {
        for (PayScheCalcModel payScheCalcModel : toValidate) {
            List<Long> draftBillIds;
            String draftPayMethod = payScheCalcModel.getDraftPayMethod();
            if (!DraftPayTypeEnum.DRAFTBOOK.getValue().equals(draftPayMethod) || EmptyUtil.isEmpty(draftBillIds = payScheCalcModel.getDraftBillIds()) || draftBillIds.size() < 1) continue;
            BigDecimal draftnoAmt = BigDecimal.ZERO;
            for (Long draftBillId : draftBillIds) {
                DynamicObject draft = this.draftBillMap.get(draftBillId);
                draftnoAmt = draftnoAmt.add(draft.getBigDecimal("amount"));
            }
            this.checkBids(entity, payScheCalcModel, draftnoAmt);
        }
    }

    private void validateSubmit(ExtendedDataEntity entity, List<PayScheCalcModel> payScheDataList) {
        PayScheBaseDataProvider dataProvider = new PayScheBaseDataProvider(payScheDataList);
        HashSet lookUpIds = new HashSet();
        payScheDataList.stream().filter(Objects::nonNull).forEach(o -> {
            Long settleTypeId = o.getSettleTypeId();
            if (EmptyUtil.isNoEmpty((Long)settleTypeId)) {
                lookUpIds.add(settleTypeId);
            }
        });
        payScheDataList.stream().filter(Objects::nonNull).forEach(o -> {
            Long draftSettleTypeId = o.getDraftSettleTypeId();
            if (EmptyUtil.isNoEmpty((Long)draftSettleTypeId)) {
                lookUpIds.add(draftSettleTypeId);
            }
        });
        DynamicObjectCollection settleTypeArr = QueryServiceHelper.query((String)"bd_settlementtype", (String)"id,paymentchannel,settlementtype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)lookUpIds.toArray())});
        Map<Object, DynamicObject> settleTypeMap = settleTypeArr.stream().filter(Objects::nonNull).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        for (PayScheCalcModel payScheCalcModel : payScheDataList) {
            Set currencyIdSet;
            Object payChannel;
            Date expectDate;
            String mark;
            String billno = payScheCalcModel.getScheNumber();
            BigDecimal scheAmt = payScheCalcModel.getScheAmt();
            BigDecimal draftBillAmt = payScheCalcModel.getDraftBillAmt();
            String scheStatus = payScheCalcModel.getScheStatus();
            String string = mark = EmptyUtil.isEmpty((String)billno) ? payScheCalcModel.getBatchnum() : billno;
            if (EmptyUtil.isEmpty((String)scheStatus) || !scheStatus.equals(ScheStatusEnum.SCHEDULING.getValue())) {
                return;
            }
            if (BigDecimal.ZERO.compareTo(draftBillAmt) < 0 && (EmptyUtil.isEmpty((Long)payScheCalcModel.getCurrencyId()) || EmptyUtil.isEmpty((Long)payScheCalcModel.getApplyCurrencyId()) || payScheCalcModel.getCurrencyId().compareTo(payScheCalcModel.getApplyCurrencyId()) != 0)) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u4e2d\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u4e3a\u5f02\u5e01\u79cd\u4ed8\u6b3e\u4e1a\u52a1\uff0c\u4e0d\u652f\u6301\u6392\u7968", (String)"PayScheProcSubmitValidator_32", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
            }
            if ((scheAmt.compareTo(BigDecimal.ZERO) != 0 || draftBillAmt.compareTo(BigDecimal.ZERO) != 0) && EmptyUtil.isEmpty((Object)(expectDate = payScheCalcModel.getExpectDate()))) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u7a0b\u4ed8\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_7", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
            }
            if (scheAmt.compareTo(BigDecimal.ZERO) != 0) {
                Long settleTypeId = payScheCalcModel.getSettleTypeId();
                if (null == settleTypeId || 0L == settleTypeId) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                Long acctBankId = payScheCalcModel.getAcctBankId();
                DynamicObject settleTypeDO = settleTypeMap.get(settleTypeId);
                Long orgId = payScheCalcModel.getOrgId();
                boolean isCheckOurAcc = PayScheHelper.isCheckOurAccBySysParam((Long)orgId, (DynamicObject)settleTypeDO);
                if ((null == acctBankId || 0L == acctBankId) && isCheckOurAcc) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u4e2d\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u6b3e\u4ed8\u6b3e\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                if (StringUtils.isEmpty((CharSequence)(payChannel = payScheCalcModel.getPayChannel()))) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u6b3e\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_3", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                if (settleTypeDO == null) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"PayScheProcSubmitValidator_31", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
                } else {
                    String paymentchannel = settleTypeDO.getString("paymentchannel");
                    if (EmptyUtil.isNoEmpty((String)paymentchannel) && !paymentchannel.contains((CharSequence)payChannel)) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u6b3e\u652f\u4ed8\u6e20\u9053\u4e0d\u5728\u9009\u5b9a\u7684\u6392\u6b3e\u7ed3\u7b97\u65b9\u5f0f\u9650\u5b9a\u652f\u4ed8\u6e20\u9053\u8303\u56f4\u5185\uff0c\u8bf7\u66f4\u6362\u6392\u6b3e\u652f\u4ed8\u6e20\u9053\u3002", (String)"PayScheProcSubmitValidator_28", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
                    }
                }
            }
            if (draftBillAmt.compareTo(BigDecimal.ZERO) != 0) {
                DynamicObject settleTypeDO;
                boolean isDraftBePayChannelType;
                Set currencyIdSet2;
                Long draftSettleTypeId = payScheCalcModel.getDraftSettleTypeId();
                String draftPayChannel = payScheCalcModel.getDraftpaychannel();
                if (null == draftSettleTypeId || 0L == draftSettleTypeId) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_4", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                if (StringUtils.isEmpty((CharSequence)draftPayChannel)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u7968\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_5", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                String draftPayMethod = payScheCalcModel.getDraftPayMethod();
                if (DraftPayTypeEnum.DRAFTBOOK.getValue().equals(draftPayMethod)) {
                    List<Long> draftBillIds = payScheCalcModel.getDraftBillIds();
                    if (EmptyUtil.isEmpty(draftBillIds) || draftBillIds.size() < 1) {
                        String freezeStatus = payScheCalcModel.getFreezeStatus();
                        if (FreezeStatusEnum.UnFrozen.getValue().equals(freezeStatus)) {
                            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u7968\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_6", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                        }
                    } else {
                        BigDecimal draftnoAmt = BigDecimal.ZERO;
                        payChannel = draftBillIds.iterator();
                        while (payChannel.hasNext()) {
                            Long draftBillId = (Long)payChannel.next();
                            DynamicObject draft = this.draftBillMap.get(draftBillId);
                            draftnoAmt = draftnoAmt.add(draft.getBigDecimal("amount"));
                        }
                    }
                }
                Long draftPayAcctId = payScheCalcModel.getDraftAcctBankId();
                DynamicObject draftBankAcct = null;
                if (EmptyUtil.isNoEmpty((Long)draftPayAcctId) && !(currencyIdSet2 = (draftBankAcct = dataProvider.getBaseData("bd_accountbanks", draftPayAcctId)).getDynamicObjectCollection("currency").stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet())).contains(payScheCalcModel.getCurrencyId())) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u6240\u9009\u7684\u4ed8\u6b3e\u5e01\u79cd\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayScheProcSubmitValidator_24", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                }
                if (isDraftBePayChannelType = PayChannelEnum.BEI.getValue().equals(payScheCalcModel.getDraftpaychannel())) {
                    boolean hasBeOfDraftBankAcct = false;
                    if (draftBankAcct != null) {
                        hasBeOfDraftBankAcct = draftBankAcct.getBoolean("issetbankinterface");
                    }
                    if (!hasBeOfDraftBankAcct && draftBillAmt.compareTo(BigDecimal.ZERO) != 0) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u6392\u7968\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u76f4\u8fde\uff0c\u8bf7\u66f4\u6362\u6392\u7968\u652f\u4ed8\u6e20\u9053\u3002", (String)"PayScheProcSubmitValidator_25", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
                    }
                }
                if ((settleTypeDO = settleTypeMap.get(draftSettleTypeId)) == null) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"PayScheProcSubmitValidator_30", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
                } else {
                    String paymentchannel = settleTypeDO.getString("paymentchannel");
                    if (EmptyUtil.isNoEmpty((String)paymentchannel) && !paymentchannel.contains(draftPayChannel)) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%s\u201d\u7684\u6392\u7968\u652f\u4ed8\u6e20\u9053\u4e0d\u5728\u9009\u5b9a\u7684\u6392\u7968\u7ed3\u7b97\u65b9\u5f0f\u9650\u5b9a\u652f\u4ed8\u6e20\u9053\u8303\u56f4\u5185\uff0c\u8bf7\u66f4\u6362\u6392\u7968\u652f\u4ed8\u6e20\u9053\u3002", (String)"PayScheProcSubmitValidator_29", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
                    }
                }
                this.validateArrival(entity, payScheCalcModel, mark);
            }
            String bankAcctType = payScheCalcModel.getAcctBankType();
            Long bankAcctId = payScheCalcModel.getAcctBankId();
            Long currencyId = payScheCalcModel.getCurrencyId();
            boolean isBankAcctType = "bd_accountbanks".equals(bankAcctType);
            boolean isBePayType = PayChannelEnum.BEI.getValue().equals(payScheCalcModel.getPayChannel());
            DynamicObject bankAcct = null;
            if (isBankAcctType && bankAcctId != null && bankAcctId != 0L && !(currencyIdSet = (bankAcct = dataProvider.getBaseData("bd_accountbanks", bankAcctId)).getDynamicObjectCollection("currency").stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> (Long)o.getPkValue()).collect(Collectors.toSet())).contains(currencyId)) {
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u6240\u9009\u7684\u4ed8\u6b3e\u5e01\u79cd\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PayScheProcSubmitValidator_14", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
            }
            if (!isBePayType) continue;
            boolean hasBe = false;
            if (isBankAcctType && bankAcct != null) {
                hasBe = bankAcct.getBoolean("issetbankinterface");
            }
            if (hasBe || scheAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u4ed8\u6b3e\u8d26\u6237\u672a\u5f00\u901a\u94f6\u4f01\u76f4\u8fde\uff0c\u8bf7\u66f4\u6362\u6392\u6b3e\u652f\u4ed8\u6e20\u9053\u3002", (String)"PayScheProcSubmitValidator_15", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
        }
    }

    private void validateArrival(ExtendedDataEntity entity, PayScheCalcModel payScheCalcModel, String mark) {
        Long settlementId = payScheCalcModel.getDraftSettleTypeId();
        if (settlementId == null) {
            return;
        }
        DynamicObject settlementTypeObj = TmcDataServiceHelper.loadSingleFromCache((Object)settlementId, (String)"bd_settlementtype");
        String settlementType = Optional.ofNullable(settlementTypeObj).map(o -> o.getString("settlementtype")).orElseGet(() -> null);
        if (StringUtils.isEmpty((CharSequence)settlementType) || !DRAFT_TYPE_ARRIVAL.equals(settlementType)) {
            return;
        }
        String arrivalNo = payScheCalcModel.getLcArrivalNo();
        if (StringUtils.isEmpty((CharSequence)arrivalNo)) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u4e2d\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u7684\u7ed3\u7b97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PayScheProcSubmitValidator_38", (String)"tmc-psd-business", (Object[])new Object[0]), mark));
        }
    }

    private void checkBids(ExtendedDataEntity entity, PayScheCalcModel payScheCalcModel, BigDecimal draftnoAmt) {
        Boolean isBillBids = payScheCalcModel.isBillDibs();
        if (!isBillBids.booleanValue()) {
            return;
        }
        BigDecimal scheAmt = payScheCalcModel.getScheAmt();
        BigDecimal draftBillAmt = payScheCalcModel.getDraftBillAmt();
        String billno = payScheCalcModel.getScheNumber();
        if (draftnoAmt.compareTo(draftBillAmt) < 0) {
            this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u7968\u636e\u627e\u96f6\u4e1a\u52a1\u4e0b\uff0c\u660e\u7ec6\u4e2d\u7684\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7%s\u7684\u7968\u636e\u7968\u9762\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u9009\u7968", (String)"PayScheProcSubmitValidator_20", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
            return;
        }
        Long dibsBalance = payScheCalcModel.getDibsBalance();
        if (EmptyUtil.isEmpty((Long)dibsBalance)) {
            this.addBidsError(entity, billno);
            return;
        }
        DynamicObject payBillObj = BusinessDataServiceHelper.loadSingle((Object)dibsBalance, (String)"cas_recbill", (String)"id,actrecamt");
        if (EmptyUtil.isEmpty((DynamicObject)payBillObj)) {
            this.addBidsError(entity, billno);
            return;
        }
        BigDecimal receiveAmount = payBillObj.getBigDecimal("actrecamt");
        Boolean isFalse = scheAmt.compareTo(BigDecimal.ZERO) == 0 && draftBillAmt.compareTo(payScheCalcModel.getApplyAmt()) == 0 && draftBillAmt.add(receiveAmount).compareTo(draftnoAmt) == 0;
        if (!isFalse.booleanValue()) {
            this.addBidsError(entity, billno);
        }
    }

    private void addBidsError(ExtendedDataEntity entity, String billno) {
        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ed8\u6b3e\u6392\u7a0b\u5355%1$s\u8fdb\u884c\u7968\u636e\u627e\u96f6\u4e1a\u52a1, \u6240\u9009\u7968\u636e\u6216\u6536\u6b3e\u5355\u91d1\u989d\u6709\u8bef\uff0c\u8bf7\u5904\u7406\u540e\u91cd\u65b0\u64cd\u4f5c", (String)"PayScheProcSubmitValidator_21", (String)"tmc-psd-business", (Object[])new Object[0]), billno));
    }
}

