/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.payscheprocessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.common.enums.ScheStatusEnum;

public class PayScheProcrUnAuditValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("scheduleperiod");
        selector.add("company");
        selector.add("processorid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        ArrayList<Object> orgIds = new ArrayList<Object>(dataEntity.length);
        ArrayList<Object> payScheProcIds = new ArrayList<Object>(dataEntity.length);
        for (ExtendedDataEntity extendedDataEntity : dataEntity) {
            DynamicObject payScheProc = extendedDataEntity.getDataEntity();
            orgIds.add(payScheProc.getDynamicObject("company").getPkValue());
            payScheProcIds.add(payScheProc.get("processorid"));
        }
        DynamicObject[] otherPayScheProcs = TmcDataServiceHelper.load((String)"psd_schedealbill", (String)"company", (QFilter[])new QFilter[]{new QFilter("company", "in", orgIds), new QFilter("id", "not in", payScheProcIds), new QFilter("billstatus", "!=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("scheduleperiod", "is not null", null).and(new QFilter("scheduleperiod", "!=", (Object)0))});
        HashMap billMap = new HashMap(orgIds.size());
        for (Object e : orgIds) {
            List objs = Arrays.stream(otherPayScheProcs).filter(v -> v.getDynamicObject("company").getPkValue().equals(orgId)).map(p -> p).collect(Collectors.toList());
            billMap.put(e, objs);
        }
        DynamicObject[] payScheProcs = TmcDataServiceHelper.load((Object[])payScheProcIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"psd_schedealbill"));
        HashMap hashMap = Arrays.stream(payScheProcs).collect(Collectors.toMap(v -> v.getLong("id"), o -> o, (o1, o2) -> o1, HashMap::new));
        DynamicObject[] allPayScheBills = TmcDataServiceHelper.load((String)"psd_schedulebill", (String)"id,number,billno,schedulstatus,nextscheduleid,schedealid", (QFilter[])new QFilter[]{new QFilter("schedealid", "in", payScheProcIds)});
        Map<Long, List<DynamicObject>> groupBySchedealId = Arrays.stream(allPayScheBills).collect(Collectors.groupingBy(v -> v.getLong("schedealid")));
        for (ExtendedDataEntity data : dataEntity) {
            Date endDate;
            DynamicObject payScheProc = hashMap.getOrDefault(data.getDataEntity().getLong("processorid"), null);
            if (null == payScheProc) continue;
            DynamicObject company = payScheProc.getDynamicObject("company");
            List existUnAuditBills = (List)billMap.get(company.getPkValue());
            if (payScheProc.get("scheduleperiod") != null && null != existUnAuditBills && existUnAuditBills.size() > 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4ed8\u6b3e\u6392\u7a0b\u5904\u7406\u5355\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"PayScheProcrUnAuditValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
                continue;
            }
            DynamicObject schePeriod = payScheProc.getDynamicObject("scheduleperiod");
            if (EmptyUtil.isNoEmpty((DynamicObject)schePeriod) && DateUtils.getDataFormat((Date)(endDate = schePeriod.getDate("enddate")), (boolean)true).compareTo(DateUtils.getCurrentDate()) < 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5f53\u524d\u65f6\u95f4\u4e0d\u5728\u6392\u7a0b\u5904\u7406\u5355\u6392\u7a0b\u5468\u671f\u5185\u3002\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"PayScheProcrUnAuditValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]));
                continue;
            }
            List<DynamicObject> payScheBills = groupBySchedealId.get(payScheProc.getLong("id"));
            for (DynamicObject payScheBill : payScheBills) {
                String scheStatus = payScheBill.getString("schedulstatus");
                if (!scheStatus.equals(ScheStatusEnum.PAYING.getValue()) && !scheStatus.equals(ScheStatusEnum.YETPAY.getValue())) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u201c%1$s\u201d\u72b6\u6001\u4e3a\u201c%2$s\u201d\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"PayScheProcrUnAuditValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]), payScheBill.getString("billno"), ScheStatusEnum.getName((String)scheStatus)));
            }
        }
    }
}

