/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.period;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;

public class SchePeriodSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("entrys");
        selector.add("enddate");
        selector.add("periodid");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : dataEntity) {
            Map checkRefrenced;
            DynamicObject schePeriod = data.getDataEntity();
            DynamicObjectCollection entrys = schePeriod.getDynamicObjectCollection("entrys");
            if (entrys.size() == 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u751f\u6210\u6392\u7a0b\u5468\u671f\u3002", (String)"SchePeriodSaveValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
                continue;
            }
            List periodIdFromModel = entrys.stream().map(p -> p.getLong("periodid")).collect(Collectors.toList());
            DynamicObject[] periods = TmcDataServiceHelper.load((String)"psd_schedule_period", (String)"id", (QFilter[])new QFilter[]{new QFilter("periodyear", "=", (Object)schePeriod.getInt("periodyear")), new QFilter("schetype", "=", schePeriod.getDynamicObject("group").getPkValue())});
            List periodIdFromDB = Arrays.stream(periods).map(v -> v.getLong("id")).collect(Collectors.toList());
            periodIdFromDB.removeAll(periodIdFromModel);
            if (CollectionUtils.isEmpty(periodIdFromDB) || CollectionUtils.isEmpty((Map)(checkRefrenced = BaseDataRefrenceHelper.checkRefrenced((String)"psd_schedule_period", (Object[])periodIdFromDB.toArray(), null, null, (OperateOption)this.getOption())))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8be5\u5468\u671f\u5df2\u88ab\u5f15\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"SchePeriodDelValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
    }
}

