/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.primerule;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.common.enums.PsdEffectEleEnum;

public class PrimeRuleSaveValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("e_entry");
        selector.add("e_effectelement");
        selector.add("e_setting");
        return selector;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        for (ExtendedDataEntity data : dataEntity) {
            DynamicObject primeRuleDO = data.getDataEntity();
            DynamicObjectCollection entryDOC = primeRuleDO.getDynamicObjectCollection("e_entry");
            if (entryDOC.size() <= 0) {
                String errorMessage = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4f18\u5148\u6b21\u5e8f\u5206\u5f55\u3002", (String)"PrimeRuleSaveValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]);
                this.addErrorMessage(data, errorMessage);
            }
            for (DynamicObject entryDO : entryDOC) {
                String e_setting;
                String effectElement = entryDO.getString("e_effectelement");
                if (!EmptyUtil.isNoEmpty((String)effectElement) || !PsdEffectEleEnum.SUPPLIERSORT.getValue().equals(effectElement) && !PsdEffectEleEnum.SUPPLIERGROUP.getValue().equals(effectElement) && !PsdEffectEleEnum.PROJECTSORT.getValue().equals(effectElement) && !PsdEffectEleEnum.PROJECTGROUP.getValue().equals(effectElement) || !EmptyUtil.isEmpty((String)(e_setting = entryDO.getString("e_setting")))) continue;
                String errorMessage = String.format(ResManager.loadKDString((String)"\u5f71\u54cd\u56e0\u7d20\uff1a\u201c%s\u201d\u5bf9\u5e94\u7684\u4f18\u5148\u6b21\u5e8f\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PrimeRuleSaveValidator_2", (String)"tmc-psd-business", (Object[])new Object[0]), PsdEffectEleEnum.getName((String)effectElement));
                this.addErrorMessage(data, errorMessage);
            }
        }
    }
}

