/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.business.validate.schesource;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;

public class ScheduleSourceValidator
extends AbstractTmcBizOppValidator {
    private static Log logger = LogFactory.getLog(ScheduleSourceValidator.class);

    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(2);
        sic.add("entryentity");
        sic.add(String.join((CharSequence)".", "entryentity", "org"));
        return sic;
    }

    public void validate(ExtendedDataEntity[] dataEntity) throws KDBizException {
        if (dataEntity.length == 0) {
            return;
        }
        ExtendedDataEntity data = dataEntity[0];
        this.existAllOrg(data);
        this.existOrg(data);
    }

    private void existAllOrg(ExtendedDataEntity data) {
        DynamicObject dynamicObject = data.getDataEntity();
        DynamicObjectCollection doCollections = (DynamicObjectCollection)dynamicObject.get("entryentity");
        if (doCollections.size() > 0) {
            logger.info("ScheduleSourceValidator:: Customer config the organization so that it will execute the method of 'existOrg'");
            return;
        }
        QFilter orgFilter = new QFilter("entryentity.org", "is null", null);
        QFilter notInFilter = new QFilter("id", "!=", dynamicObject.getPkValue());
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"psd_schedule_source", (String)"id", (QFilter[])new QFilter[]{statusFilter, notInFilter, orgFilter});
        if (dynamicObjects.size() > 0) {
            this.addMessage(data, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u201c\u9002\u7528\u5168\u7ec4\u7ec7\u201d\u7684\u6392\u7a0b\u6765\u6e90\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScheduleSourceValidator_0", (String)"tmc-psd-business", (Object[])new Object[0]));
        }
    }

    private void existOrg(ExtendedDataEntity data) {
        DynamicObject dynamicObject = data.getDataEntity();
        DynamicObjectCollection doCollections = (DynamicObjectCollection)dynamicObject.get("entryentity");
        if (doCollections.size() <= 0) {
            logger.info("ScheduleSourceValidator::There is no organization. Attention to the method of 'existAllOrg'");
            return;
        }
        List orgIds = doCollections.stream().map(doc -> {
            DynamicObject organization = (DynamicObject)doc.get("org");
            Long orgId = organization.getLong("id");
            return orgId;
        }).collect(Collectors.toList());
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        QFilter notInFilter = new QFilter("id", "!=", dynamicObject.getPkValue());
        QFilter orgFilter = new QFilter("entryentity.org", "in", orgIds);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"psd_schedule_source", (String)"id, entryentity.org", (QFilter[])new QFilter[]{statusFilter, notInFilter, orgFilter});
        if (dynamicObjects.length <= 0) {
            logger.info("ScheduleSourceValidator::Pointing to the organization which had not added to the schedule of source");
            return;
        }
        StringBuilder orgName = new StringBuilder();
        for (DynamicObject dObject : dynamicObjects) {
            DynamicObjectCollection organization = (DynamicObjectCollection)dObject.get("entryentity");
            for (DynamicObject dynObject : organization) {
                DynamicObject orgObject = (DynamicObject)dynObject.get("org");
                Long orgId = orgObject.getLong("id");
                if (!orgIds.contains(orgId)) continue;
                orgName.append("\u3010");
                orgName.append(orgObject.getString("name"));
                orgName.append("\u3011");
            }
        }
        String message = String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6392\u7a0b\u6765\u6e90\u8bbe\u7f6e\uff0c\u201c%1$s\u201d\u5df2\u5b58\u5728\u3002", (String)"ScheduleSourceValidator_1", (String)"tmc-psd-business", (Object[])new Object[0]), orgName);
        this.addMessage(data, message);
    }
}

