/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;

public class LoggerPrintHelper {
    private static Log logger = LogFactory.getLog(LoggerPrintHelper.class);

    public static String printDyObjLogger(DynamicObject ... objs) {
        String serializeStr = "";
        try {
            List<DynamicObject> dyns = Arrays.stream(objs).filter(Objects::nonNull).collect(Collectors.toList());
            if (dyns.size() > 0) {
                serializeStr = DynamicObjectSerializeUtil.serialize((Object[])dyns.toArray(new DynamicObject[0]), (DynamicObjectType)((DynamicObject)dyns.get(0)).getDynamicObjectType());
            }
        }
        catch (Exception e) {
            logger.error("Failed to print the JSON log for the DynamicObject object: ", (Throwable)e);
        }
        return serializeStr;
    }

    public static String printDyObjLoggerByToString(DynamicObject ... objs) {
        StringBuilder sb = new StringBuilder();
        try {
            List dyns = Arrays.stream(objs).filter(Objects::nonNull).collect(Collectors.toList());
            if (dyns.size() > 0) {
                dyns.stream().forEach(o -> sb.append(Optional.ofNullable(o).map(e -> e.toString()).orElseGet(() -> "-")).append(";\n"));
            }
        }
        catch (Exception e) {
            logger.error("Failed to print the tostring log for the DynamicObject object: ", (Throwable)e);
        }
        return sb.toString();
    }

    public static <T> String printCollectionLogger(Collection<T> collection) {
        String loggerStr = "";
        try {
            loggerStr = Optional.ofNullable(collection).map(o -> JSON.toJSONString((Object)o, (SerializerFeature[])LoggerPrintHelper.getSerializeFeature())).orElseGet(() -> "");
        }
        catch (Exception e) {
            logger.error("Failed to print the JSON log for the collection: ", (Throwable)e);
        }
        return loggerStr;
    }

    public static <T> String printObjectLoggerByJSON(T ... objs) {
        String loggerStr = "";
        try {
            List objects = Arrays.stream(objs).filter(Objects::nonNull).collect(Collectors.toList());
            loggerStr = LoggerPrintHelper.printObjectLoggerByJSON(objects);
        }
        catch (Exception e) {
            logger.error("Failed to print the JSON log for the custom object: ", (Throwable)e);
        }
        return loggerStr;
    }

    public static <T> String printObjectLoggerByJSON(Collection<T> objects) {
        String loggerStr = "";
        try {
            objects = objects.stream().filter(Objects::nonNull).collect(Collectors.toList());
            loggerStr = JSON.toJSONString((Object)objects, (SerializerFeature[])LoggerPrintHelper.getSerializeFeature());
        }
        catch (Exception e) {
            logger.error("Failed to print the JSON log for the custom object: ", (Throwable)e);
        }
        return loggerStr;
    }

    public static <T> String printObjectLoggerByToString(T ... objs) {
        String loggerStr = "";
        try {
            List objects = Arrays.stream(objs).filter(Objects::nonNull).collect(Collectors.toList());
            loggerStr = LoggerPrintHelper.printObjectLoggerByToString(objects);
        }
        catch (Exception e) {
            logger.error("Failed to print the tostring log for the custom object: ", (Throwable)e);
        }
        return loggerStr;
    }

    public static <T> String printObjectLoggerByToString(Collection<T> objects) {
        StringBuilder sb = new StringBuilder();
        try {
            objects = objects.stream().filter(Objects::nonNull).collect(Collectors.toList());
            objects.stream().forEach(object -> sb.append(object.toString()).append(";\n"));
        }
        catch (Exception e) {
            logger.error("Failed to print the tostring log for the custom object: ", (Throwable)e);
        }
        return sb.toString();
    }

    private static SerializerFeature[] getSerializeFeature() {
        return new SerializerFeature[]{SerializerFeature.IgnoreNonFieldGetter, SerializerFeature.WriteClassName, SerializerFeature.NotWriteRootClassName, SerializerFeature.WriteMapNullValue};
    }
}

