/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.common.helper;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.common.enums.SettleMentTypeEnum;
import kd.tmc.psd.common.helper.PsdParameterHelper;

public class PayScheHelper {
    private static Log logger = LogFactory.getLog(PayScheHelper.class);

    public static boolean isPartPaymentBySourceBillNo(String sourceBillNo, String sourceBillType) {
        if (!"cas_payapplybill".equals(sourceBillType)) {
            return true;
        }
        boolean result = (Boolean)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"payScheService", (String)"isPartPaymentBySourceBillNo", (Object[])new Object[]{sourceBillNo});
        return result;
    }

    public static Map<String, Boolean> isPartPaymentBySourceBillNo(Set<String> sourceBillNo) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"payScheService", (String)"isPartPaymentBySourceBillNos", (Object[])new Object[]{sourceBillNo});
        return result;
    }

    public static boolean isSchePartPayment(BigDecimal balanceAmount, BigDecimal draftAmount, BigDecimal amount) {
        if (BigDecimal.ZERO.compareTo(draftAmount) != 0 && BigDecimal.ZERO.compareTo(balanceAmount) != 0) {
            return true;
        }
        if (BigDecimal.ZERO.compareTo(amount) != 0 && BigDecimal.ZERO.compareTo(balanceAmount) != 0) {
            return true;
        }
        return BigDecimal.ZERO.compareTo(draftAmount) != 0 && BigDecimal.ZERO.compareTo(amount) != 0;
    }

    public static QFilter buildAutoRuleEffDateFilter() {
        Date today = DateUtils.getCurrentDate();
        LocalDateTime todayMaxTime = LocalDateTime.of(LocalDate.now(), LocalTime.MAX);
        Date maxToday = DateUtils.localDateTime2Date((LocalDateTime)todayMaxTime);
        QFilter dateQFilter = new QFilter("enabledate", "<=", (Object)maxToday);
        QFilter expiredF = QFilter.isNull((String)"expireddate").or("expireddate", ">=", (Object)today);
        dateQFilter.and(expiredF);
        return dateQFilter;
    }

    public static boolean effDateIsCoincident(DynamicObject rule1, DynamicObject rule2) {
        Date startDate1 = DateUtils.truncateDate((Date)rule1.getDate("enabledate"));
        Date startDate2 = DateUtils.truncateDate((Date)rule2.getDate("enabledate"));
        Supplier<Date> maxDateSupplier = () -> new Date(Long.MAX_VALUE);
        Date endDate1 = Optional.ofNullable(rule1.getDate("expireddate")).orElseGet(maxDateSupplier);
        Date endDate2 = Optional.ofNullable(rule2.getDate("expireddate")).orElseGet(maxDateSupplier);
        return !startDate1.after(endDate2) && !startDate2.after(endDate1);
    }

    public static boolean isCreditSettlement(DynamicObject settleType) {
        try {
            if (settleType != null && EmptyUtil.isNoEmpty((DynamicObject)settleType) && SettleMentTypeEnum.CREDIT.getValue().equals(settleType.getString("settlementtype"))) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return false;
    }

    public static boolean isSettleTypeVirtual(DynamicObject settleType) {
        if (settleType == null) {
            return false;
        }
        return "14".equals(settleType.getString("settlementtype"));
    }

    public static boolean isCreditSettlement(String settleType) {
        try {
            if (settleType != null && EmptyUtil.isNoEmpty((String)settleType) && SettleMentTypeEnum.CREDIT.getValue().equals(settleType)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return false;
    }

    public static boolean isLCSettlement(DynamicObject payBill) {
        if (!payBill.containsProperty("settletype")) {
            return false;
        }
        DynamicObject settleType = payBill.getDynamicObject("settletype");
        return PayScheHelper.isCreditSettlement(settleType);
    }

    public static boolean isCheckOurAccBySysParam(Long orgId, DynamicObject settleType) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{orgId, settleType})) {
            return true;
        }
        boolean isVirtual = PayScheHelper.isSettleTypeVirtual(settleType);
        if (isVirtual) {
            return PsdParameterHelper.getCasAppBoolParameter(orgId, "cs128");
        }
        return true;
    }

    public static String hadSameOrg(DynamicObject newAutoRule, DynamicObject validateRule) {
        DynamicObjectCollection newRuleOrgList = newAutoRule.getDynamicObjectCollection("orgentryentity");
        if (CollectionUtils.isEmpty((Collection)newRuleOrgList)) {
            return null;
        }
        DynamicObjectCollection validateRuleOrgList = validateRule.getDynamicObjectCollection("orgentryentity");
        if (CollectionUtils.isEmpty((Collection)validateRuleOrgList)) {
            return null;
        }
        for (DynamicObject newRuleOrg : newRuleOrgList) {
            Object newOrgId = newRuleOrg.getDynamicObject("org").get("id");
            for (DynamicObject validateRuleOrg : validateRuleOrgList) {
                DynamicObject validateOrg = validateRuleOrg.getDynamicObject("org");
                if (!Objects.equals(newOrgId, validateOrg.get("id"))) continue;
                return validateOrg.getString("name");
            }
        }
        return null;
    }
}

