/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.autoschedulerule;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.EntityFieldTreeOption;
import kd.tmc.fbp.common.util.EntityFieldTreeResult;
import kd.tmc.fbp.common.util.EntityTreeUtil;
import kd.tmc.fbp.common.util.ExpressionType;
import org.apache.commons.collections.bag.HashBag;

public class AutoScheduleRuleEdit
extends AbstractBasePlugIn {
    private static final String NON_FIELDS = "non_fields";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"e_datafilterdesc", "rowchengmode"});
        this.fillOrgF7();
        this.initFundFlowitem();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "org": {
                DynamicObject org = (DynamicObject)newValue;
                DynamicObjectCollection rowEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("orgentryentity");
                if (org == null || EmptyUtil.isEmpty((DynamicObject)org)) {
                    int index = this.getModel().getEntryCurrentRowIndex("orgentryentity");
                    this.getModel().deleteEntryRow("orgentryentity", index);
                    break;
                }
                List ids = rowEntrys.stream().filter(o -> Objects.nonNull(o.getDynamicObject("org"))).map(entry -> entry.getDynamicObject("org").getLong("id")).collect(Collectors.toList());
                HashBag bag = new HashBag(ids);
                int times = bag.getCount((Object)org.getLong("id"));
                if (times <= 1) break;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%1$s_%2$s \u201d\u7ec4\u7ec7\u5df2\u88ab\u9009\u62e9\uff0c\u5df2\u5220\u9664\u91cd\u590d\u9009\u62e9\u7684\u6570\u636e\u3002", (String)"AutoScheduleRuleEdit_4", (String)"tmc-psd-formplugin", (Object[])new Object[0]), org.getString("name"), org.getString("number")));
                this.getModel().deleteEntryRow("orgentryentity", rowEntrys.size() - 1);
                break;
            }
            case "onekeysche": {
                IDataModel model = this.getModel();
                int index = model.getEntryCurrentRowIndex("entryentity");
                boolean oneSchedule = (Boolean)model.getValue("onekeysche", index);
                if (!oneSchedule) {
                    this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"rowchengtrule"});
                    this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"rowticketrule"});
                }
                this.getModel().setValue("rowchengtrule", (Object)"", index);
                this.getModel().setValue("rowticketrule", (Object)"", index);
                this.getModel().setValue("rowchengmode", (Object)"", index);
            }
        }
    }

    public void click(EventObject evt) {
        int index;
        IDataModel model;
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "e_datafilterdesc": {
                model = this.getModel();
                index = model.getEntryCurrentRowIndex("entryentity");
                this.fillFields("e_datafilterdesc_real", ExpressionType.Condition, Boolean.FALSE, null);
                this.showConditionForm(index, "e_datafilterdesc_real", this.getPageCache().get("e_datafilterdesc_real"));
            }
        }
        switch (key) {
            case "rowchengmode": {
                model = this.getModel();
                index = model.getEntryCurrentRowIndex("entryentity");
                boolean oneSchedule = (Boolean)model.getValue("onekeysche", index);
                FormShowParameter fsp = new FormShowParameter();
                if (oneSchedule) {
                    fsp.setCustomParam("onekeysche", (Object)"true");
                } else {
                    fsp.setCustomParam("onekeysche", (Object)"false");
                }
                fsp.setCustomParam("schedraftradiosaveflag", (Object)this.transAmtData((BigDecimal)model.getValue("schedraftradio", index), Boolean.TRUE));
                fsp.setCustomParam("scheradiosaveflag", (Object)this.transAmtData((BigDecimal)model.getValue("scheradio", index), Boolean.TRUE));
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scheradiocallbackflag"));
                fsp.setFormId("psd_scheradio");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        if ("e_datafilterdesc_real".equals(e.getActionId())) {
            this.receiveExpressionSet(e, "entryentity", "e_datafilterdesc_real", "e_datafilterdesc_real");
        }
        if (EmptyUtil.isNoEmpty((Object)(returnData = e.getReturnData())) && "scheradiocallbackflag".equals(e.getActionId())) {
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex("entryentity");
            Map data = (Map)returnData;
            Object scheDraftRadio = data.get("schedraftradiosaveflag");
            Object scheRadio = data.get("scheradiosaveflag");
            this.displayFields(index, (BigDecimal)scheDraftRadio, (BigDecimal)scheRadio);
            model.setValue("schedraftradio", (Object)this.transAmtData((BigDecimal)scheDraftRadio, Boolean.FALSE), index);
            model.setValue("scheradio", (Object)this.transAmtData((BigDecimal)scheRadio, Boolean.FALSE), index);
            this.displayEntryData();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.displayEntryData();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if ("copyentryrowofrule".equals(evt.getOperateKey())) {
            this.displayEntryData();
        }
    }

    private void displayEntryData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity) && entryEntity.size() > 0) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryDObj = (DynamicObject)entryEntity.get(i);
                BigDecimal scheDraftRadio = entryDObj.getBigDecimal("schedraftradio");
                BigDecimal scheRadio = entryDObj.getBigDecimal("scheradio");
                BigDecimal scheduleRadio = scheDraftRadio.add(scheRadio);
                String displayStr = this.buildDisplayStr(this.transAmtData(scheDraftRadio, Boolean.TRUE), this.transAmtData(scheRadio, Boolean.TRUE), this.transAmtData(scheduleRadio, Boolean.TRUE));
                this.getModel().setValue("rowchengmode", (Object)displayStr, i);
                this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
                BigDecimal hundred = new BigDecimal("100");
                this.displayFields(i, scheDraftRadio.multiply(hundred), scheRadio.multiply(hundred));
            }
        }
    }

    private void displayFields(int index, BigDecimal scheDraftRadio, BigDecimal scheRadio) {
        if (Constants.ONE_HUNDRED.compareTo(scheDraftRadio) == 0) {
            this.getModel().setValue("rowchengtrule", (Object)"", index);
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"rowchengtrule"});
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"rowticketrule"});
        } else if (Constants.ONE_HUNDRED.compareTo(scheRadio) == 0) {
            this.getModel().setValue("rowticketrule", (Object)"", index);
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"rowticketrule"});
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"rowchengtrule"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"rowticketrule"});
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"rowchengtrule"});
        }
    }

    private String buildDisplayStr(BigDecimal scheDraftRadio, BigDecimal scheRadio, BigDecimal scheduleRadio) {
        StringBuilder sb = new StringBuilder();
        if (BigDecimal.ZERO.compareTo(scheduleRadio) <= 0) {
            if (BigDecimal.ZERO.compareTo(scheDraftRadio) < 0 && BigDecimal.ZERO.compareTo(scheRadio) < 0) {
                sb.append(ResManager.loadKDString((String)"\u6392\u7968", (String)"AutoScheduleRuleEdit_2", (String)"tmc-psd-formplugin", (Object[])new Object[0])).append(scheDraftRadio).append("%; ").append(ResManager.loadKDString((String)"\u6392\u6b3e", (String)"AutoScheduleRuleEdit_3", (String)"tmc-psd-formplugin", (Object[])new Object[0])).append(scheRadio).append('%');
            }
            if (BigDecimal.ZERO.compareTo(scheDraftRadio) < 0 && BigDecimal.ZERO.compareTo(scheRadio) == 0) {
                sb.append(ResManager.loadKDString((String)"\u6392\u7968", (String)"AutoScheduleRuleEdit_2", (String)"tmc-psd-formplugin", (Object[])new Object[0])).append(scheDraftRadio).append('%');
            }
            if (BigDecimal.ZERO.compareTo(scheDraftRadio) == 0 && BigDecimal.ZERO.compareTo(scheRadio) < 0) {
                sb.append(ResManager.loadKDString((String)"\u6392\u6b3e", (String)"AutoScheduleRuleEdit_3", (String)"tmc-psd-formplugin", (Object[])new Object[0])).append(scheRadio).append('%');
            }
        }
        return sb.toString();
    }

    private BigDecimal transAmtData(BigDecimal srcAmt, Boolean isToUp) {
        if (isToUp.booleanValue()) {
            return new BigDecimal("100").multiply(srcAmt).setScale(1, RoundingMode.HALF_UP);
        }
        return srcAmt.divide(new BigDecimal("100")).setScale(3, RoundingMode.HALF_UP);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        String opKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && StringUtils.equals((CharSequence)(opKey = (oper = (AbstractOperate)args.getSource()).getOperateKey()), (CharSequence)"save") && this.checkDraft()) {
            args.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    private boolean checkDraft() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : rows) {
            String e_rulesname = row.getString("e_rulename");
            if (!StringUtils.isEmpty((CharSequence)e_rulesname)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55\uff1a\u7b2c%s\u884c\u89c4\u5219\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AutoScheduleRuleEdit_1", (String)"tmc-psd-formplugin", (Object[])new Object[0]), row.getInt("seq")));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void fillOrgF7() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("org");
        orgF7.addBeforeF7SelectListener(evt -> {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            Long userPK = Long.valueOf(RequestContext.get().getUserId());
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
            showParameter.setCustomParam("range", (Object)orgIdSet);
        });
        IFormView view = this.getView();
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)"rowticketrule", evt -> {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            boolean oneSchedule = (Boolean)this.getModel().getValue("onekeysche", index);
            if (!oneSchedule) {
                return null;
            }
            return new QFilter("billpaytype", "=", (Object)"draftpay");
        });
    }

    protected String getDataEntityName() {
        return this.getModel().getDataEntityType().getName();
    }

    protected String getPermissionItem() {
        return "47156aff000000ac";
    }

    private void initFundFlowitem() {
        BasedataEdit fundflowitem = (BasedataEdit)this.getControl("fundflowitem");
        fundflowitem.addBeforeF7SelectListener(listener -> {
            ListShowParameter showParameter = (ListShowParameter)listener.getFormShowParameter();
            showParameter.setIsolationOrg(Boolean.FALSE.booleanValue());
            showParameter.getListFilterParameter().setFilter(new QFilter("direction", "=", (Object)"C"));
        });
    }

    private void showConditionForm(int rowIndex, String sourceCtrlKey, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("psd_condition");
        String conditionJson = (String)this.getModel().getValue(sourceCtrlKey + "_TAG", rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", "psd_schedulebill");
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent, String entityKey, String expressionFldKey, String descFldKey) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(descFldKey, (Object)"", row);
            } else {
                CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)str, CRCondition.class);
                this.getModel().setValue(expressionFldKey + "_TAG", (Object)str, row);
                String desp = "";
                if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                    desp = filterObj.getExprTran();
                }
                if (desp.length() > 1000) {
                    desp = desp.substring(0, 999);
                }
                this.getModel().setValue("e_datafilterdesc", (Object)desp, row);
            }
        }
    }

    private void fillFields(String key, ExpressionType type, boolean readChildEntity, Class<?> cls) {
        MainEntityType srcMainET = this.readSrcMainET();
        if (srcMainET == null) {
            this.getPageCache().put(key, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)srcMainET);
            option.setReadEntryEntity(readChildEntity);
            option.setExprType(type);
            option.setFieldType(cls);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            String toJson = SerializationUtils.toJsonString((Object)tree);
            this.getPageCache().put(key, toJson);
            String nonFdStr = this.getPageCache().get(NON_FIELDS);
            if (nonFdStr != null) {
                Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
                nonSet.addAll(result.getNonFields());
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)nonSet));
            } else {
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
            }
        }
    }

    private MainEntityType readSrcMainET() {
        return EntityMetadataCache.getDataEntityType((String)"psd_schedulebill");
    }
}

