/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.defaultacc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.psd.common.enums.DefaultAccountTypeEnum;
import kd.tmc.psd.common.enums.EffectReasonEnum;

public class DefaultAccountSetEdit
extends AbstractBasePlugIn {
    private static final String CACHE_KEY_F7_OLD_VALUE = "CACHE_KEY_F7_OLD_VALUE";
    private static final String CACHE_KEY_F7_NEW_VALUE = "CACHE_KEY_F7_NEW_VALUE";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.bankAccF7Filter();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("accounttype".equals(name)) {
            Object oldValue = changeSet[0].getOldValue();
            Object newValue = changeSet[0].getNewValue();
            if (oldValue != null) {
                this.getPageCache().put(CACHE_KEY_F7_OLD_VALUE, oldValue.toString());
                this.getPageCache().put(CACHE_KEY_F7_NEW_VALUE, newValue.toString());
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u8d26\u6237\u7c7b\u578b\u5c06\u6e05\u7a7a\u5206\u5f55\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DefaultAccountSetEdit_1", (String)"tmc-psd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(name, (IFormPlugin)this));
            }
        } else if ("org".equals(name) || "currency".equals(name)) {
            this.getModel().setValue("account", null);
        } else if ("effectreason".equals(name)) {
            Object newValue = changeSet[0].getNewValue();
            if (newValue == null) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"banktype", "currency"});
            } else {
                EffectReasonEnum[] values;
                String[] effectReasonArr = newValue.toString().split(",");
                List<String> effectReasonArrList = Arrays.asList(effectReasonArr);
                for (EffectReasonEnum value : values = EffectReasonEnum.values()) {
                    String propName;
                    if (value == EffectReasonEnum.ORG) continue;
                    String string = value == EffectReasonEnum.CURRENCY ? "currency" : (propName = value == EffectReasonEnum.PAYBILLTYPE ? "paybilltype" : "banktype");
                    if (effectReasonArrList.contains(value.getValue())) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{propName});
                        continue;
                    }
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{propName});
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                    for (int i = 0; i < entryEntity.size(); ++i) {
                        this.getModel().setValue(propName, null, i);
                    }
                }
            }
        }
        switch (name) {
            case "usebusiness": {
                this.getModel().setValue("accounttype", (Object)DefaultAccountTypeEnum.BANK.getValue());
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initView();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("accounttype".equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.accountTypeChangeEvent(this.getPageCache().get(CACHE_KEY_F7_NEW_VALUE));
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"accounttype", (Object)this.getPageCache().get(CACHE_KEY_F7_OLD_VALUE));
            }
        }
    }

    private void initView() {
        EffectReasonEnum[] values;
        Object accountType = this.getModel().getValue("accounttype");
        String effectReason = (String)this.getModel().getValue("effectreason");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"banktype", "currency", "paybilltype"});
        String[] effectReasonArr = effectReason.toString().split(",");
        List<String> effectReasonArrList = Arrays.asList(effectReasonArr);
        for (EffectReasonEnum value : values = EffectReasonEnum.values()) {
            String propName;
            if (value == EffectReasonEnum.ORG) continue;
            String string = value == EffectReasonEnum.CURRENCY ? "currency" : (propName = value == EffectReasonEnum.PAYBILLTYPE ? "paybilltype" : "banktype");
            if (effectReasonArrList.contains(value.getValue())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{propName});
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{propName});
        }
        this.setAccountTypeTitle(accountType);
        this.buildEffectCombItem(accountType);
    }

    private void setAccountTypeTitle(Object accountType) {
        BasedataEdit control = (BasedataEdit)this.getControl("account");
        if (accountType != null) {
            DefaultAccountTypeEnum defaultAccountTypeEnum = DefaultAccountTypeEnum.get((String)accountType.toString());
            if (DefaultAccountTypeEnum.VIRTUAL.getValue().equals(accountType.toString())) {
                defaultAccountTypeEnum = DefaultAccountTypeEnum.BANK;
            }
            if (defaultAccountTypeEnum != null) {
                control.setCaption(new LocaleString(defaultAccountTypeEnum.getName()));
            }
        }
    }

    private void buildEffectCombItem(Object accountType) {
        MulComboEdit effectReason = (MulComboEdit)this.getControl("effectreason");
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(4);
        ComboItem comboItem = new ComboItem(new LocaleString(EffectReasonEnum.ORG.getName()), EffectReasonEnum.ORG.getValue());
        list.add(comboItem);
        list.add(new ComboItem(new LocaleString(EffectReasonEnum.CURRENCY.getName()), EffectReasonEnum.CURRENCY.getValue()));
        if (accountType != null && (DefaultAccountTypeEnum.BANK.getValue().equals(accountType) || DefaultAccountTypeEnum.VIRTUAL.getValue().equals(accountType))) {
            list.add(new ComboItem(new LocaleString(EffectReasonEnum.BANKCATEGORY.getName()), EffectReasonEnum.BANKCATEGORY.getValue()));
        }
        list.add(new ComboItem(new LocaleString(EffectReasonEnum.PAYBILLTYPE.getName()), EffectReasonEnum.PAYBILLTYPE.getValue()));
        effectReason.setComboItems(list);
    }

    private void accountTypeChangeEvent(String newValue) {
        this.setAccountTypeTitle(newValue);
        this.buildEffectCombItem(newValue);
        this.getModel().setValue("effectreason", (Object)EffectReasonEnum.ORG.getValue());
        this.getModel().deleteEntryData("entryentity");
        if (!DefaultAccountTypeEnum.BANK.getValue().equals(newValue)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"banktype"});
        }
        this.getView().updateView("entryentity");
    }

    private void bankAccF7Filter() {
        BasedataEdit bankAccF7 = (BasedataEdit)this.getControl("account");
        bankAccF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Object value = this.getModel().getValue("org");
            if (value == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7", (String)"DefaultAccountSetEdit_0", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            Object accountType = this.getModel().getValue("accounttype");
            if (DefaultAccountTypeEnum.BANK.getValue().equals(accountType) || DefaultAccountTypeEnum.VIRTUAL.getValue().equals(accountType)) {
                qFilter.and(new QFilter("acctstatus", "=", (Object)BankAcctStatusEnum.NORMAL.getValue()));
                qFilter.and(new QFilter("iselecpayment", "!=", (Object)"1"));
                qFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)((Long)((DynamicObject)value).getPkValue())));
                if (DefaultAccountTypeEnum.VIRTUAL.getValue().equals(accountType)) {
                    qFilter.and(new QFilter("isvirtual", "=", (Object)"1"));
                } else {
                    qFilter.and(new QFilter("isvirtual", "=", (Object)"0"));
                }
            } else {
                qFilter.and(new QFilter("closestatus", "=", (Object)"0"));
                qFilter.and(new QFilter(String.join((CharSequence)".", "openorg", "id"), "=", ((DynamicObject)value).getPkValue()));
            }
            DynamicObjectCollection currencyObj = (DynamicObjectCollection)this.getModel().getValue("currency");
            if (currencyObj != null && currencyObj.size() > 0) {
                List currencyIdList = currencyObj.stream().map(i -> i.get("fbasedataid.id")).collect(Collectors.toList());
                QFilter currencyQFilter = new QFilter("currency.fbasedataid.id", "in", currencyIdList);
                qFilter.and(currencyQFilter);
            }
            showParameter.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
        });
    }
}

