/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payschebill;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.common.enums.AsstActTypeEnum;
import kd.tmc.psd.common.enums.DataTypeEnum;
import kd.tmc.psd.common.enums.PsdParamEnum;
import kd.tmc.psd.common.helper.PsdParameterHelper;

public class PayScheChangeDateEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String SCHBILLID = "schbillid";
    private static final String SCHBILLNO = "schbillno";
    private static Log logger = LogFactory.getLog(PayScheChangeDateEdit.class);

    public void afterCreateNewData(EventObject e) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object schBillIdsObj = billShowParameter.getCustomParam("schbillidlist");
        if (OperationStatus.ADDNEW.equals((Object)billShowParameter.getStatus()) && schBillIdsObj != null) {
            List schBillIds = (List)schBillIdsObj;
            this.buildBillData(schBillIds);
        }
    }

    public void afterBindData(EventObject e) {
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (OperationStatus.EDIT.equals((Object)billShowParameter.getStatus()) || OperationStatus.VIEW.equals((Object)billShowParameter.getStatus())) {
            BillView billView = (BillView)e.getSource();
            IDataModel model = billView.getModel();
            DynamicObjectCollection entryEntity = (DynamicObjectCollection)model.getValue(ENTRYENTITY);
            Set schBillIds = entryEntity.stream().map(dynamicObject -> dynamicObject.getLong(SCHBILLID)).collect(Collectors.toSet());
            if (EmptyUtil.isEmpty(schBillIds)) {
                return;
            }
            Map schBillMap = TmcDataServiceHelper.loadDataAndMapById((String)"psd_schedulebill", schBillIds);
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryRow = (DynamicObject)entryEntity.get(i);
                long schBillId = entryRow.getLong(SCHBILLID);
                DynamicObject schBill = (DynamicObject)schBillMap.get(schBillId);
                if (EmptyUtil.isEmpty((DynamicObject)schBill)) continue;
                entryRow.set("payeetype", (Object)AsstActTypeEnum.getName((String)schBill.getString("payeetype")));
                entryRow.set("payeename", (Object)schBill.getString("payeename"));
                entryRow.set("payeebanknum", (Object)schBill.getString("payeebanknum"));
                entryRow.set("currency", (Object)schBill.getDynamicObject("currency"));
                entryRow.set("applyamt", (Object)schBill.getBigDecimal("applyamt"));
                entryRow.set("applysettletype", (Object)schBill.getDynamicObject("applysettletype"));
                this.setValueByEntryExtendFields(schBill, i);
            }
            this.getView().updateView(ENTRYENTITY);
        }
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        super.afterBindData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("batchfillinfoop".equals(operateKey)) {
            this.batchFillInfo();
        } else if ("submit".equals(operateKey)) {
            boolean isAudit = PsdParameterHelper.getAppBoolParameter((long)((Long)this.getModel().getDataEntity().getDynamicObject("org").getPkValue()), (String)PsdParamEnum.CHANGEDATEISAPPROVAL.getValue());
            logger.info("\u6539\u671f-\u63d0\u4ea4\u6821\u9a8c\u662f\u5426\u9700\u8981\u5ba1\u6279\uff0c\u7ec4\u7ec7id\uff1a{%s}\uff0c\u662f\u5426\u5ba1\u6279\uff1a{%s}", this.getModel().getDataEntity().getDynamicObject("org").getPkValue(), (Object)isAudit);
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            if (!isAudit && operationResult.isSuccess() && !CollectionUtils.isEmpty((Collection)operationResult.getSuccessPkIds())) {
                this.getView().invokeOperation("auditop");
            }
        }
    }

    private void buildBillData(List<Long> schBillIds) {
        DynamicObject[] dbDataArr = TmcDataServiceHelper.load((Object[])schBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"psd_schedulebill"));
        this.getModel().setValue("org", dbDataArr[0].get("company"));
        this.getModel().deleteEntryData(ENTRYENTITY);
        for (DynamicObject dbData : dbDataArr) {
            int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
            this.getModel().setValue(SCHBILLID, dbData.getPkValue(), newEntryRow);
            this.getModel().setValue(SCHBILLNO, (Object)dbData.getString("billno"), newEntryRow);
            this.getModel().setValue("payeetype", (Object)AsstActTypeEnum.getName((String)dbData.getString("payeetype")), newEntryRow);
            this.getModel().setValue("payeename", (Object)dbData.getString("payeename"), newEntryRow);
            this.getModel().setValue("payeebanknum", (Object)dbData.getString("payeebanknum"), newEntryRow);
            this.getModel().setValue("currency", (Object)dbData.getDynamicObject("currency"), newEntryRow);
            this.getModel().setValue("applyamt", (Object)dbData.getBigDecimal("applyamt"), newEntryRow);
            this.getModel().setValue("applysettletype", (Object)dbData.getDynamicObject("applysettletype"), newEntryRow);
            this.getModel().setValue("olddate", (Object)dbData.getString("expectdate"), newEntryRow);
            this.setValueByEntryExtendFields(dbData, newEntryRow);
        }
    }

    private void batchFillInfo() {
        DynamicObjectCollection entryDataColl = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        if (entryDataColl.size() > 1) {
            DynamicObject firstData = (DynamicObject)entryDataColl.get(0);
            for (int i = 1; i < entryDataColl.size(); ++i) {
                this.getModel().setValue("newdate", firstData.get("newdate"), i);
                this.getModel().setValue("remark", firstData.get("remark"), i);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (EmptyUtil.isNoEmpty((String)fieldName) && SCHBILLNO.equals(fieldName)) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, hyperLinkClickEvent.getRowIndex());
            String schbillid = null;
            if (!EmptyUtil.isNoEmpty((DynamicObject)rowEntity) || !EmptyUtil.isNoEmpty((String)rowEntity.getString(SCHBILLID))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u4ed8\u6b3e\u6392\u7a0b\u5355\u3002", (String)"PayScheChangeDateEdit_0", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                return;
            }
            schbillid = rowEntity.getString(SCHBILLID);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("psd_schedulebill");
            billShowParameter.setPkId((Object)schbillid);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private void setValueByEntryExtendFields(DynamicObject scheduleBill, int entryRow) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection extendFieldConfigs = QueryServiceHelper.query((String)"psd_changefieldext", (String)"datatype, srcfield, tarfield", (QFilter[])qFilter.toArray());
        extendFieldConfigs.stream().forEach(extendFieldConfig -> {
            String srcField = extendFieldConfig.getString("srcfield");
            String tarField = extendFieldConfig.getString("tarfield");
            int dataType = extendFieldConfig.getInt("datatype");
            Object value = scheduleBill.get(srcField);
            if (EmptyUtil.isNoEmpty((Object)value)) {
                this.getModel().setValue(tarField, DataTypeEnum.convertValue((String)tarField, (int)dataType, (Object)value), entryRow);
            }
        });
    }
}

