/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payscheprocessor;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;
import kd.tmc.psd.business.service.paysche.IPayScheService;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessResult;
import kd.tmc.psd.business.service.paysche.service.PayScheServiceFactory;

public class PayScheProcessorList
extends AbstractTmcBillBaseList {
    public static final String SCHESELECTPERIODPROP_COMPANY = "SCHESELECTPERIODPROP_COMPANY";
    public static final String SCHESELECTPERIODPROP_SCHEPERIOD = "SCHESELECTPERIODPROP_SCHEPERIOD";
    public static final String SCHESELECTPERIODPROP_CURRENCY = "SCHESELECTPERIODPROP_CURRENCY";
    public static final String SCHESELECTPERIODPROP_ORGID = "SCHESELECTPERIODPROP_ORGID";
    public static final String SCHESELECTPERIODPROP_STARTDATE = "SCHESELECTPERIODPROP_STARTDATE";
    public static final String SCHESELECTPERIODPROP_ENDDATE = "SCHESELECTPERIODPROP_ENDDATE";
    private static final String DEL_OP_KEY = "delete";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if ("changedateop".equals(opKey)) {
            // empty if block
        }
        if (DEL_OP_KEY.equals(opKey) && !CollectionUtils.isEmpty((Collection)(selectedRows = this.getSelectedRows()))) {
            for (ListSelectedRow selectedRow : selectedRows) {
                Object pkId = selectedRow.getPrimaryKeyValue();
                MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(pkId), null, null, "psd_schedealbill", "modify", true, "default");
                boolean require = MutexHelper.requireMutex4BillController((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)new StringBuilder());
                if (require) continue;
                args.setCancel(true);
                String tipsFmt = ResManager.loadKDString((String)"\u5355\u636e:%s \u6b63\u5728\u4fee\u6539,\u8bf7\u7a0d\u540e\u5220\u9664", (String)"PayScheProcessorCalcPlugin_22", (String)"tmc-psd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(tipsFmt, selectedRow.getBillNo()));
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        if (EmptyUtil.isNoEmpty((Object)opResult) && opResult.isSuccess() && "startschedule".equals(args.getOperateKey())) {
            Long orgId = RequestContext.get().getOrgId();
            List selectedMainOrgIds = this.getSelectedMainOrgIds();
            if (!CollectionUtils.isEmpty((Collection)selectedMainOrgIds)) {
                orgId = (Long)selectedMainOrgIds.get(0);
            } else {
                String appId = this.getView().getFormShowParameter().getAppId();
                List authorizedBankOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getDataEntityName(), (String)this.getPermissionItem());
                if (!CollectionUtils.isEmpty((Collection)authorizedBankOrgId)) {
                    orgId = (Long)authorizedBankOrgId.get(0);
                }
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("psd_sche_selectperiod");
            fsp.setCustomParam(SCHESELECTPERIODPROP_ORGID, (Object)orgId);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "psd_sche_selectperiod");
            fsp.setCloseCallBack(callBack);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
        if ("presubmit".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            List selectedIdList = this.getSelectedIdList();
            TmcOperateServiceHelper.execOperate((String)"submit", (String)"psd_schedealbill", (Object[])selectedIdList.toArray(), (OperateOption)OperateOption.create());
        }
        if ("submit".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"PayScheProcessorCalcPlugin_18", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("billno".equals(fieldName)) {
            args.setCancel(true);
            BillList billList = (BillList)this.getControl("billlistap");
            Long processorId = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            this.showPayScheCalcPage(processorId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        Object returnData;
        super.closedCallBack(args);
        String actionId = args.getActionId();
        if ("psd_sche_selectperiod".equals(actionId) && EmptyUtil.isNoEmpty((Object)(returnData = args.getReturnData()))) {
            Long companyId = (Long)((Map)returnData).get(SCHESELECTPERIODPROP_COMPANY);
            Long scheperiodId = (Long)((Map)returnData).get(SCHESELECTPERIODPROP_SCHEPERIOD);
            List currencyIds = (List)((Map)returnData).get(SCHESELECTPERIODPROP_CURRENCY);
            Date startDate = (Date)((Map)returnData).get(SCHESELECTPERIODPROP_STARTDATE);
            Date endDate = (Date)((Map)returnData).get(SCHESELECTPERIODPROP_ENDDATE);
            this.invokeStartSche(companyId, scheperiodId, startDate, endDate, currencyIds);
        }
    }

    private boolean isOnTimeSche(Long orgId) {
        String appId = AppMetadataCache.getAppInfo((String)"psd").getId();
        return (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)orgId, (String)"ontimesche");
    }

    private void invokeStartSche(Long orgId, Long period, Date startDate, Date endDate, List<Long> currencyIds) {
        IPayScheService payScheService = PayScheServiceFactory.getPayScheService();
        PayScheProcessResult createResult = this.isOnTimeSche(orgId) ? payScheService.createNewProcessor(orgId, period, currencyIds) : payScheService.createNewProcessor(orgId, startDate, endDate, currencyIds);
        if (createResult.isSuccess()) {
            Long processorId = (Long)createResult.getResult();
            this.showPayScheCalcPage(processorId);
            BillList list = (BillList)this.getControl("billlistap");
            list.refresh();
        } else {
            List errMsgList = createResult.getErrMsgList();
            StringBuilder errMsg = new StringBuilder();
            for (String s : errMsgList) {
                errMsg.append(s).append(';');
            }
            if (errMsgList.size() == 1) {
                errMsg.deleteCharAt(errMsg.length() - 1);
            }
            this.getView().showErrorNotification(errMsg.toString());
        }
    }

    private void showPayScheCalcPage(Long processorId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("psd_schebillcalc");
        showParameter.setCustomParam("KEY_PROCESSOR_ID", (Object)processorId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }
}

