/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payscheprocessor;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.period.PeriodHelper;
import kd.tmc.psd.common.enums.PsdParamEnum;
import kd.tmc.psd.common.helper.PayScheHelper;
import kd.tmc.psd.common.helper.PsdParameterHelper;

public class PayScheSelectPeriodEdit
extends AbstractFormPlugin {
    public static final String SCHESELECTPERIODPROP_COMPANY = "SCHESELECTPERIODPROP_COMPANY";
    public static final String SCHESELECTPERIODPROP_SCHEPERIOD = "SCHESELECTPERIODPROP_SCHEPERIOD";
    public static final String SCHESELECTPERIODPROP_ORGID = "SCHESELECTPERIODPROP_ORGID";
    public static final String SCHESELECTPERIODPROP_CURRENCY = "SCHESELECTPERIODPROP_CURRENCY";
    public static final String SCHESELECTPERIODPROP_STARTDATE = "SCHESELECTPERIODPROP_STARTDATE";
    public static final String SCHESELECTPERIODPROP_ENDDATE = "SCHESELECTPERIODPROP_ENDDATE";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IDataModel model = this.getModel();
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"psd_schedealbill", (String)"47150e89000000ac");
        TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"company", evt -> new QFilter("id", "in", (Object)authOrgIds));
        TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"scheperiod", evt -> {
            DynamicObject companyDO = model.getDataEntity().getDynamicObject("company");
            if (EmptyUtil.isEmpty((DynamicObject)companyDO)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u7ec4\u7ec7", (String)"PayScheSelectPeriodEdit_0", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            }
            DynamicObject autoScheRule = TmcDataServiceHelper.loadSingle((String)"psd_autoschedule_rule", (String)"scheduleperiod", (QFilter[])new QFilter[]{new QFilter("orgentryentity.org.id", "=", companyDO.getPkValue()), new QFilter("enable", "=", (Object)"1"), PayScheHelper.buildAutoRuleEffDateFilter()});
            if (null == autoScheRule && null == (autoScheRule = TmcDataServiceHelper.loadSingle((String)"psd_autoschedule_rule", (String)"scheduleperiod", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), QFilter.isNull((String)"orgentryentity.org.id"), PayScheHelper.buildAutoRuleEffDateFilter()}))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u65f6\u6ca1\u6709\u201c%s\u201d\u7ec4\u7ec7\u7684\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\uff0c\u8bf7\u5148\u8bbe\u7f6e\u8be5\u7ec4\u7ec7\u6216\u521b\u5efa\u9002\u7528\u7a7a\u7ec4\u7ec7\u7684\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\u3002", (String)"PayScheSelectPeriodEdit_1", (String)"tmc-psd-formplugin", (Object[])new Object[0]), companyDO.getString("name")));
            }
            DynamicObject periodType = autoScheRule.getDynamicObject("scheduleperiod");
            if (null == periodType) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7684\u81ea\u52a8\u6392\u7a0b\u89c4\u5219\u6ca1\u6709\u542f\u7528\u7684\u5468\u671f\u7c7b\u578b\uff0c\u8bf7\u5148\u8bbe\u7f6e\u81ea\u52a8\u6392\u7a0b\u89c4\u5219(%s)\u7684\u5468\u671f\u7c7b\u578b\u3002", (String)"PeriodHelper_1", (String)"tmc-psd-business", (Object[])new Object[0]), autoScheRule.getString("name")));
            }
            QFilter filter = new QFilter("enddate", ">=", (Object)DateUtils.getCurrentDate());
            filter.and(new QFilter("schetype", "=", periodType.getPkValue()));
            return filter;
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        if (newValue == oldValue) {
            return;
        }
        switch (fieldKey) {
            case "company": {
                if (EmptyUtil.isEmpty((Object)newValue)) {
                    this.getModel().setValue("scheperiod", null);
                    return;
                }
                DynamicObject currPeriod = null;
                Object orgId = ((DynamicObject)newValue).getPkValue();
                try {
                    currPeriod = PeriodHelper.getCurrPeriod((Long)((Long)orgId));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.getModel().setValue("scheperiod", EmptyUtil.isNoEmpty((DynamicObject)currPeriod) ? currPeriod.getPkValue() : null);
                DynamicObject currency = TmcBusinessBaseHelper.getCasBaseCurrency((long)((Long)orgId));
                if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                    this.getModel().setValue("currency", (Object)TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"currency", (DynamicObject[])new DynamicObject[]{currency}));
                }
                this.setPageStyle((Long)orgId);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject currPeriod = null;
        FormShowParameter showPara = this.getView().getFormShowParameter();
        Object orgId = showPara.getCustomParam(SCHESELECTPERIODPROP_ORGID);
        if (orgId instanceof Integer) {
            orgId = ((Integer)orgId).longValue();
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"psd_schedealbill", (String)"47150e89000000ac");
        if (!EmptyUtil.isEmpty((Collection)authOrgIds) && authOrgIds.contains(orgId)) {
            this.getModel().setValue("company", orgId);
            try {
                currPeriod = PeriodHelper.getCurrPeriod((Long)((Long)orgId));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.isOnTimeSche(this.getOrgIdFormShowParameter())) {
                this.getModel().setValue("startdate", (Object)new Date());
                this.getModel().setValue("enddate", (Object)new Date());
            } else if (EmptyUtil.isNoEmpty((DynamicObject)currPeriod)) {
                this.getModel().setValue("scheperiod", currPeriod.getPkValue());
            }
            DynamicObject currency = TmcBusinessBaseHelper.getCasBaseCurrency((long)((Long)orgId));
            if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                this.getModel().setValue("currency", (Object)TmcDataServiceHelper.generateMultiPropValue((DynamicObject)this.getModel().getDataEntity(), (String)"currency", (DynamicObject[])new DynamicObject[]{currency}));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if ("btnok".equals(opKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Date startDate = dataEntity.getDate("startdate");
            Date endDate = dataEntity.getDate("enddate");
            if (startDate != null && endDate != null && endDate.before(startDate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"PayScheSelectPeriodEdit_3", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("btnok".equals(operateKey) && opResult.isSuccess()) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Long orgId = (Long)dataEntity.getDynamicObject("company").getPkValue();
            DynamicObject scheperiod = dataEntity.getDynamicObject("scheperiod");
            DynamicObjectCollection currencys = dataEntity.getDynamicObjectCollection("currency");
            List currencyIds = currencys.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            boolean sysParm = PsdParameterHelper.getAppBoolParameter((long)orgId, (String)PsdParamEnum.PSD001.getValue());
            if (!sysParm) {
                DynamicObject orgDO = TmcDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org", (String)"id,name");
                String errorMessage = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a\u201c%s\u201d\u672a\u5f00\u542f\u4ed8\u6b3e\u6392\u7a0b\u53c2\u6570\uff0c\u65e0\u6cd5\u53d1\u8d77\u6392\u7a0b\u64cd\u4f5c\u3002", (String)"PayScheSelectPeriodEdit_2", (String)"tmc-psd-formplugin", (Object[])new Object[0]), orgDO.getString("name"));
                this.getView().showErrorNotification(errorMessage);
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put(SCHESELECTPERIODPROP_COMPANY, orgId);
            if (scheperiod != null) {
                returnData.put(SCHESELECTPERIODPROP_SCHEPERIOD, (Long)scheperiod.getPkValue());
            }
            returnData.put(SCHESELECTPERIODPROP_CURRENCY, currencyIds);
            returnData.put(SCHESELECTPERIODPROP_STARTDATE, dataEntity.getDate("startdate"));
            returnData.put(SCHESELECTPERIODPROP_ENDDATE, dataEntity.getDate("enddate"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long orgId = this.getOrgIdFormShowParameter();
        if (null != orgId) {
            this.setPageStyle(orgId);
        }
    }

    private Long getOrgIdFormShowParameter() {
        FormShowParameter showPara = this.getView().getFormShowParameter();
        Object orgId = showPara.getCustomParam(SCHESELECTPERIODPROP_ORGID);
        if (orgId instanceof Integer) {
            orgId = ((Integer)orgId).longValue();
        }
        return (Long)orgId;
    }

    private void setPageStyle(Long orgId) {
        boolean onTimeSche = this.isOnTimeSche(orgId);
        this.getView().setVisible(Boolean.valueOf(onTimeSche), new String[]{"scheperiod"});
        this.getView().setVisible(Boolean.valueOf(!onTimeSche), new String[]{"startdate"});
        this.getView().setVisible(Boolean.valueOf(!onTimeSche), new String[]{"enddate"});
        BasedataEdit schePeriodEdit = (BasedataEdit)this.getControl("scheperiod");
        schePeriodEdit.setMustInput(onTimeSche);
        DateEdit startDateEdit = (DateEdit)this.getControl("startdate");
        startDateEdit.setMustInput(!onTimeSche);
        DateEdit endDateEdit = (DateEdit)this.getControl("enddate");
        endDateEdit.setMustInput(!onTimeSche);
        if (onTimeSche) {
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
        } else {
            this.getModel().setValue("scheperiod", null);
            this.getModel().setValue("startdate", (Object)new Date());
            this.getModel().setValue("enddate", (Object)new Date());
        }
    }

    private boolean isOnTimeSche(Long orgId) {
        String appId = AppMetadataCache.getAppInfo((String)"psd").getId();
        if (null == orgId) {
            throw new KDBizException("org Id is null");
        }
        return (Boolean)TmcParameterHelper.getAppParameter((String)appId, (Long)orgId, (String)"ontimesche");
    }
}

