/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payscheprocessor;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.data.sum.PayScheSumData;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.sumsche.SumScheRepository;
import kd.tmc.psd.business.service.paysche.sumsche.data.SumScheInfo;

public class PayScheSumInfoEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "defaultsave"});
        TmcViewInputHelper.addF7Filter((IFormView)this.getView(), (String)"primerule", e1 -> PayScheHelper.getPrimeRuleFiler((long)((Long)this.getModel().getValue("orgid"))));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showPara = this.getView().getFormShowParameter();
        String sumInfoJson = (String)showPara.getCustomParam("KEY_SUMENTRYINFO");
        String sumScheInfoJson = (String)showPara.getCustomParam("KEY_SUMSCHEINFO");
        Object orgId = showPara.getCustomParam("orgid");
        Object periodTypeId = showPara.getCustomParam("scheperiodid");
        this.getModel().setValue("orgid", orgId);
        this.getModel().setValue("scheperiodid", periodTypeId);
        if (EmptyUtil.isNoEmpty((String)sumInfoJson)) {
            PayScheSumData sumData = (PayScheSumData)JSON.parseObject((String)sumInfoJson, PayScheSumData.class);
            this.getModel().setValue("currency", (Object)sumData.getCurrencyId());
            this.getModel().setValue("applyamt", (Object)sumData.getApplyAmt());
            this.getModel().setValue("sumname", (Object)sumData.getDimName());
        }
        if (EmptyUtil.isNoEmpty((String)sumScheInfoJson)) {
            SumScheInfo sumScheInfo = (SumScheInfo)JSON.parseObject((String)sumScheInfoJson, SumScheInfo.class);
            this.getModel().setValue("fundscale", (Object)this.realVal2Percent(sumScheInfo.getFundScale()));
            this.getModel().setValue("billscale", (Object)this.realVal2Percent(sumScheInfo.getBillScale()));
            this.getModel().setValue("primerule", (Object)sumScheInfo.getPrimaryRuleId());
            this.getModel().setValue("dimtype", (Object)sumScheInfo.getSumDimType());
            this.getModel().setValue("dimval", (Object)sumScheInfo.getSumDimVal());
            this.calcSumInfo();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if ("fundscale".equals(propName) || "billscale".equals(propName)) {
            BigDecimal fundScale = (BigDecimal)this.getModel().getValue("fundscale");
            BigDecimal billScale = (BigDecimal)this.getModel().getValue("billscale");
            BigDecimal totalScale = fundScale.add(billScale);
            boolean isLegal = true;
            if (BigDecimal.valueOf(100L).compareTo(totalScale) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6392\u6b3e\u6392\u7968\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u5f97\u8d85\u8fc7100%\u3002", (String)"PayScheSumInfoEdit_1", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(propName, (Object)BigDecimal.ZERO);
                isLegal = false;
            }
            if (BigDecimal.ZERO.compareTo(fundScale) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6392\u6b3e\u6bd4\u4f8b\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"PayScheSumInfoEdit_2", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("fundscale", (Object)BigDecimal.ZERO);
                isLegal = false;
            }
            if (BigDecimal.ZERO.compareTo(billScale) > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6392\u7968\u6bd4\u4f8b\u4e0d\u5f97\u5c0f\u4e8e0%\u3002", (String)"PayScheSumInfoEdit_3", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("billscale", (Object)BigDecimal.ZERO);
                isLegal = false;
            }
            if (isLegal) {
                this.calcSumInfo();
            }
        }
    }

    private void calcSumInfo() {
        BigDecimal applyAmt = (BigDecimal)this.getModel().getValue("applyamt");
        BigDecimal fundScale = this.percent2RealVal((BigDecimal)this.getModel().getValue("fundscale"));
        BigDecimal billScale = this.percent2RealVal((BigDecimal)this.getModel().getValue("billscale"));
        BigDecimal fundAmt = applyAmt.multiply(fundScale);
        BigDecimal billAmt = applyAmt.multiply(billScale);
        BigDecimal scheScale = fundScale.add(billScale);
        BigDecimal scheAmt = applyAmt.multiply(scheScale);
        BigDecimal scheBalance = applyAmt.subtract(scheAmt);
        this.getModel().setValue("fundamt", (Object)fundAmt);
        this.getModel().setValue("billamt", (Object)billAmt);
        this.getModel().setValue("schescale", (Object)this.realVal2Percent(scheScale));
        this.getModel().setValue("scheamt", (Object)scheAmt);
        this.getModel().setValue("balanceamt", (Object)scheBalance);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Button) {
            String key = ((Button)src).getKey();
            if ("btnok".equals(key)) {
                SumScheInfo sumScheInfo = this.createSumScheInfo();
                this.getView().returnDataToParent((Object)sumScheInfo);
                this.getView().close();
            } else if ("defaultsave".equals(key)) {
                long orgId = (Long)this.getModel().getValue("orgid");
                long periodTypeId = (Long)this.getModel().getValue("scheperiodid");
                SumScheInfo sumScheInfo = this.createSumScheInfo();
                new SumScheRepository().updateSumScheInfo(orgId, periodTypeId, sumScheInfo.getSumDimType(), sumScheInfo);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u89c4\u5219\u4fdd\u5b58\u6210\u529f\u3002", (String)"PayScheSumInfoEdit_4", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private SumScheInfo createSumScheInfo() {
        String dimType = (String)this.getModel().getValue("dimtype");
        String dimVal = (String)this.getModel().getValue("dimval");
        String scheName = (String)this.getModel().getValue("sumname");
        BigDecimal fundScale = this.percent2RealVal((BigDecimal)this.getModel().getValue("fundscale"));
        BigDecimal billScale = this.percent2RealVal((BigDecimal)this.getModel().getValue("billscale"));
        DynamicObject primeRule = (DynamicObject)this.getModel().getValue("primerule");
        BigDecimal fundAmt = (BigDecimal)this.getModel().getValue("fundamt");
        BigDecimal billAmt = (BigDecimal)this.getModel().getValue("billamt");
        SumScheInfo sumScheInfo = new SumScheInfo();
        sumScheInfo.setName(scheName);
        sumScheInfo.setSumDimType(dimType);
        sumScheInfo.setSumDimVal(dimVal);
        sumScheInfo.setFundScale(fundScale);
        sumScheInfo.setBillScale(billScale);
        sumScheInfo.setBillTotalAmt(billAmt);
        sumScheInfo.setFundTotalAmt(fundAmt);
        sumScheInfo.setPrimaryRuleId(primeRule != null ? (Long)primeRule.getPkValue() : null);
        return sumScheInfo;
    }

    private BigDecimal percent2RealVal(BigDecimal percentVal) {
        return percentVal.divide(BigDecimal.valueOf(100L), 3, RoundingMode.HALF_UP);
    }

    private BigDecimal realVal2Percent(BigDecimal realVal) {
        return realVal.multiply(BigDecimal.valueOf(100L));
    }
}

