/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payscheprocessor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;

public class PsdCombineRuleEdit
extends AbstractBillPlugIn {
    private static final String[] PRESETFIELDKEYS = new String[]{"e_company", "e_payeetype", "e_payeename", "e_sourcebilltype", "e_currency"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map datas = ExpressionFromHelper.getFieldColumn((String)"psd_schebillentrytpl", (boolean)false, (boolean)false, (String[])new String[0]);
        this.setComboEditValue(datas);
        this.lockRowByIndex(0, 1, 2, 3, 4);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map datas = ExpressionFromHelper.getFieldColumn((String)"psd_schebillentrytpl", (boolean)false, (boolean)false, (String[])new String[0]);
        this.setComboEditValue(datas);
        this.presetRules();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        switch (propName) {
            case "feildvalue": {
                int times = 0;
                Map psdSchebillMap = ExpressionFromHelper.getFieldColumn((String)"psd_schebillentrytpl", (boolean)false, (boolean)false, (String[])new String[0]);
                if (null == propValue || propValue.toString().trim().isEmpty()) {
                    this.getModel().setValue("feildname", (Object)"", valueSet[0].getRowIndex());
                    this.getModel().setValue("feildvalue", (Object)"", valueSet[0].getRowIndex());
                    this.getModel().setDataChanged(false);
                    break;
                }
                String name = ((LocaleString)psdSchebillMap.get(propValue)).getLocaleValue();
                DynamicObjectCollection doc = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject row : doc) {
                    String value = row.getString("feildvalue");
                    if (!propValue.equals(value) || times > true) continue;
                    ++times;
                }
                if (times > 1) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u201c%s\u201d\u5c5e\u6027\uff0c\u65e0\u6cd5\u91cd\u590d\u9009\u62e9\u3002", (String)"PsdCombineRuleEdit_01", (String)"tmc-psd-formplugin", (Object[])new Object[0]), name));
                    break;
                }
                this.getModel().setValue("feildname", (Object)name, valueSet[0].getRowIndex());
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rows = e.getRowIndexs();
        if (rows.length == 0) {
            return;
        }
        if (rows[0] < PRESETFIELDKEYS.length) {
            e.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\u4e0d\u53ef\u5220\u9664\u3002", (String)"PsdCombineRuleEdit_02", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
        }
    }

    private void presetRules() {
        Map psdSchebillMap = ExpressionFromHelper.getFieldColumn((String)"psd_schebillentrytpl", (boolean)false, (boolean)false, (String[])new String[0]);
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        if (rowCount < PRESETFIELDKEYS.length) {
            this.getModel().batchCreateNewEntryRow("entryentity", PRESETFIELDKEYS.length - rowCount);
        }
        for (int row = 0; row < PRESETFIELDKEYS.length; ++row) {
            this.getModel().setValue("feildvalue", (Object)PRESETFIELDKEYS[row], row);
            String name = ((LocaleString)psdSchebillMap.get(PRESETFIELDKEYS[row])).getLocaleValue();
            this.getModel().setValue("feildname", (Object)name, row);
            this.lockRowByIndex(0, 1, 2, 3, 4);
        }
    }

    private void setComboEditValue(Map<String, LocaleString> datas) {
        if (null == datas || datas.isEmpty()) {
            return;
        }
        ComboEdit fields = (ComboEdit)this.getControl("feildvalue");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (Map.Entry<String, LocaleString> entry : datas.entrySet()) {
            ComboItem item = new ComboItem(entry.getValue(), entry.getKey());
            items.add(item);
        }
        fields.setComboItems(items);
    }

    private void lockRowByIndex(int ... indexs) {
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.setRowLock(true, indexs);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if ("save".equals(opKey)) {
            Map psdSchebillMap = ExpressionFromHelper.getFieldColumn((String)"psd_schebillentrytpl", (boolean)false, (boolean)false, (String[])new String[0]);
            DynamicObjectCollection entryentitys = this.getModel().getEntryEntity("entryentity");
            String combinefields = entryentitys.stream().map(o -> ((LocaleString)psdSchebillMap.get(o.getString("feildvalue"))).getLocaleValue()).collect(Collectors.joining(","));
            String combinefieldsCN = entryentitys.stream().map(o -> ((LocaleString)psdSchebillMap.get(o.getString("feildvalue"))).getLocaleValue_zh_CN()).collect(Collectors.joining(","));
            String combinefieldsTW = entryentitys.stream().map(o -> ((LocaleString)psdSchebillMap.get(o.getString("feildvalue"))).getLocaleValue_zh_TW()).collect(Collectors.joining(","));
            String combinefieldsEN = entryentitys.stream().map(o -> ((LocaleString)psdSchebillMap.get(o.getString("feildvalue"))).getLocaleValue_en()).collect(Collectors.joining(","));
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue(combinefields);
            localeString.setLocaleValue_zh_CN(combinefieldsCN);
            localeString.setLocaleValue_zh_TW(combinefieldsTW);
            localeString.setLocaleValue_en(combinefieldsEN);
            this.getModel().setValue("combinefields", (Object)localeString);
        }
    }
}

