/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payscheprocessor.calc;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.tmc.fbp.common.enums.BankAcctStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcAccountHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.IPayScheProcessorView;
import kd.tmc.psd.business.service.paysche.controller.PayScheCalcBaseHandler;
import kd.tmc.psd.business.service.paysche.data.PayScheDataTransfer;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.sum.SumScheData;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.common.enums.DirectionEnum;
import kd.tmc.psd.common.enums.DraftPayTypeEnum;
import kd.tmc.psd.common.enums.PsdCombineModeEnum;
import kd.tmc.psd.common.enums.SettleMentTypeEnum;
import kd.tmc.psd.common.untils.StringUtils;

public abstract class PayScheCalcBasePlugin<T extends SumScheData>
extends AbstractFormPlugin
implements IPayScheProcessorView<T> {
    protected static final Log logger = LogFactory.getLog(PayScheCalcBasePlugin.class);
    private boolean skipPropChange;
    private PayScheDataTransfer payScheDataTransfer;
    private static final String KEY_COMBINEPROCESSPAGE = "KEY_COMBINEPROCESSPAGE";

    public String getCurrentPageId() {
        return this.getView().getPageId();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.hypeEvtDeal();
        this.initF7();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.skipPropChange) {
            return;
        }
        String proKeyName = e.getProperty().getName();
        String pageId = null;
        if (e.getProperty().getParent() != null && "entryentity".equals(e.getProperty().getParent().getName())) {
            List needRevertIdList;
            if ("e_draftno".equals(proKeyName) || "e_paycurrency".equals(proKeyName) || "e_draftsettletype".equals(proKeyName)) {
                pageId = this.getPageId();
            }
            DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
            DynamicObject payScheEntryData = (DynamicObject)entryList.get(e.getChangeSet()[0].getRowIndex());
            PayScheCalcModel scheModel = this.getPayScheDataTransfer().transDataToCalcModel(payScheEntryData);
            if ("e_isbilldibs".equals(proKeyName)) {
                scheModel.setDraftBillIds(new ArrayList());
            }
            if ((needRevertIdList = this.getHandler().updateScheInfo(scheModel.getSummaryId(), new ArrayList<PayScheCalcModel>(Collections.singletonList(scheModel)), pageId, proKeyName, scheModel.isArchiveMerger(), null)).size() > 0) {
                Map<Long, ChangeData> scheIdToChangeDataMap = Arrays.stream(e.getChangeSet()).collect(Collectors.toMap(o -> ((DynamicObject)entryList.get(o.getRowIndex())).getLong("e_id"), o -> o));
                for (Long revertScheId : needRevertIdList) {
                    ChangeData afterChangeData = scheIdToChangeDataMap.get(revertScheId);
                    this.skipPropChange = true;
                    this.getModel().setValue(proKeyName, afterChangeData.getOldValue(), afterChangeData.getRowIndex());
                    this.skipPropChange = false;
                }
            }
        }
    }

    public void updateScheDataList(List<PayScheCalcModel> scheDataList, boolean isReplace) {
        IDataModel model = this.getModel();
        if (isReplace) {
            this.getModel().deleteEntryData("entryentity");
            List normalScheDataList = scheDataList.stream().filter(o -> o.getSplitId() == null || o.getSplitId() == 0L).collect(Collectors.toList());
            List splitScheDataList = scheDataList.stream().filter(o -> o.getSplitId() != null && o.getSplitId() != 0L).collect(Collectors.toList());
            normalScheDataList.sort((a, b) -> {
                String nameB;
                String nameA = a.getPayeeName();
                int nameRes = nameA.compareTo(nameB = b.getPayeeName());
                if (nameRes == 0) {
                    if (a.getBatchnum() != null && b.getBatchnum() != null) {
                        return a.getBatchnum().compareTo(b.getBatchnum());
                    }
                    if (a.getBatchnum() == null && b.getBatchnum() != null) {
                        return -1;
                    }
                    if (a.getBatchnum() != null && b.getBatchnum() == null) {
                        return 1;
                    }
                    return 0;
                }
                return nameRes;
            });
            ArrayList sortedScheDataList = new ArrayList(normalScheDataList);
            List scheIdList = sortedScheDataList.stream().map(PayScheCalcModel::getScheId).collect(Collectors.toList());
            for (PayScheCalcModel payScheCalcModel : splitScheDataList) {
                Long splitId = payScheCalcModel.getSplitId();
                int index = scheIdList.indexOf(splitId);
                sortedScheDataList.add(index + 1, payScheCalcModel);
                scheIdList.add(index + 1, payScheCalcModel.getScheId());
            }
            List entryValueMap = this.getPayScheDataTransfer().transCalcModelToCalcEntry(this.getModel(), sortedScheDataList);
            TmcViewInputHelper.batchFillEntity((String)"entryentity", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), (List)entryValueMap);
            DynamicObjectCollection cEntry = model.getEntryEntity("entryentity");
            this.skipPropChange = true;
            for (DynamicObject entry : cEntry) {
                Object entryId = entry.get("e_id");
                PayScheCalcModel payScheCalcModel = sortedScheDataList.stream().filter(o -> o.getScheId().equals(entryId)).findFirst().orElseGet(() -> null);
                if (payScheCalcModel == null) continue;
                int index = sortedScheDataList.indexOf(payScheCalcModel);
                this.getPayScheDataTransfer().transCalcModelToCalcEntry(model, payScheCalcModel, index, true);
            }
            this.skipPropChange = false;
            this.getView().updateView("entryentity");
        } else {
            this.skipPropChange = true;
            DynamicObjectCollection entryList = model.getEntryEntity("entryentity");
            List idList = entryList.stream().map(o -> o.getLong("e_id")).collect(Collectors.toList());
            List splitIdList = entryList.stream().map(o -> o.getLong("e_splitid")).collect(Collectors.toList());
            List newScheList = scheDataList.stream().filter(o -> o.isNewScheData() && !idList.contains(o.getScheId())).sorted(Comparator.comparing(PayScheCalcModel::getScheId)).collect(Collectors.toList());
            this.getModel().beginInit();
            for (PayScheCalcModel payScheCalcModel : newScheList) {
                Long splitId = payScheCalcModel.getSplitId();
                int splitSourceIndex = splitIdList.lastIndexOf(splitId);
                if (splitSourceIndex == -1) {
                    splitSourceIndex = idList.indexOf(splitId);
                }
                if (splitSourceIndex == -1) {
                    splitSourceIndex = idList.size() - 1;
                }
                DynamicObject newEntryRow = new DynamicObject(PayScheCalcModel.getCalcEntryType());
                newEntryRow.set("id", (Object)payScheCalcModel.getScheId());
                newEntryRow.set("e_id", (Object)payScheCalcModel.getScheId());
                this.getModel().createNewEntryRow("entryentity", splitSourceIndex + 1, newEntryRow);
                idList.add(splitSourceIndex + 1, payScheCalcModel.getScheId());
            }
            this.getModel().endInit();
            for (PayScheCalcModel payScheCalcModel : scheDataList) {
                Long scheId = payScheCalcModel.getScheId();
                int rowIndex = idList.indexOf(scheId);
                this.getPayScheDataTransfer().transCalcModelToCalcEntry(model, payScheCalcModel, rowIndex, false);
            }
            this.skipPropChange = false;
            this.getView().updateView("entryentity");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getHandler().release();
    }

    public void deleteScheData(List<PayScheCalcModel> scheDataList) {
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
        List idList = entryList.stream().map(o -> o.getLong("e_id")).collect(Collectors.toList());
        int[] rows = scheDataList.stream().map(o -> idList.indexOf(o.getScheId())).mapToInt(o -> o).toArray();
        this.getModel().deleteEntryRows("entryentity", rows);
    }

    public void showErrorMessage(List<String> errMsg) {
        if (errMsg.size() > 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u4ee5\u4e0b\u9519\u8bef\u6d88\u606f\uff1a\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"PayScheProcessorCalcPlugin_01", (String)"tmc-psd-formplugin", (Object[])new Object[0]), errMsg.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
        } else if (errMsg.size() == 1) {
            this.getView().showErrorNotification(errMsg.get(0));
        }
    }

    public void showSuccessMessage(String successMsg) {
        this.getView().showSuccessNotification(successMsg);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (KEY_COMBINEPROCESSPAGE.equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            String serializeStr = returnData.toString();
            List calcModelLst = PayScheCalcModel.deserializeList((String)serializeStr);
            this.getHandler().directUpdateDataList(calcModelLst);
        }
    }

    protected abstract PayScheCalcBaseHandler<T> getHandler();

    protected PayScheDataTransfer getPayScheDataTransfer() {
        if (this.payScheDataTransfer == null) {
            this.payScheDataTransfer = new PayScheDataTransfer();
        }
        return this.payScheDataTransfer;
    }

    protected List<Long> getSelectPayScheIdList() {
        List<DynamicObject> selectPayScheList = this.getSelectPayScheList();
        return selectPayScheList.stream().filter(Objects::nonNull).map(o -> o.getLong("e_id")).collect(Collectors.toList());
    }

    protected List<DynamicObject> getSelectPayScheList() {
        ArrayList<DynamicObject> dyObjList = new ArrayList<DynamicObject>(10);
        EntryGrid entryList = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryList.getSelectRows();
        if (selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u660e\u7ec6\u884c\u672a\u88ab\u9009\u4e2d\u3002", (String)"PayScheProcessorCalcPlugin_03", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
        }
        for (int selectRow : selectRows) {
            DynamicObject settleType;
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", selectRow);
            String opKey = this.getPageCache().get("opKey");
            if (EmptyUtil.isNoEmpty((String)opKey) && ("batchschedule".equals(opKey) || "batchdraft".equals(opKey) || "autoschedule".equals(opKey)) && (EmptyUtil.isNoEmpty((DynamicObject)(settleType = entryRowEntity.getDynamicObject("e_applysettletype"))) && SettleMentTypeEnum.DIGITALWALLET.getValue().equals(settleType.getString("settlementtype")) || EmptyUtil.isNoEmpty((Long)entryRowEntity.getLong("e_entrustpayid")))) continue;
            dyObjList.add(this.getModel().getEntryRowEntity("entryentity", selectRow));
        }
        this.getPageCache().remove("opKey");
        return dyObjList;
    }

    List<DynamicObject> getSelectScheduleDetailList() {
        ArrayList<DynamicObject> selectScheduleDetailList = new ArrayList<DynamicObject>(10);
        EntryGrid entryList = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryList.getSelectRows();
        if (selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u660e\u7ec6\u884c\u672a\u88ab\u9009\u4e2d\u3002", (String)"PayScheProcessorCalcPlugin_03", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
        }
        Arrays.stream(selectRows).forEach(selectRow -> selectScheduleDetailList.add(this.getModel().getEntryRowEntity("entryentity", selectRow)));
        return selectScheduleDetailList;
    }

    protected void checkScheSelectRow() {
        EntryGrid entryList = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryList.getSelectRows();
        if (selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u660e\u7ec6\u884c\u672a\u88ab\u9009\u4e2d\u3002", (String)"PayScheProcessorCalcPlugin_03", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
        }
    }

    protected void checkReject() {
        String splitNo;
        EntryGrid entryList = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryList.getSelectRows();
        DynamicObjectCollection entryEntries = this.getModel().getEntryEntity("entryentity");
        HashSet<String> splitNos = new HashSet<String>(entryEntries.size());
        for (DynamicObject entry : entryEntries) {
            splitNo = entry.getString("e_splitno");
            if (StringUtils.isEmpty((String)splitNo)) continue;
            splitNos.add(splitNo);
        }
        for (int i = 0; i < selectRows.length; ++i) {
            DynamicObject selectObject = this.getModel().getEntryRowEntity("entryentity", selectRows[i]);
            splitNo = selectObject.getString("e_splitno");
            String billNo = selectObject.getString("e_billno");
            if (!StringUtils.isNotEmpty((String)splitNo) && !splitNos.contains(billNo)) continue;
            String message = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u6392\u7a0b\u5355\u53f7\u201c%s\u201d\u4e3a\u62c6\u5206\u7684\u6392\u7a0b\u660e\u7ec6\uff0c\u4e0d\u652f\u6301\u76f4\u63a5\u62d2\u4ed8\u3002\u8bf7\u5148\u5ba1\u6838\u6392\u7a0b\u5904\u7406\u5355\uff0c\u518d\u901a\u8fc7\u9000\u5355\u529f\u80fd\u5b8c\u6210\u3002", (String)"PayScheProcessorCalcPlugin_21", (String)"tmc-psd-formplugin", (Object[])new Object[0]), billNo);
            throw new KDBizException(message);
        }
    }

    private void initF7() {
        IFormView view = this.getView();
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)"e_acctbank", evt -> {
            if (!this.doInitF7("e_acctbank")) {
                return null;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Long orgId = this.getOrgId();
            int row = evt.getRow();
            QFilter qFilter = null;
            DynamicObject entryDataEntity = (DynamicObject)entryEntity.get(row);
            DynamicObject currencyDObj = entryDataEntity.getDynamicObject("e_paycurrency");
            if (EmptyUtil.isNoEmpty((DynamicObject)currencyDObj)) {
                String e_acctbanktype = entryDataEntity.getString("e_acctbanktype");
                if ("bd_accountbanks".equals(e_acctbanktype)) {
                    QFilter accountAuthAssignFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId);
                    ArrayList<String> bankStatus = new ArrayList<String>(4);
                    bankStatus.add(BankAcctStatusEnum.NORMAL.getValue());
                    bankStatus.add(BankAcctStatusEnum.CLOSING.getValue());
                    bankStatus.add(BankAcctStatusEnum.CHANGING.getValue());
                    qFilter = accountAuthAssignFilter.and("acctstatus", "in", bankStatus).and("currency.fbasedataid", "=", currencyDObj.getPkValue());
                } else {
                    qFilter = new QFilter("org", "=", (Object)orgId).and("currency.fbasedataid", "=", currencyDObj.getPkValue());
                }
            }
            return qFilter;
        });
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)"e_fundflowitem", evt -> {
            if (!this.doInitF7("e_fundflowitem")) {
                return null;
            }
            return new QFilter("direction", "in", (Object)new String[]{DirectionEnum.INOROUT.getValue(), DirectionEnum.OUT.getValue()});
        });
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)"e_draftsettletype", evt -> {
            if (!this.doInitF7("e_draftsettletype")) {
                return null;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            int row = evt.getRow();
            DynamicObject entryDataEntity = (DynamicObject)entryEntity.get(row);
            String draftPaymethod = entryDataEntity.getString("e_draftpaymethod");
            QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
            if (EmptyUtil.isNoEmpty((String)draftPaymethod)) {
                if (DraftPayTypeEnum.DRAFTBOOK.getValue().equals(draftPaymethod)) {
                    qFilter = new QFilter("settlementtype", "in", Arrays.asList("5", "6"));
                }
                if (DraftPayTypeEnum.DRAFTPAY.getValue().equals(draftPaymethod)) {
                    qFilter = new QFilter("settlementtype", "in", Arrays.asList("2", "5", "6", "7"));
                }
            } else {
                qFilter.and("settlementtype", "!=", (Object)SettleMentTypeEnum.CREDITOPEN.getValue());
            }
            return qFilter;
        });
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)"e_settletype", evt -> {
            if (!this.doInitF7("e_settletype")) {
                return null;
            }
            QFilter qFilter = new QFilter("settlementtype", "not in", Arrays.asList(SettleMentTypeEnum.CHECK.getValue(), SettleMentTypeEnum.BUSINESS.getValue(), SettleMentTypeEnum.BANK.getValue(), SettleMentTypeEnum.CREDIT.getValue()));
            return qFilter;
        });
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)"e_draftno", evt -> {
            if (!this.doInitF7("e_draftno")) {
                return null;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            DynamicObjectCollection draftInfoEntry = this.getModel().getEntryEntity("draftinfoentry");
            Long orgId = this.getOrgId();
            int row = evt.getRow();
            DynamicObject entryDO = (DynamicObject)entryEntity.get(row);
            String draftPayMethod = entryDO.getString("e_draftpaymethod");
            long scheId = entryDO.getLong("e_id");
            DynamicObject draftSettleTypesDO = entryDO.getDynamicObject("e_draftsettletype");
            DynamicObject currencyDObj = entryDO.getDynamicObject("e_paycurrency");
            DynamicObjectCollection limitbanksDOC = entryDO.getDynamicObjectCollection("e_limitbank");
            List limitbankList = PayScheHelper.transDyObjCollection2List((DynamicObjectCollection)limitbanksDOC);
            DynamicObjectCollection currDraftDOC = entryDO.getDynamicObjectCollection("e_draftno");
            List currDraftList = PayScheHelper.transDyObjCollection2List((DynamicObjectCollection)currDraftDOC);
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            BigDecimal chooseDraftAmt = entryDO.getBigDecimal("e_draftamt");
            BigDecimal choosebalanceAmt = entryDO.getBigDecimal("e_balanceamt");
            BigDecimal limitChooseDraftAmt = chooseDraftAmt.add(choosebalanceAmt);
            Boolean isBillDibs = entryDO.getBoolean("e_isbilldibs");
            if (BigDecimal.ZERO.compareTo(limitChooseDraftAmt) == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6392\u7a0b\u4f59\u989d\u548c\u6392\u7968\u91d1\u989d\u5747\u4e3a0\uff0c\u65e0\u6cd5\u9009\u62e9\u7968\u636e\u3002", (String)"PayScheProcessorEdit_01", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            sp.setCaption(ResManager.loadKDString((String)"\u7968\u636e", (String)"PayScheProcessorEdit_02", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            sp.getCustomParams().put("chooseDraftAmt", chooseDraftAmt);
            sp.getCustomParams().put("choosebalanceAmt", choosebalanceAmt);
            sp.getCustomParams().put("isBillBids", isBillDibs);
            sp.setFormId("draft_billf7");
            BigDecimal draftF7FilterAmt = BigDecimal.ZERO.compareTo(chooseDraftAmt) == 0 ? choosebalanceAmt : chooseDraftAmt;
            BigDecimal largeDraftAmt = BigDecimal.ZERO;
            largeDraftAmt = draftInfoEntry == null || draftInfoEntry.size() == 0 ? largeDraftAmt.add(draftF7FilterAmt) : largeDraftAmt.add(choosebalanceAmt);
            if (DraftPayTypeEnum.DRAFTBOOK.getValue().equals(draftPayMethod)) {
                sp.getCustomParams().put("paymentFlag", false);
                boolean isShowUnLockBill = (Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"cdm").getId(), (String)"08", (Long)orgId, (String)"isShowUnLockBill");
                if (isShowUnLockBill) {
                    QFilter orgFilter = new QFilter("company", "=", (Object)orgId);
                    QFilter chooseDraftQFilter = PayScheHelper.getChooseDraftQFilter((Long)scheId, (DynamicObject)draftSettleTypesDO, (DynamicObject)currencyDObj, (List)limitbankList, (List)currDraftList, (IDataModel)this.getModel(), (BigDecimal)largeDraftAmt, (Boolean)isBillDibs);
                    QFilter qFilter = orgFilter.and(chooseDraftQFilter);
                    qFilter.and(new QFilter("source", "!=", (Object)"cas"));
                    QFilter poolDraft = this.getDraftPoolQFilter(scheId, orgId, currencyDObj, draftSettleTypesDO, isShowUnLockBill, currDraftList, largeDraftAmt, isBillDibs);
                    if (EmptyUtil.isNoEmpty((Object)poolDraft)) {
                        qFilter.or(poolDraft);
                    }
                    logger.info("filter for showing unlock draft bill:{}", (Object)qFilter);
                    return qFilter;
                }
                QFilter chooseDraftQFilter = PayScheHelper.getChooseDraftQFilter((Long)scheId, (Object)orgId, (DynamicObject)draftSettleTypesDO, (DynamicObject)currencyDObj, (List)limitbankList, (List)currDraftList, (IDataModel)this.getModel(), (BigDecimal)largeDraftAmt, (Boolean)isBillDibs);
                QFilter qFilter = chooseDraftQFilter.copy();
                qFilter.and(new QFilter("source", "!=", (Object)"cas"));
                QFilter poolDraft = this.getDraftPoolQFilter(scheId, orgId, currencyDObj, draftSettleTypesDO, isShowUnLockBill, currDraftList, largeDraftAmt, isBillDibs);
                if (EmptyUtil.isNoEmpty((Object)poolDraft)) {
                    qFilter.or(poolDraft);
                }
                logger.info("filter for showing lock draft bill:{}", (Object)qFilter);
                return qFilter;
            }
            sp.getCustomParams().put("paymentFlag", true);
            String payeeName = entryDO.getString("e_payeename");
            return PayScheHelper.getChoosePayDraftQFilter((Long)scheId, (Object)orgId, (DynamicObject)draftSettleTypesDO, (DynamicObject)currencyDObj, (String)payeeName, (List)currDraftList, (String)this.getCurrentPageId(), (BigDecimal)draftF7FilterAmt, (Boolean)isBillDibs);
        });
        this.receiveF7Filter(view);
        this.draftPayAcctF7Filter(view);
    }

    private QFilter getDraftPoolQFilter(Long scheId, Long orgId, DynamicObject currencyDObj, DynamicObject draftSettleTypes, boolean isShowUnLockBill, List<Long> draftIdList, BigDecimal choosebalanceAmt, Boolean isBillDibs) {
        List<Long> ids;
        boolean isExcludedBills;
        List<Long> poolIds = this.getBillPoolByCompany();
        if (poolIds == null || poolIds.size() == 0) {
            return null;
        }
        QFilter qFilterBillPool = new QFilter("billpool", "in", poolIds);
        if (isShowUnLockBill) {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"0").or(QFilter.isNull((String)"poollockstatus")).or(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId))));
        } else {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId)));
        }
        qFilterBillPool.and(new QFilter("rptype", "=", (Object)"receivebill"));
        qFilterBillPool.and(new QFilter("currency", "=", currencyDObj.getPkValue()));
        qFilterBillPool.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilterBillPool.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        qFilterBillPool.and(new QFilter("isendorsepay", "=", (Object)"0").or(new QFilter("isendorsepay", "=", (Object)"1").and(new QFilter("locksourcebilltype", "=", (Object)"psd_schedulebill")).and(new QFilter("locksourcebillid", "=", (Object)String.valueOf(scheId)))));
        if (EmptyUtil.isNoEmpty((DynamicObject)draftSettleTypes)) {
            String settlementtype = draftSettleTypes.getString("settlementtype");
            Long linkSettlementTypeId = Optional.ofNullable(draftSettleTypes.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> draftSettleTypes.getLong("id"));
            List billTypeIdList = PayScheHelper.getBillTypeIdList((String)settlementtype, (Long)linkSettlementTypeId);
            qFilterBillPool.and(new QFilter("draftbilltype", "in", (Object)billTypeIdList));
        }
        if ((isExcludedBills = ((Boolean)SystemParamServiceHelper.getAppParameter((String)AppMetadataCache.getAppInfo((String)"cdm").getId(), (String)"08", (Long)orgId, (String)"isexcludedbills")).booleanValue()) && EmptyUtil.isNoEmpty(ids = this.getIsExcludedBills(isShowUnLockBill, orgId, poolIds, currencyDObj, scheId, draftSettleTypes)) && ids.size() > 0) {
            qFilterBillPool.and("id", "not in", (Object)ids.toArray());
        }
        if (!isBillDibs.booleanValue()) {
            QFilter q1 = new QFilter("availableamount", ">", (Object)BigDecimal.ZERO).and("issplit", "=", (Object)"1");
            QFilter q2 = new QFilter("availableamount", "<=", (Object)choosebalanceAmt).and("availableamount", ">", (Object)BigDecimal.ZERO).and("issplit", "=", (Object)"0");
            qFilterBillPool.and(q1.or(q2));
        } else {
            qFilterBillPool.and(new QFilter("availableamount", ">", (Object)BigDecimal.ZERO));
        }
        PayScheHelper.getSelectedDraftFilter((IDataModel)this.getModel(), draftIdList, (QFilter)qFilterBillPool);
        return qFilterBillPool;
    }

    private List<Long> getIsExcludedBills(boolean isShowUnLockBill, Long orgId, List<Long> poolIds, DynamicObject currencyDObj, Long scheId, DynamicObject draftSettleTypes) {
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            return ids;
        }
        String orgName = org.getString("name");
        if (EmptyUtil.isEmpty((String)orgName)) {
            return ids;
        }
        QFilter qFilterBillPool = new QFilter("billpool", "in", poolIds);
        if (isShowUnLockBill) {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"0").or(QFilter.isNull((String)"poollockstatus")).or(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId))));
        } else {
            qFilterBillPool.and(new QFilter("poollockstatus", "=", (Object)"1").and(new QFilter("poollockorg", "=", (Object)orgId)));
        }
        qFilterBillPool.and(new QFilter("rptype", "=", (Object)"receivebill"));
        qFilterBillPool.and(new QFilter("currency", "=", currencyDObj.getPkValue()));
        qFilterBillPool.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        qFilterBillPool.and(new QFilter("draftbillstatus", "=", (Object)"registered"));
        qFilterBillPool.and(new QFilter("isendorsepay", "=", (Object)"0").or(new QFilter("isendorsepay", "=", (Object)"1").and(new QFilter("locksourcebilltype", "=", (Object)"psd_schedulebill")).and(new QFilter("locksourcebillid", "=", (Object)String.valueOf(scheId)))));
        if (EmptyUtil.isNoEmpty((DynamicObject)draftSettleTypes)) {
            String settlementtype = draftSettleTypes.getString("settlementtype");
            Long linkSettlementTypeId = Optional.ofNullable(draftSettleTypes.getPkValue()).map(o -> Long.valueOf(o.toString())).orElseGet(() -> draftSettleTypes.getLong("id"));
            List billTypeIdList = PayScheHelper.getBillTypeIdList((String)settlementtype, (Long)linkSettlementTypeId);
            qFilterBillPool.and(new QFilter("draftbilltype", "in", (Object)billTypeIdList));
        }
        qFilterBillPool.and(new QFilter("company.id", "!=", (Object)orgId));
        Object[] receivablebills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,delivername,drawername,receivername,endorseentry.id,endorseentry.initiatorname,endorseentry.opponentname", (QFilter[])qFilterBillPool.toArray());
        if (EmptyUtil.isNoEmpty((Object[])receivablebills)) {
            block0: for (Object receivablebill : receivablebills) {
                String delivername = receivablebill.getString("delivername");
                String drawername = receivablebill.getString("drawername");
                String receivername = receivablebill.getString("receivername");
                if (orgName.equals(delivername) || orgName.equals(drawername) || orgName.equals(receivername)) {
                    ids.add(receivablebill.getLong("id"));
                    continue;
                }
                DynamicObjectCollection endorseentrys = receivablebill.getDynamicObjectCollection("endorseentry");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)endorseentrys)) continue;
                for (DynamicObject endorseentry : endorseentrys) {
                    String initiatorname = endorseentry.getString("initiatorname");
                    String opponentname = endorseentry.getString("opponentname");
                    if (!orgName.equals(initiatorname) && !orgName.equals(opponentname)) continue;
                    ids.add(receivablebill.getLong("id"));
                    continue block0;
                }
            }
        }
        return ids;
    }

    private void draftPayAcctF7Filter(IFormView view) {
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)"e_draftpayacct", evt -> {
            if (!this.doInitF7("e_draftpayacct")) {
                return null;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            Long orgId = this.getOrgId();
            int row = evt.getRow();
            QFilter qFilter = null;
            DynamicObject entryDataEntity = (DynamicObject)entryEntity.get(row);
            DynamicObject currencyDObj = entryDataEntity.getDynamicObject("e_paycurrency");
            if (EmptyUtil.isNoEmpty((DynamicObject)currencyDObj)) {
                ArrayList<String> bankStatus = new ArrayList<String>(4);
                bankStatus.add(BankAcctStatusEnum.NORMAL.getValue());
                bankStatus.add(BankAcctStatusEnum.CLOSING.getValue());
                bankStatus.add(BankAcctStatusEnum.CHANGING.getValue());
                QFilter accountAuthAssignFilter = TmcAccountHelper.getAccountBankFilterByOrg((Long)orgId);
                qFilter = accountAuthAssignFilter.and("acctstatus", "in", bankStatus).and("currency.fbasedataid", "=", currencyDObj.getPkValue());
            }
            return qFilter;
        });
    }

    public void receiveF7Filter(IFormView view) {
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)"e_dibsbalance", evt -> {
            Long payBillId;
            if (!this.doInitF7("e_dibsbalance")) {
                return null;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            int row = evt.getRow();
            DynamicObject payBill = (DynamicObject)entryEntity.get(row);
            QFilter filter = new QFilter("currency.id", "=", (Object)payBill.getDynamicObject("e_currency").getLong("id"));
            filter.and(new QFilter("org.id", "=", (Object)payBill.getDynamicObject("e_company").getLong("id")));
            QFilter qFilter = new QFilter("payername", "=", (Object)payBill.getString("e_payeename")).or(new QFilter("payer", "=", (Object)payBill.getLong("e_recid")));
            String payeeType = payBill.getString("e_itempayeetype");
            if ("bd_supplier".equals(payeeType)) {
                this.supplierQFilter(payBill, qFilter);
            } else if ("bd_customer".equals(payeeType)) {
                this.customerQFilter(payBill, qFilter);
            }
            filter.and(qFilter);
            filter.and(new QFilter("status", "=", (Object)"D"));
            BigDecimal receiveAmount = payBill.getBigDecimal("e_balance");
            filter.and(new QFilter("actrecamt", "=", (Object)receiveAmount));
            filter.and(new QFilter("isused", "=", (Object)false));
            ArrayList<Object> paValues = new ArrayList<Object>(entryEntity.size());
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setCaption(ResManager.loadKDString((String)"\u6536\u6b3e", (String)"PayScheProcessorEdit_03", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            showParameter.setFormId("rec_billf7");
            for (DynamicObject et : entryEntity) {
                DynamicObject bidsBalance = et.getDynamicObject("e_dibsbalance");
                if (!EmptyUtil.isNoEmpty((DynamicObject)bidsBalance)) continue;
                paValues.add(bidsBalance.getPkValue());
                showParameter.setSelectedRow(bidsBalance.getPkValue());
            }
            if (paValues.size() > 0) {
                filter.or(new QFilter("id", "in", paValues));
            }
            if ((payBillId = Long.valueOf(payBill.getLong("e_id"))) != null) {
                filter.or(new QFilter("usesourcebill", "=", (Object)String.valueOf(payBillId)));
            }
            return filter;
        });
    }

    private void supplierQFilter(DynamicObject payBill, QFilter qFilter) {
        DynamicObject supplier = payBill.getDynamicObject("e_itempayee");
        QFilter supplierQFilter = new QFilter("id", "=", supplier.getPkValue());
        DynamicObject supplierObject = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (String)"id, bizpartner", (QFilter[])new QFilter[]{supplierQFilter});
        if (EmptyUtil.isEmpty((DynamicObject)supplierObject)) {
            return;
        }
        DynamicObject bizPartner = supplierObject.getDynamicObject("bizpartner");
        if (EmptyUtil.isEmpty((DynamicObject)bizPartner)) {
            return;
        }
        QFilter customerQFilter = new QFilter("bizpartner.id", "=", bizPartner.getPkValue());
        DynamicObjectCollection customerObject = QueryServiceHelper.query((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{customerQFilter});
        ArrayList<Long> list = new ArrayList<Long>(customerObject.size());
        if (customerObject.size() <= 0) {
            return;
        }
        for (DynamicObject dynamicObject : customerObject) {
            Long id = dynamicObject.getLong("id");
            list.add(id);
        }
        qFilter.or(new QFilter("payer", "in", list));
    }

    private void customerQFilter(DynamicObject payBill, QFilter qFilter) {
        DynamicObject customer = payBill.getDynamicObject("e_itempayee");
        QFilter customerQFilter = new QFilter("id", "=", customer.getPkValue());
        DynamicObject customerObject = BusinessDataServiceHelper.loadSingle((String)"bd_customer", (String)"id, bizpartner", (QFilter[])new QFilter[]{customerQFilter});
        if (EmptyUtil.isEmpty((DynamicObject)customerObject)) {
            return;
        }
        DynamicObject bizPartner = customerObject.getDynamicObject("bizpartner");
        if (EmptyUtil.isEmpty((DynamicObject)bizPartner)) {
            return;
        }
        QFilter supplierQFilter = new QFilter("bizpartner.id", "=", bizPartner.getPkValue());
        DynamicObjectCollection supplierObject = QueryServiceHelper.query((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{supplierQFilter});
        ArrayList<Long> list = new ArrayList<Long>(supplierObject.size());
        if (supplierObject.size() <= 0) {
            return;
        }
        for (DynamicObject dynamicObject : supplierObject) {
            Long id = dynamicObject.getLong("id");
            list.add(id);
        }
        qFilter.or(new QFilter("payer", "in", list));
    }

    private List<Long> getBillPoolByCompany() {
        DynamicObject company = (DynamicObject)this.getModel().getValue("e_company");
        long orgId = company.getLong("id");
        DynamicObjectCollection billPools = QueryServiceHelper.query((String)"cdm_billpool", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.e_company", "=", (Object)orgId).or(new QFilter("company", "=", (Object)orgId)), new QFilter("enable", "=", (Object)"1")});
        ArrayList<Long> poolIds = new ArrayList<Long>(billPools.size());
        for (DynamicObject dy0 : billPools) {
            poolIds.add(dy0.getLong("id"));
        }
        return poolIds;
    }

    protected void showCombineProcessPage(PsdCombineModeEnum mode, List<PayScheCalcModel> scheDataList, Map<String, Object> extraParam) {
        FormShowParameter sp = new FormShowParameter();
        sp.setFormId("psd_schebillcombine");
        sp.getOpenStyle().setShowType(ShowType.Modal);
        sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_COMBINEPROCESSPAGE));
        sp.setCustomParam("KEY_PROCESSOR_INFO", (Object)JSON.toJSONString((Object)this.getProcessorInfo()));
        sp.setCustomParam("combineMode", (Object)mode.getValue());
        sp.setCustomParam("key_payschemodel", (Object)PayScheCalcModel.serializeList(scheDataList));
        if (extraParam != null) {
            for (Map.Entry<String, Object> entry : extraParam.entrySet()) {
                sp.setCustomParam(entry.getKey(), entry.getValue());
            }
        }
        this.getView().showForm(sp);
    }

    private void hypeEvtDeal() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener(evt -> {
            String fieldName = evt.getFieldName();
            if ("e_billno".equals(fieldName)) {
                int rowIndex = evt.getRowIndex();
                DynamicObjectCollection entryDetailDatas = this.getModel().getEntryEntity("entryentity");
                DynamicObject scheDo = (DynamicObject)entryDetailDatas.get(rowIndex);
                if (EmptyUtil.isNoEmpty((DynamicObject)scheDo)) {
                    this.showForm(scheDo.getLong("e_id"));
                }
            } else if ("e_batchnum".equals(fieldName)) {
                int rowIndex = evt.getRowIndex();
                DynamicObjectCollection entryDetailDatas = this.getModel().getEntryEntity("entryentity");
                DynamicObject scheDo = (DynamicObject)entryDetailDatas.get(rowIndex);
                List combineDataList = this.getHandler().getAllCombineDataList(scheDo.getString("e_batchnum"));
                this.showCombineProcessPage(PsdCombineModeEnum.VIEW_COMBINE, combineDataList, null);
            }
        });
    }

    private void showForm(Object focusRowPkId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("psd_schedulebill");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId(focusRowPkId);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private boolean doInitF7(String operate) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Long orgId = this.getOrgId();
        if (EmptyUtil.isNoEmpty((Long)orgId) && null != entryEntity && entryEntity.size() > 0) {
            return true;
        }
        logger.info("PayScheCalcBasePlugin#doInitF7 operate name: {}, validate  false", (Object)operate);
        return false;
    }
}

