/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.payscheprocessor.calc;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.IPayScheProcessorView;
import kd.tmc.psd.business.service.paysche.autosche.bill.DraftBillLockCache;
import kd.tmc.psd.business.service.paysche.controller.PayScheCalcBaseHandler;
import kd.tmc.psd.business.service.paysche.controller.PayScheCombineHandler;
import kd.tmc.psd.business.service.paysche.data.PayScheProcessorInfo;
import kd.tmc.psd.business.service.paysche.data.calc.PayScheCalcModel;
import kd.tmc.psd.business.service.paysche.data.sum.PayScheCombineSumData;
import kd.tmc.psd.common.enums.PsdCombineModeEnum;
import kd.tmc.psd.formplugin.payscheprocessor.calc.PayScheCalcBasePlugin;

public class PayScheCombinePlugin
extends PayScheCalcBasePlugin<PayScheCombineSumData> {
    private static final String ACTION_CONFIRM_UNIQUECOMBINE = "ACTION_CONFIRM_UNIQUECOMBINE";
    private static final String KEY_BATCHFILLPAYINFO = "KEY_BATCHFILLPAYINFO";
    private static final String KEY_BATCHFILLDRAFTINFO = "KEY_BATCHFILLDRAFTINFO";
    private PayScheCombineHandler handler;

    public String getMainPageId() {
        return this.getView().getParentView().getPageId();
    }

    public String getPageId() {
        return this.getView().getPageId();
    }

    public Long getOrgId() {
        return this.getProcessorInfo().getOrgId();
    }

    public String getDimType() {
        return this.getProcessorInfo().getDimType();
    }

    public Long getPeriodTypeId() {
        return this.getProcessorInfo().getPeriodTypeId();
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String mode = (String)fsp.getCustomParam("combineMode");
        this.getModel().setValue("combinemode", (Object)mode);
        new DraftBillLockCache(this.getPageId()).fromPrevPage(this.getMainPageId());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String preCombineInfo = (String)fsp.getCustomParam("key_payschemodel");
        List scheDataList = PayScheCalcModel.deserializeList((String)preCombineInfo);
        Object isSubmit = fsp.getCustomParams().getOrDefault("isSubmit", null);
        this.getPayScheHandler().initCombineData(scheDataList, EmptyUtil.isNoEmpty(isSubmit));
        this.selectEntry(0);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult opResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (opResult != null && opResult.isSuccess()) {
            EntryGrid detailsEntry = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = detailsEntry.getSelectRows();
            Long scheId = null;
            ArrayList<Long> scheIdLst = null;
            switch (operateKey) {
                case "returndata": {
                    boolean isValid = this.getPayScheHandler().validateCombineInfo();
                    if (!isValid) break;
                    FormShowParameter fsp = this.getView().getFormShowParameter();
                    String preCombineInfo = (String)fsp.getCustomParam("key_payschemodel");
                    List scheDataList = PayScheCalcModel.deserializeList((String)preCombineInfo);
                    List psdCalcModelLst = this.getPayScheHandler().getCombineResult(scheDataList);
                    this.getView().returnDataToParent((Object)PayScheCalcModel.serializeList((List)psdCalcModelLst));
                    DraftBillLockCache cache = new DraftBillLockCache(this.getCurrentPageId());
                    cache.updatePrevPage(this.getMainPageId());
                    this.getView().close();
                    break;
                }
                case "unifiedmergeitem": {
                    if (selectRows.length <= 0) {
                        this.showErrorMessage((List<String>)new ArrayList<String>(){
                            {
                                this.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u4ed8\u6b3e\u6392\u7a0b\u660e\u7ec6\u9879\uff0c\u8fdb\u884c\u7edf\u4e00\u5408\u5e76\u5904\u7406\u3002", (String)"PayScheCombinePlugin_02", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                            }
                        });
                        break;
                    }
                    if (selectRows.length > 1) {
                        this.showErrorMessage((List<String>)new ArrayList<String>(){
                            {
                                this.add(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u4ed8\u6b3e\u6392\u7a0b\u660e\u7ec6\u9879\u8fdb\u884c\u7edf\u4e00\u5408\u5e76\u5904\u7406\u3002", (String)"PayScheCombinePlugin_03", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                            }
                        });
                        break;
                    }
                    DynamicObject rowEntryDataOfUnified = this.getModel().getEntryRowEntity("entryentity", selectRows[0]);
                    scheId = rowEntryDataOfUnified.getLong("e_id");
                    this.getPayScheHandler().uniqueCombine(this.getSelectSumId(true), scheId);
                    break;
                }
                case "batchpayment": {
                    this.checkScheSelectRow();
                    ListShowParameter sp = ShowFormHelper.createShowListForm((String)"psd_payment_rule", (boolean)false);
                    sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_BATCHFILLPAYINFO));
                    this.getView().showForm((FormShowParameter)sp);
                    break;
                }
                case "batchticket": {
                    this.checkScheSelectRow();
                    ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"psd_queueticket_rule", (boolean)false);
                    lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_BATCHFILLDRAFTINFO));
                    this.getView().showForm((FormShowParameter)lsp);
                    break;
                }
                case "combine": {
                    if (selectRows.length <= 1) {
                        this.showErrorMessage((List<String>)new ArrayList<String>(){
                            {
                                this.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6216\u591a\u6761\u4ed8\u6b3e\u6392\u7a0b\u660e\u7ec6\u9879\u3002", (String)"PayScheCombinePlugin_04", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                            }
                        });
                        break;
                    }
                    scheIdLst = new ArrayList(selectRows.length);
                    for (int index : selectRows) {
                        DynamicObject rowEntryDataOfBatchPayment = this.getModel().getEntryRowEntity("entryentity", index);
                        scheIdLst.add(rowEntryDataOfBatchPayment.getLong("e_id"));
                    }
                    Tuple result = this.getPayScheHandler().manualCombine(this.getSelectSumId(true), scheIdLst);
                    if (!((Boolean)result.item1).booleanValue()) break;
                    this.getView().showConfirm((String)result.item2, MessageBoxOptions.YesNo, new ConfirmCallBackListener(ACTION_CONFIRM_UNIQUECOMBINE));
                    break;
                }
                case "cancelcombine": {
                    if (selectRows.length <= 0) {
                        this.showErrorMessage(new ArrayList(){
                            {
                                this.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6216\u591a\u6761\u4ed8\u6b3e\u6392\u7a0b\u660e\u7ec6\u9879\u3002", (String)"PayScheCombinePlugin_04", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                            }
                        });
                        break;
                    }
                    scheIdLst = new ArrayList<Long>(selectRows.length);
                    for (int index : selectRows) {
                        DynamicObject rowEntryDataOfBatchPayment = this.getModel().getEntryRowEntity("entryentity", index);
                        scheIdLst.add(rowEntryDataOfBatchPayment.getLong("e_id"));
                    }
                    this.getPayScheHandler().cancelCombine(this.getSelectSumId(true), scheIdLst);
                    break;
                }
                case "remove": {
                    if (selectRows.length <= 0) {
                        this.showErrorMessage(new ArrayList(){
                            {
                                this.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6216\u591a\u6761\u4ed8\u6b3e\u6392\u7a0b\u660e\u7ec6\u9879\u3002", (String)"PayScheCombinePlugin_04", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                            }
                        });
                        break;
                    }
                    scheIdLst = new ArrayList(selectRows.length);
                    for (int index : selectRows) {
                        DynamicObject rowEntryDataOfBatchPayment = this.getModel().getEntryRowEntity("entryentity", index);
                        scheIdLst.add(rowEntryDataOfBatchPayment.getLong("e_id"));
                    }
                    this.getPayScheHandler().remove(this.getSelectSumId(true), scheIdLst);
                    break;
                }
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid sumEntry = (EntryGrid)this.getControl("combinestatisentry");
        sumEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                int row = evt.getRow();
                if (row == -1) {
                    return;
                }
                DynamicObject sumEntry = PayScheCombinePlugin.this.getModel().getEntryRowEntity("combinestatisentry", row);
                long sumId = sumEntry.getLong("sumid");
                PayScheCombinePlugin.this.getPayScheHandler().loadScheDataList(Long.valueOf(sumId));
            }
        });
    }

    @Override
    public void updateScheDataList(List<PayScheCalcModel> scheDataList, boolean isReplace) {
        List<PayScheCalcModel> payScheCalcModels = this.filterVirPaySche(scheDataList);
        super.updateScheDataList(payScheCalcModels, isReplace);
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
        String mode = (String)this.getModel().getValue("combinemode");
        if (PsdCombineModeEnum.AUTO_COMBINE.getValue().equals(mode)) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            List combinePropList = (List)fsp.getCustomParam("key_combineprops");
            for (int i = 0; i < entryList.size(); ++i) {
                this.getView().setEnable(Boolean.valueOf(false), i, combinePropList.toArray(new String[0]));
            }
        }
    }

    public void updateSummaryInfo(List<PayScheCombineSumData> sumDataList, boolean isReplace) {
        if (isReplace) {
            EntryGrid sumEntry = (EntryGrid)this.getControl("combinestatisentry");
            int prevSumIndex = -1;
            if (sumEntry.getSelectRows().length > 0) {
                prevSumIndex = sumEntry.getSelectRows()[0];
            }
            this.getModel().deleteEntryData("combinestatisentry");
            List rowsData = sumDataList.stream().filter(Objects::nonNull).map(o -> {
                HashMap<String, Object> rowMap = new HashMap<String, Object>(7);
                rowMap.put("combinerule", o.getDimName());
                rowMap.put("combineno", o.getCombineNum());
                rowMap.put("totalcnt", o.getTotalCnt());
                rowMap.put("combinegroupcnt", o.getGroupCnt());
                rowMap.put("notcombinecnt", o.getErrCnt());
                rowMap.put("sumid", o.getSummaryId());
                return rowMap;
            }).collect(Collectors.toList());
            TmcViewInputHelper.batchFillEntity((String)"combinestatisentry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), rowsData);
            this.getView().updateView("combinestatisentry");
            if (sumDataList.size() > 0) {
                this.selectEntry(prevSumIndex);
            }
        } else {
            DynamicObjectCollection sumEntryList = this.getModel().getEntryEntity("combinestatisentry");
            for (int row = 0; row < sumEntryList.size(); ++row) {
                DynamicObject singleRowEntry = (DynamicObject)sumEntryList.get(row);
                for (PayScheCombineSumData sumData : sumDataList) {
                    if (!sumData.getSummaryId().equals(singleRowEntry.getLong("sumid"))) continue;
                    this.getModel().setValue("combinerule", (Object)sumData.getDimName(), row);
                    this.getModel().setValue("combineno", (Object)sumData.getCombineNum(), row);
                    this.getModel().setValue("totalcnt", (Object)sumData.getTotalCnt(), row);
                    this.getModel().setValue("combinegroupcnt", (Object)sumData.getGroupCnt(), row);
                    this.getModel().setValue("notcombinecnt", (Object)sumData.getErrCnt(), row);
                    this.getModel().setValue("sumid", (Object)sumData.getSummaryId(), row);
                }
            }
            EntryGrid currentSumRow = (EntryGrid)this.getView().getControl("combinestatisentry");
            int currSelectRow = -1;
            if (currentSumRow.getSelectRows().length > 0) {
                currSelectRow = currentSumRow.getSelectRows()[0];
            }
            if (currSelectRow != -1) {
                this.getView().updateView("combinestatisentry", currSelectRow);
            }
            if (sumDataList.size() > 0) {
                currentSumRow.selectRows(currSelectRow);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callbackId = messageBoxClosedEvent.getCallBackId();
        if (ACTION_CONFIRM_UNIQUECOMBINE.equals(callbackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.getPayScheHandler().manualUniqueCombine(this.getSumId(), this.getSelectPayScheIdList());
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection selectRows;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (KEY_BATCHFILLPAYINFO.equals(closedCallBackEvent.getActionId()) && returnData instanceof ListSelectedRowCollection && (selectRows = (ListSelectedRowCollection)returnData).size() > 0) {
            this.getPayScheHandler().autoFillPayInfo((Long)selectRows.get(0).getPrimaryKeyValue(), this.getSelectSumId(true), this.getSelectPayScheIdList());
        }
        if (KEY_BATCHFILLDRAFTINFO.equals(closedCallBackEvent.getActionId()) && returnData instanceof ListSelectedRowCollection && (selectRows = (ListSelectedRowCollection)returnData).size() > 0) {
            this.getPayScheHandler().autoFillTradeBillInfo((Long)selectRows.get(0).getPrimaryKeyValue(), this.getSelectSumId(true), this.getSelectPayScheIdList());
        }
    }

    private Long getSumId() {
        EntryGrid statisEntry = (EntryGrid)this.getControl("combinestatisentry");
        Long summaryId = this.getModel().getEntryRowEntity("combinestatisentry", statisEntry.getSelectRows()[0]).getLong("sumid");
        return summaryId;
    }

    private void selectEntry(int rowIndex) {
        DynamicObjectCollection sumEntryList = this.getModel().getEntryEntity("combinestatisentry");
        EntryGrid grid = (EntryGrid)this.getView().getControl("combinestatisentry");
        if (sumEntryList.size() == 0) {
            return;
        }
        if (rowIndex > sumEntryList.size() - 1 || rowIndex == -1) {
            rowIndex = 0;
        }
        DynamicObject entity = (DynamicObject)sumEntryList.get(rowIndex);
        this.getPayScheHandler().loadScheDataList(Long.valueOf(entity.getLong("sumid")));
        grid.selectRows(rowIndex);
    }

    private Long getSelectSumId(boolean emptyThrowException) {
        EntryGrid statisEntry = (EntryGrid)this.getControl("combinestatisentry");
        int[] selectRows = statisEntry.getSelectRows();
        if (selectRows.length == 0 || selectRows.length == 1 && selectRows[0] == -1) {
            if (emptyThrowException) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u6c47\u603b\u5361\u7247\u3002", (String)"PayScheProcessorCalcPlugin_02", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            }
            return null;
        }
        int selectRow = selectRows[0];
        DynamicObject entryEntity = this.getModel().getEntryRowEntity("combinestatisentry", selectRow);
        return entryEntity.getLong("sumid");
    }

    public PayScheProcessorInfo getProcessorInfo() {
        FormShowParameter sp = this.getView().getFormShowParameter();
        String processorInfoStr = (String)sp.getCustomParam("KEY_PROCESSOR_INFO");
        return (PayScheProcessorInfo)JSON.parseObject((String)processorInfoStr, PayScheProcessorInfo.class);
    }

    private PayScheCombineHandler getPayScheHandler() {
        if (this.handler == null) {
            FormShowParameter sp = this.getView().getFormShowParameter();
            List combinePropList = (List)sp.getCustomParam("key_combineprops");
            String modeVal = (String)sp.getCustomParam("combineMode");
            this.handler = new PayScheCombineHandler((IPayScheProcessorView)this, PsdCombineModeEnum.getByValue((String)modeVal), combinePropList);
        }
        return this.handler;
    }

    @Override
    protected PayScheCalcBaseHandler<PayScheCombineSumData> getHandler() {
        return this.getPayScheHandler();
    }

    @Override
    public void deleteScheData(List<PayScheCalcModel> scheDataList) {
        super.deleteScheData(this.filterVirPaySche(scheDataList));
    }

    private List<PayScheCalcModel> filterVirPaySche(List<PayScheCalcModel> scheDataList) {
        return scheDataList.stream().filter(Objects::nonNull).filter(o -> !o.isArchiveMerger()).collect(Collectors.toList());
    }
}

