/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.period;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.period.api.ISchePeriodCalculator;
import kd.tmc.psd.business.service.period.api.SchePeriodCalcFactory;
import kd.tmc.psd.business.service.period.model.ScheCalcResult;
import kd.tmc.psd.common.enums.AutoScheTypeEnum;

public class SchePeriodEdit
extends AbstractBasePlugIn {
    private static final String SELECTEDROW = "selectedRow";
    private static final String CHANGESTR = "changeStr";
    private static final String CALLBAK_KEY_DATESELECT = "dateselect";
    private ISchePeriodCalculator calc;

    private ISchePeriodCalculator getCalc() {
        if (this.calc == null) {
            this.calc = SchePeriodCalcFactory.initCalculator((DynamicObject)this.getModel().getDataEntity(Boolean.TRUE.booleanValue()));
        }
        return this.calc;
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((TextEdit)this.getView().getControl("fixeddate")).addButtonClickListener((ClickListener)this);
        EntryGrid entry = (EntryGrid)this.getControl("entrys");
        entry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                int row = evt.getRow();
                SchePeriodEdit.this.getPageCache().put(SchePeriodEdit.SELECTEDROW, String.valueOf(row));
            }
        });
    }

    public void click(EventObject evt) {
        String keyName;
        super.click(evt);
        Control key = (Control)evt.getSource();
        switch (keyName = key.getKey()) {
            case "fixeddate": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("psd_fixeddate_selector");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBAK_KEY_DATESELECT));
                HashMap<String, String> param = new HashMap<String, String>();
                String fixedDate = this.getModel().getDataEntity().getString("fixeddate");
                param.put("selectedDate", fixedDate);
                formShowParameter.getCustomParams().putAll(param);
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String changeStr = this.getPageCache().get(CHANGESTR);
        if (!StringUtils.isEmpty((CharSequence)changeStr)) {
            e.setCheckDataChange(Boolean.FALSE.booleanValue());
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (EmptyUtil.isNoEmpty((Object)returnData) && CALLBAK_KEY_DATESELECT.equals(actionId)) {
            Map data = (Map)event.getReturnData();
            List selected = (List)data.get("selected");
            if (selected.contains("32")) {
                selected.remove("32");
                selected.add(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u5929", (String)"SchePeriodEdit_12", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            }
            String selectStr = StringUtils.join((Object[])selected.toArray(new String[selected.size()]), (String)",");
            this.getModel().setValue("fixeddate", (Object)selectStr);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject scheType = (DynamicObject)model.getValue("group");
        if (null == scheType) {
            return;
        }
        model.setValue("number", (Object)scheType.getString("number"));
        model.setValue("name", (Object)scheType.getString("name"));
        model.setValue("periodtype", scheType.getDynamicObject("periodtype").getPkValue());
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        this.intSchePeriodYear(OperationStatus.ADDNEW.equals((Object)status));
        this.initCycle(OperationStatus.ADDNEW.equals((Object)status));
        int year = Integer.parseInt(model.getValue("periodyear").toString());
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("periodyear", "=", (Object)year));
        filters.add(new QFilter("schetype", "=", scheType.getPkValue()));
        DynamicObject[] periods = TmcDataServiceHelper.load((String)"psd_schedule_period", (String)"periodnum,name,startdate,enddate,diffdays", (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (periods.length > 0) {
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("periodnum", new Object[0]);
            vs.addField("periodname", new Object[0]);
            vs.addField("startdate", new Object[0]);
            vs.addField("enddate", new Object[0]);
            vs.addField("diffdays", new Object[0]);
            vs.addField("periodid", new Object[0]);
            int index = 0;
            int size = periods.length;
            for (DynamicObject period : periods) {
                vs.addRow(new Object[]{period.get("periodnum"), period.get("name"), period.get("startdate"), period.get("enddate"), period.get("diffdays"), period.getPkValue()});
                if (index == 0 || index == size - 1 || DateUtils.getCurrentDate().compareTo(DateUtils.getDataFormat((Date)period.getDate("startdate"), (boolean)Boolean.TRUE)) >= 0) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"enddate"});
                }
                ++index;
            }
            model.batchCreateNewEntryRow("entrys", vs);
            model.endInit();
            this.getView().updateView("entrys");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        IDataModel model = this.getModel();
        DynamicObject schePeriod = model.getDataEntity();
        String autoScheType = schePeriod.getString("autoschetype");
        int customDay = schePeriod.getInt("customday");
        if ("autogen".equals(operateKey)) {
            String fixedDates = schePeriod.getString("fixeddate");
            if (autoScheType.equals(AutoScheTypeEnum.FIXED.getValue()) && StringUtils.isEmpty((CharSequence)fixedDates)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u56fa\u5b9a\u65e5\u671f\u8303\u56f4\u3002", (String)"SchePeriodEdit_0", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            if (customDay == 0 && AutoScheTypeEnum.CUSTOM.getValue().equals(autoScheType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u81ea\u5b9a\u4e49\u5929\u6570\u3002", (String)"SchePeriodEdit_1", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
        }
        if ("save".equals(operateKey)) {
            boolean required = this.checkWorCalandarIsRequired();
            if (required) {
                args.setCancel(true);
            }
            DynamicObject group = this.getModel().getDataEntity().getDynamicObject("group");
            this.getModel().setValue("name", (Object)group.getString("name"));
        }
        if ("insertentry".equals(operateKey)) {
            String selectedRow = this.getPageCache().get(SELECTEDROW);
            if (null == selectedRow || selectedRow.equals("-1")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"SchePeriodEdit_2", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            int rowCount = model.getEntryRowCount("entrys");
            if (rowCount == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u751f\u6210\u5468\u671f\u3002", (String)"SchePeriodEdit_3", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
            } else {
                int index = model.getEntryCurrentRowIndex("entrys");
                if (index == rowCount - 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5468\u671f\u4e0d\u5141\u8bb8\u63d2\u5165\u3002", (String)"SchePeriodEdit_4", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                DynamicObject nextEntry = model.getEntryRowEntity("entrys", index + 1);
                Date nextStartDate = nextEntry.getDate("startdate");
                if (DateUtils.getCurrentDate().compareTo(DateUtils.getDataFormat((Date)nextStartDate, (boolean)Boolean.TRUE)) >= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5468\u671f\u5df2\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u63d2\u5165\u3002", (String)"SchePeriodEdit_5", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
                int diffDays = DateUtils.getDiffDays((Date)nextEntry.getDate("startdate"), (Date)nextEntry.getDate("enddate"));
                if (diffDays == 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5468\u671f\u4e0b\u4e00\u671f\u5929\u6570\u5c0f\u4e8e\u6216\u7b49\u4e8e\u4e00\u5929\uff0c\u65e0\u6cd5\u63d2\u5165\u3002", (String)"SchePeriodEdit_6", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    args.setCancel(Boolean.TRUE.booleanValue());
                    return;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData[] valueSet = args.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        IDataModel model = this.getModel();
        if ("name".equals(propName)) {
            this.getPageCache().put(CHANGESTR, propName);
        }
        switch (propName) {
            case "skiphol": 
            case "autoschetype": 
            case "customday": 
            case "mergetype": 
            case "fixeddate": {
                this.getView().invokeOperation("autogen");
                break;
            }
            case "enddate": {
                int rowIndex = valueSet[0].getRowIndex();
                DynamicObjectCollection entrys = model.getEntryEntity("entrys");
                Date lastPeriodEndDate = ((DynamicObject)entrys.get(entrys.size() - 1)).getDate("enddate");
                Date currStartDate = ((DynamicObject)entrys.get(rowIndex)).getDate("startdate");
                Date nextStartDate = ((DynamicObject)entrys.get(rowIndex + 1)).getDate("startdate");
                if (null == propValue) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ed3\u675f\u65e5\u671f\u3002", (String)"SchePeriodEdit_7", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    model.setValue("enddate", (Object)DateUtils.getLastDay((Date)nextStartDate, (int)1), rowIndex);
                    return;
                }
                if (DateUtils.getDataFormat((Date)lastPeriodEndDate, (boolean)Boolean.TRUE).before(DateUtils.getDataFormat((Date)((Date)propValue), (boolean)Boolean.TRUE))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u6700\u540e\u4e00\u671f\u7ed3\u675f\u65e5\u671f\u3002", (String)"SchePeriodEdit_8", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    model.setValue("enddate", (Object)DateUtils.getLastDay((Date)nextStartDate, (int)1), rowIndex);
                    return;
                }
                if (DateUtils.getDataFormat((Date)currStartDate, (boolean)Boolean.TRUE).after(DateUtils.getDataFormat((Date)((Date)propValue), (boolean)Boolean.TRUE))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"SchePeriodEdit_9", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    model.setValue("enddate", (Object)DateUtils.getLastDay((Date)nextStartDate, (int)1), rowIndex);
                    return;
                }
                List calculate = this.getCalc().change(Integer.valueOf(rowIndex), currStartDate, (Date)propValue);
                this.batchGenPeriod(calculate);
                model.setEntryCurrentRowIndex("entrys", rowIndex);
                break;
            }
            case "cycle": {
                this.initCycle(Boolean.FALSE);
                break;
            }
        }
    }

    private void initCycle(boolean isAddNew) {
        Map kvMap = AutoScheTypeEnum.getKV();
        String cycle = this.getModel().getDataEntity().getString("cycle");
        if (cycle.equals("month")) {
            kvMap.remove(AutoScheTypeEnum.MONTH.getValue());
            kvMap.remove(AutoScheTypeEnum.FIXED.getValue());
        } else if (cycle.equals("year")) {
            kvMap.remove(AutoScheTypeEnum.PERIOD.getValue());
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(kvMap.size());
        for (Map.Entry entry : kvMap.entrySet()) {
            ComboItem comb = new ComboItem();
            LocaleString caption = new LocaleString((String)entry.getValue());
            comb.setCaption(caption);
            comb.setValue((String)entry.getKey());
            comboItems.add(comb);
        }
        ComboEdit combEdit = (ComboEdit)this.getControl("autoschetype");
        combEdit.setComboItems(comboItems);
        if (isAddNew) {
            this.getModel().setValue("autoschetype", (Object)AutoScheTypeEnum.CUSTOM.getValue());
        } else {
            String autoType = this.getModel().getDataEntity().getString("autoschetype");
            if (!kvMap.containsKey(autoType)) {
                autoType = AutoScheTypeEnum.CUSTOM.getValue();
            }
            this.getModel().setValue("autoschetype", (Object)autoType);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        String operateKey = args.getOperateKey();
        if ("autogen".equals(operateKey) && args.getOperationResult().isSuccess()) {
            List calculate = this.getCalc().calculate();
            this.batchGenPeriod(calculate);
            model.setEntryCurrentRowIndex("entrys", -1);
        }
        if ("deleteentry".equals(operateKey)) {
            int currRowIndex = model.getEntryCurrentRowIndex("entrys");
            List calculate = this.getCalc().delete(Integer.valueOf(currRowIndex + 1));
            this.batchGenPeriod(calculate);
            model.setEntryCurrentRowIndex("entrys", currRowIndex);
        }
        if ("insertentry".equals(operateKey)) {
            int insertRow = model.getEntryCurrentRowIndex("entrys");
            List calcResult = this.getCalc().insert(Integer.valueOf(insertRow + 1));
            this.batchGenPeriod(calcResult);
        }
    }

    private void batchGenPeriod(List<ScheCalcResult> calculate) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("periodnum", new Object[0]);
        vs.addField("periodname", new Object[0]);
        vs.addField("startdate", new Object[0]);
        vs.addField("enddate", new Object[0]);
        vs.addField("diffdays", new Object[0]);
        vs.addField("periodid", new Object[0]);
        model.deleteEntryData("entrys");
        model.beginInit();
        int len = calculate.size();
        for (int i = 0; i < len; ++i) {
            ScheCalcResult scheCalcResult = calculate.get(i);
            Integer diffDate = DateUtils.getDiffDays((Date)scheCalcResult.getStartDate(), (Date)scheCalcResult.getEndDate());
            vs.addRow(new Object[]{i + 1, scheCalcResult.getName(), scheCalcResult.getStartDate(), scheCalcResult.getEndDate(), diffDate, scheCalcResult.getPeriodId()});
            if (i != 0 && i != len - 1 && DateUtils.getCurrentDate().compareTo(DateUtils.getDataFormat((Date)scheCalcResult.getStartDate(), (boolean)Boolean.TRUE)) < 0) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"enddate"});
        }
        model.batchCreateNewEntryRow("entrys", vs);
        model.endInit();
        this.getView().updateView("entrys");
        this.getPageCache().put(SELECTEDROW, null);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        if (!e.getEntryProp().getName().equals("entrys")) {
            return;
        }
        IDataModel model = this.getModel();
        int currRowIndex = model.getEntryCurrentRowIndex("entrys");
        int rowCount = model.getEntryRowCount("entrys");
        if (currRowIndex == 0 || currRowIndex == rowCount - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9996\u884c/\u5c3e\u884c\u4e0d\u5141\u8bb8\u5220\u9664\u5468\u671f\u3002", (String)"SchePeriodEdit_10", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            e.setCancel(Boolean.TRUE.booleanValue());
        }
        DynamicObject currEntry = model.getEntryRowEntity("entrys", currRowIndex);
        Date startDate = currEntry.getDate("startdate");
        if (DateUtils.getCurrentDate().after(startDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6392\u7a0b\u5468\u671f\u5df2\u4f7f\u7528\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"SchePeriodEdit_11", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            e.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int deleteIndex;
        super.afterDeleteRow(e);
        if (e.getEntryProp().getName().equals("entrys") && e.getRowIndexs().length > 0 && (deleteIndex = e.getRowIndexs()[0]) == 0) {
            this.getView().invokeOperation("autogen");
        }
    }

    private void intSchePeriodYear(boolean isAddNew) {
        DynamicObject group = this.getModel().getDataEntity().getDynamicObject("group");
        ArrayList<Integer> years = new ArrayList<Integer>();
        DynamicObject[] schePeriods = TmcDataServiceHelper.load((String)"psd_schedule_period_tree", (String)"periodyear", (QFilter[])new QFilter[]{new QFilter("group", "=", group.getPkValue())}, (String)"periodyear desc");
        if (isAddNew) {
            if (schePeriods.length > 0) {
                years.add(schePeriods[0].getInt("periodyear") + 1);
            } else {
                years.add(DateUtils.getYear((Date)new Date()));
            }
        } else {
            years.add(this.getModel().getDataEntity().getInt("periodyear"));
        }
        this.setYearComs(years);
    }

    private void setYearComs(List<Integer> years) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(years.size());
        ComboEdit com = (ComboEdit)this.getControl("periodyear");
        int len = years.size();
        for (int i = 0; i < len; ++i) {
            ComboItem citem = new ComboItem();
            LocaleString caption = new LocaleString(String.valueOf(years.get(i)));
            citem.setCaption(caption);
            citem.setValue(String.valueOf(years.get(i)));
            list.add(citem);
        }
        com.setComboItems(list);
        this.getModel().setValue("periodyear", (Object)((ComboItem)list.get(0)).getValue());
    }

    private boolean checkWorCalandarIsRequired() {
        boolean bool = false;
        DynamicObject scheWeek = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        boolean skipHol = scheWeek.getBoolean("skiphol");
        Long workCalandarId = Optional.ofNullable(scheWeek.getDynamicObject("workcalendar")).map(o -> o.getLong("id")).orElseGet(() -> 0L);
        if (skipHol && (workCalandarId == null || workCalandarId.compareTo(0L) == 0)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u4f5c\u65e5\u5386\u3002", (String)"SchePeriodEdit_13", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
            bool = true;
        }
        return bool;
    }
}

