/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.primerule;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.business.service.paysche.sumsche.data.PrimeRuleVal;
import kd.tmc.psd.business.service.paysche.sumsche.data.SumSchePrimeRule;
import kd.tmc.psd.common.enums.PsdEffectEleEnum;

public class GroupSortPrimePlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(GroupSortPrimePlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        this.initF7();
    }

    private void initF7() {
        IFormView view = this.getView();
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)"groupsupplier", evt -> {
            QFilter filter = new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1"));
            int row = evt.getRow();
            List<Long> yetChooseIdList = this.getMutilBaseDataIdList("groupsupplier", row);
            return filter.and(new QFilter("id", "not in", yetChooseIdList));
        });
        TmcViewInputHelper.addF7Filter((IFormView)view, (String)"groupproject", evt -> {
            QFilter filter = new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1"));
            int row = evt.getRow();
            List<Long> yetChooseIdList = this.getMutilBaseDataIdList("groupproject", row);
            return filter.and(new QFilter("id", "not in", yetChooseIdList));
        });
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String sumSchePrimeRuleStr = (String)fsp.getCustomParam("e_settingsave_TAG");
        String effectEle = (String)fsp.getCustomParam("e_effectelement");
        try {
            int dimCate = SumSchePrimeRule.getDimCate((String)effectEle);
            if (dimCate == 1) {
                SumSchePrimeRule rule = SumSchePrimeRule.createTypeRuleFromJson((String)effectEle, (String)sumSchePrimeRuleStr);
                List sortedValList = rule.getSortedValList();
                this.insertSortEntryVal(sortedValList, effectEle);
            } else if (dimCate == 2) {
                SumSchePrimeRule rule = SumSchePrimeRule.createGrpRuleFromJson((String)effectEle, (String)sumSchePrimeRuleStr);
                List sortedValList = rule.getSortedValList();
                this.insertGroupEntryVal(sortedValList, effectEle);
            } else if (dimCate == 3) {
                SumSchePrimeRule rule = SumSchePrimeRule.createGrpRuleFromJson((String)effectEle, (String)sumSchePrimeRuleStr);
                List sortedValList = rule.getSortedValList();
                this.insertPayBillTypeEntryVal(sortedValList, effectEle);
            }
        }
        catch (Exception exception) {
            logger.error("GroupSortPrimePlugin Error: \n", (Throwable)exception);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object effectEle = fsp.getCustomParam("e_effectelement");
        if (PsdEffectEleEnum.SUPPLIERGROUP.getValue().equals(effectEle)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"groupproject"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sortvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sortname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"paybilltype"});
        }
        if (PsdEffectEleEnum.PROJECTGROUP.getValue().equals(effectEle)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"groupsupplier"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sortvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sortname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"paybilltype"});
        }
        if (PsdEffectEleEnum.SUPPLIERSORT.getValue().equals(effectEle) || PsdEffectEleEnum.PROJECTSORT.getValue().equals(effectEle)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"groupproject"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"groupsupplier"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sortvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"newentry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"deleteentry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"paybilltype"});
        }
        if (PsdEffectEleEnum.PAYBILLTYPE.getValue().equals(effectEle)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"groupsupplier"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sortvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"sortname"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"groupproject"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            String valJson = "";
            HashMap<String, String> data = new HashMap<String, String>(16);
            FormShowParameter fsp = this.getView().getFormShowParameter();
            String effectEle = (String)fsp.getCustomParam("e_effectelement");
            int cate = SumSchePrimeRule.getDimCate((String)effectEle);
            if (cate == 2) {
                List<List<PrimeRuleVal>> groupEntryData = this.getGroupEntryData(effectEle);
                if (groupEntryData.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u7684\u503c\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\u3002", (String)"GroupSortPrimePlugin_1", (String)"tmc-psd-formplugin", (Object[])new Object[0]));
                    return;
                }
                valJson = JSON.toJSONString(groupEntryData);
            } else if (cate == 1) {
                valJson = JSON.toJSONString(this.getSortEntryData());
            } else if (cate == 3) {
                valJson = JSON.toJSONString(this.getPayBillTypeEntryData(effectEle));
            }
            data.put("e_effectelement", effectEle);
            data.put("e_settingsave_TAG", valJson);
            this.getView().returnDataToParent(data);
            this.getView().close();
        }
    }

    private List<Long> getMutilBaseDataIdList(String entityName, int row) {
        DynamicObjectCollection entryDOC = this.getModel().getEntryEntity("entry");
        ArrayList<Long> yetChooseIdList = new ArrayList<Long>(10);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryDOC) && entryDOC.size() > 0) {
            for (int i = 0; i < entryDOC.size(); ++i) {
                if (i == row) continue;
                yetChooseIdList.addAll(((DynamicObject)entryDOC.get(i)).getDynamicObjectCollection(entityName).stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList()));
            }
        }
        return yetChooseIdList;
    }

    private void insertSortEntryVal(List<PrimeRuleVal> sortedValList, String effectEle) {
        if (CollectionUtils.isEmpty(sortedValList)) {
            sortedValList = PayScheHelper.getProjectOrSupplierSort((String)effectEle);
        }
        List entryValueMap = sortedValList.stream().map(o -> {
            HashMap<String, String> dataMap = new HashMap<String, String>(50);
            dataMap.put("sortname", o.getName());
            dataMap.put("sortvalue", o.getValue());
            return dataMap;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        TmcViewInputHelper.batchFillEntity((String)"entry", (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), entryValueMap);
    }

    private void insertGroupEntryVal(List<List<PrimeRuleVal>> sortedValList, String effectEle) {
        if (CollectionUtils.isEmpty(sortedValList)) {
            return;
        }
        DynamicObjectCollection entryDOC = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < sortedValList.size(); ++i) {
            if (i > 0) {
                entryDOC.addNew();
            }
            List<PrimeRuleVal> primeRuleVals = sortedValList.get(i);
            List primeRuleValList = primeRuleVals.stream().map(o -> Long.valueOf(o.getValue())).collect(Collectors.toList());
            if (PsdEffectEleEnum.PROJECTGROUP.getValue().equals(effectEle)) {
                this.getModel().setValue("groupproject", (Object)primeRuleValList.toArray(), i);
                continue;
            }
            this.getModel().setValue("groupsupplier", (Object)primeRuleValList.toArray(), i);
        }
    }

    private void insertPayBillTypeEntryVal(List<List<PrimeRuleVal>> sortedValList, String effectEle) {
        if (CollectionUtils.isEmpty(sortedValList)) {
            return;
        }
        DynamicObjectCollection entryDOC = this.getModel().getEntryEntity("entry");
        for (int i = 0; i < sortedValList.size(); ++i) {
            if (i > 0) {
                entryDOC.addNew();
            }
            List<PrimeRuleVal> primeRuleVals = sortedValList.get(i);
            List primeRuleValList = primeRuleVals.stream().map(o -> Long.valueOf(o.getValue())).collect(Collectors.toList());
            this.getModel().setValue("paybilltype", (Object)primeRuleValList.toArray(), i);
        }
    }

    private List<PrimeRuleVal> getSortEntryData() {
        DynamicObjectCollection entryDOC = this.getModel().getEntryEntity("entry");
        List<PrimeRuleVal> valList = entryDOC.stream().map(v -> new PrimeRuleVal(v.getString("sortname"), v.getString("sortvalue"))).collect(Collectors.toList());
        return valList;
    }

    private List<List<PrimeRuleVal>> getGroupEntryData(String effectEle) {
        DynamicObjectCollection entryDOC = this.getModel().getEntryEntity("entry");
        ArrayList<List<PrimeRuleVal>> sortedValList = new ArrayList<List<PrimeRuleVal>>(entryDOC.size());
        String entryRowName = "groupproject";
        String entityName = "bd_project";
        if (PsdEffectEleEnum.SUPPLIERGROUP.getValue().equals(effectEle)) {
            entryRowName = "groupsupplier";
            entityName = "bd_supplier";
        }
        ArrayList baseDataAllIdList = new ArrayList(10);
        for (int i = 0; i < entryDOC.size(); ++i) {
            baseDataAllIdList.addAll(((DynamicObject)entryDOC.get(i)).getDynamicObjectCollection(entryRowName).stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList()));
        }
        DynamicObject[] groupBaseDatas = TmcDataServiceHelper.load((Object[])baseDataAllIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        HashMap<Long, String> baseDataMap = new HashMap<Long, String>(16);
        for (DynamicObject groupBaseData : groupBaseDatas) {
            baseDataMap.put((Long)groupBaseData.getPkValue(), groupBaseData.getString("name"));
        }
        for (DynamicObject entryDO : entryDOC) {
            ArrayList<PrimeRuleVal> primeRuleValList = new ArrayList<PrimeRuleVal>(10);
            DynamicObjectCollection contextDOC = entryDO.getDynamicObjectCollection(entryRowName);
            if (contextDOC.size() <= 0) continue;
            for (DynamicObject contextDO : contextDOC) {
                long fbasedataid_id = contextDO.getLong("fbasedataid_id");
                String fbasedataidStr = (String)baseDataMap.get(fbasedataid_id);
                if (!EmptyUtil.isNoEmpty((String)fbasedataidStr)) continue;
                primeRuleValList.add(new PrimeRuleVal((String)baseDataMap.get(fbasedataid_id), String.valueOf(fbasedataid_id)));
            }
            sortedValList.add(primeRuleValList);
        }
        return sortedValList;
    }

    private List<List<PrimeRuleVal>> getPayBillTypeEntryData(String effectEle) {
        DynamicObjectCollection entryDOC = this.getModel().getEntryEntity("entry");
        ArrayList<List<PrimeRuleVal>> sortedValList = new ArrayList<List<PrimeRuleVal>>(entryDOC.size());
        String entryRowName = "paybilltype";
        String entityName = "cas_paymentbilltype";
        ArrayList baseDataAllIdList = new ArrayList(10);
        for (int i = 0; i < entryDOC.size(); ++i) {
            baseDataAllIdList.addAll(((DynamicObject)entryDOC.get(i)).getDynamicObjectCollection(entryRowName).stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList()));
        }
        DynamicObject[] groupBaseDatas = TmcDataServiceHelper.load((Object[])baseDataAllIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
        HashMap<Long, String> baseDataMap = new HashMap<Long, String>(16);
        for (DynamicObject groupBaseData : groupBaseDatas) {
            baseDataMap.put((Long)groupBaseData.getPkValue(), groupBaseData.getString("name"));
        }
        for (DynamicObject entryDO : entryDOC) {
            ArrayList<PrimeRuleVal> primeRuleValList = new ArrayList<PrimeRuleVal>(10);
            DynamicObjectCollection contextDOC = entryDO.getDynamicObjectCollection(entryRowName);
            if (contextDOC.size() <= 0) continue;
            for (DynamicObject contextDO : contextDOC) {
                long fbasedataid_id = contextDO.getLong("fbasedataid_id");
                String fbasedataidStr = (String)baseDataMap.get(fbasedataid_id);
                if (!EmptyUtil.isNoEmpty((String)fbasedataidStr)) continue;
                primeRuleValList.add(new PrimeRuleVal((String)baseDataMap.get(fbasedataid_id), String.valueOf(fbasedataid_id)));
            }
            sortedValList.add(primeRuleValList);
        }
        return sortedValList;
    }
}

