/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.psd.formplugin.sumscherule;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.bd.TmcBaseDataEdit;
import kd.tmc.psd.business.service.paysche.helper.PayScheHelper;
import kd.tmc.psd.common.enums.SumScheDimTypeEnum;

public class SumScheRuleEdit
extends TmcBaseDataEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"scheratio"});
        EntryGrid entry = (EntryGrid)this.getControl("entry");
        entry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                int row = evt.getRow();
                SumScheRuleEdit.this.getPageCache().put("selectedRow", String.valueOf(row));
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    protected void initControlEvi() {
        super.initControlEvi();
        BasedataEdit primeRuleF7 = (BasedataEdit)this.getControl("primerule");
        primeRuleF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObject company = this.getModel().getDataEntity().getDynamicObject("company");
            if (null != company) {
                QFilter primeRuleFiler = PayScheHelper.getPrimeRuleFiler((long)company.getLong("id"));
                showParameter.getListFilterParameter().setFilter(primeRuleFiler);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "primeruleclosecallback"));
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "scheratio": {
                IDataModel model = this.getModel();
                int index = model.getEntryCurrentRowIndex("entry");
                FormShowParameter fsp = new FormShowParameter();
                fsp.setCustomParam("schedraftradiosaveflag", (Object)this.transAmtData((BigDecimal)model.getValue("draftratio", index), Boolean.TRUE));
                fsp.setCustomParam("scheradiosaveflag", (Object)this.transAmtData((BigDecimal)model.getValue("payratio", index), Boolean.TRUE));
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scheradiocallbackflag"));
                fsp.setFormId("psd_scheradio");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.displayEntryData();
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        OperationStatus status = baseShowParameter.getStatus();
        this.getView().setEnable(Boolean.valueOf(status == OperationStatus.ADDNEW), new String[]{"company"});
        this.getView().setVisible(Boolean.valueOf(status != OperationStatus.ADDNEW), new String[]{"fs_sumruleinfo"});
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection selectedRows;
        Object returnData;
        super.closedCallBack(event);
        if ("scheradiocallbackflag".equals(event.getActionId()) && (returnData = event.getReturnData()) != null) {
            IDataModel model = this.getModel();
            int index = model.getEntryCurrentRowIndex("entry");
            Map data = (Map)returnData;
            Object scheDraftRadio = data.get("schedraftradiosaveflag");
            Object scheRadio = data.get("scheradiosaveflag");
            model.setValue("draftratio", (Object)this.transAmtData((BigDecimal)scheDraftRadio, Boolean.FALSE), index);
            model.setValue("payratio", (Object)this.transAmtData((BigDecimal)scheRadio, Boolean.FALSE), index);
            this.displayEntryData();
        }
        if ("primeruleclosecallback".equals(event.getActionId()) && !CollectionUtils.isEmpty((Collection)(selectedRows = (ListSelectedRowCollection)(returnData = event.getReturnData())))) {
            int rowIndex = 0;
            String selectedRowIndex = this.getPageCache().get("selectedRow");
            if (EmptyUtil.isNoEmpty((String)selectedRowIndex)) {
                rowIndex = Integer.parseInt(selectedRowIndex);
            }
            int rowCount = this.getModel().getEntryRowCount("entry");
            for (ListSelectedRow listSelectedRow : selectedRows) {
                if (rowIndex < rowCount) {
                    this.getModel().setValue("primerule", listSelectedRow.getPrimaryKeyValue(), rowIndex);
                }
                ++rowIndex;
            }
        }
    }

    private BigDecimal transAmtData(BigDecimal srcAmt, Boolean isToUp) {
        if (isToUp.booleanValue()) {
            return new BigDecimal("100").multiply(srcAmt).setScale(1, RoundingMode.HALF_UP);
        }
        return srcAmt.divide(new BigDecimal("100")).setScale(3, RoundingMode.HALF_UP);
    }

    private void displayEntryData() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity) && entryEntity.size() > 0) {
            HashMap dumObjMap = new HashMap();
            Map<String, List<DynamicObject>> groupMap = entryEntity.stream().collect(Collectors.groupingBy(o -> o.getString("edimension")));
            Object[] currencyIdSet = entryEntity.stream().map(o -> o.getString("condition_val")).filter(Objects::nonNull).map(o -> {
                String[] split = o.split(":");
                if (split.length > 1) {
                    return Long.parseLong(split[0]);
                }
                return null;
            }).filter(Objects::nonNull).toArray();
            Map<String, DynamicObject> currencyMap = Arrays.stream(TmcDataServiceHelper.load((Object[])currencyIdSet, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_currency"))).collect(Collectors.toMap(o -> o.getString("id"), o -> o));
            for (Map.Entry<String, List<DynamicObject>> entrySet : groupMap.entrySet()) {
                String entityType = entrySet.getKey();
                List<DynamicObject> entryEntitys = entrySet.getValue();
                List ids = entryEntitys.stream().filter(o -> !o.getString("condition_val").equals("_____NULL_DIM_VAL__")).map(p -> p.getString("condition_val")).filter(Objects::nonNull).map(o -> {
                    String[] splitVal = o.split(":");
                    return splitVal.length > 1 ? splitVal[1] : splitVal[0];
                }).collect(Collectors.toList());
                Set idSets = ids.stream().filter(Objects::nonNull).map(o -> Long.valueOf(o)).collect(Collectors.toSet());
                DynamicObject[] dimObjs = TmcDataServiceHelper.load((String)SumScheDimTypeEnum.getBaseDataType((String)entityType), (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", idSets)});
                Stream.of(dimObjs).forEach(temp -> dumObjMap.put(entityType + temp.getString("id"), temp));
            }
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entryDObj = (DynamicObject)entryEntity.get(i);
                BigDecimal scheDraftRadio = entryDObj.getBigDecimal("draftratio");
                BigDecimal scheRadio = entryDObj.getBigDecimal("payratio");
                BigDecimal scheduleRadio = scheDraftRadio.add(scheRadio);
                String displayStr = this.buildScheRadioStr(this.transAmtData(scheDraftRadio, Boolean.TRUE), this.transAmtData(scheRadio, Boolean.TRUE), this.transAmtData(scheduleRadio, Boolean.TRUE));
                this.getModel().setValue("scheratio", (Object)displayStr, i);
                String conditionVal = entryDObj.getString("condition_val");
                String eDim = entryDObj.getString("edimension");
                if (conditionVal.equals("_____NULL_DIM_VAL__")) {
                    String dimType = SumScheDimTypeEnum.getName((String)eDim);
                    this.getModel().setValue("condition", (Object)(dimType + "= \u201c\u201d"), i);
                } else {
                    String[] split = conditionVal.split(":");
                    String currencyNameStr = "";
                    if (split.length > 1) {
                        conditionVal = split[1];
                        DynamicObject currencyObj = currencyMap.get(split[0]);
                        if (currencyObj != null) {
                            String currencyName = currencyObj.getString("name");
                            currencyNameStr = String.format(ResManager.loadKDString((String)"\u5e01\u79cd = \u201c%s\u201d and ", (String)"SumScheRuleEdit_2", (String)"tmc-psd-formplugin", (Object[])new Object[0]), currencyName);
                        }
                    } else {
                        conditionVal = split[0];
                    }
                    String conditionStr = this.buildConditionStr((DynamicObject)dumObjMap.get(eDim + conditionVal), eDim);
                    this.getModel().setValue("condition", (Object)(currencyNameStr + conditionStr), i);
                }
                this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
            }
        }
    }

    private String buildScheRadioStr(BigDecimal scheDraftRadio, BigDecimal scheRadio, BigDecimal scheduleRadio) {
        StringBuilder sb = new StringBuilder();
        if (BigDecimal.ZERO.compareTo(scheduleRadio) <= 0) {
            if (BigDecimal.ZERO.compareTo(scheDraftRadio) < 0 && BigDecimal.ZERO.compareTo(scheRadio) < 0) {
                sb.append(ResManager.loadKDString((String)"\u6392\u7968", (String)"AutoScheduleRuleEdit_2", (String)"tmc-psd-formplugin", (Object[])new Object[0])).append(scheDraftRadio).append("%; ").append(ResManager.loadKDString((String)"\u6392\u6b3e", (String)"AutoScheduleRuleEdit_3", (String)"tmc-psd-formplugin", (Object[])new Object[0])).append(scheRadio).append('%');
            }
            if (BigDecimal.ZERO.compareTo(scheDraftRadio) < 0 && BigDecimal.ZERO.compareTo(scheRadio) == 0) {
                sb.append(ResManager.loadKDString((String)"\u6392\u7968", (String)"AutoScheduleRuleEdit_2", (String)"tmc-psd-formplugin", (Object[])new Object[0])).append(scheDraftRadio).append('%');
            }
            if (BigDecimal.ZERO.compareTo(scheDraftRadio) == 0 && BigDecimal.ZERO.compareTo(scheRadio) < 0) {
                sb.append(ResManager.loadKDString((String)"\u6392\u6b3e", (String)"AutoScheduleRuleEdit_3", (String)"tmc-psd-formplugin", (Object[])new Object[0])).append(scheRadio).append('%');
            }
        }
        return sb.toString();
    }

    private String buildConditionStr(DynamicObject dimObj, String dimVal) {
        if (null == dimObj) {
            return "";
        }
        String dimType = SumScheDimTypeEnum.getName((String)dimVal);
        String dimName = dimObj.getString("name");
        return dimType + " = \u201c" + dimName + "\u201d";
    }
}

