/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.common.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.compiler.ConvertRuleCompiler;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LargeFundQueryFieldBuilder {
    private String entityName;
    private String org;
    private String tradeDate;
    private String acctBank;
    private String currency;
    private String resultAmt;
    private String payAmt;
    private String recAmt;
    private String oppUnitType;
    private String oppUnit;
    private String srcbillno;
    private String billStatus;
    private String remark;
    private static final String FUNDUSE_MATCH_SET = "id,number,name,deffunduse,billtype,entryentity,entryentity.condition,entryentity.funduse,entryentity.conditiondata,entryentity.conditiondata_TAG";

    public static LargeFundQueryFieldBuilder getFundQureyFieldObj(String resource) {
        switch (resource) {
            case "transdetail": {
                return new LargeFundQueryFieldBuilder("bei_transdetail", "company", "bizdate", "accountbank", "currency", "debitamount", "creditamount", "", "oppunit", "billno", "billstatus", "description");
            }
            case "bankjournal": {
                return new LargeFundQueryFieldBuilder("cas_bankjournal", "org", "bookdate", "accountbank", "currency", "creditamount", "debitamount", "", "oppunit", "sourcebillnumber", "billstatus", "description");
            }
            case "recbill": {
                return new LargeFundQueryFieldBuilder("cas_recbill", "org", "bizdate", "accountbank", "currency", "actrecamt", "actrecamt", "payertype", "payername", "billno", "billstatus", "txt_description");
            }
            case "paybill": {
                return new LargeFundQueryFieldBuilder("cas_paybill", "org", "paydate", "payeracctbank", "currency", "actpayamt", "actpayamt", "payeetype", "payeename", "billno", "billstatus", "description");
            }
        }
        return new LargeFundQueryFieldBuilder();
    }

    public static String getbizBillQueryFileds(LargeFundQueryFieldBuilder fundQureyFieldObj, String amtFields) {
        StringBuilder sb = new StringBuilder();
        sb.append("id").append(",").append(fundQureyFieldObj.getOrg()).append(",").append(fundQureyFieldObj.getTradeDate()).append(",").append(fundQureyFieldObj.getAcctBank()).append(",").append(fundQureyFieldObj.getCurrency()).append(",").append(amtFields).append(",").append(fundQureyFieldObj.getOppUnit()).append(",").append(fundQureyFieldObj.getSrcbillno()).append(",").append(fundQureyFieldObj.getBillStatus()).append(",").append(fundQureyFieldObj.getRemark());
        if (EmptyUtil.isNoEmpty((String)fundQureyFieldObj.getOppUnitType())) {
            sb.append(",").append(fundQureyFieldObj.getOppUnitType());
        }
        return sb.toString();
    }

    public static String getBizBillSelectFields(String entityName) {
        DynamicObject matchingRule = LargeFundQueryFieldBuilder.getMatchingRule(entityName);
        DynamicObjectCollection ruleEntrys = matchingRule.getDynamicObjectCollection("entryentity");
        HashSet<String> res = new HashSet<String>();
        for (DynamicObject ruleEntry : ruleEntrys) {
            String filterStr = ruleEntry.getString("conditiondata_TAG");
            CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
            ConvertRuleElement rule = new ConvertRuleElement();
            rule.setRunCondition(conditionObj);
            ConvertContext context = new ConvertContext();
            SingleRuleContext ruleContext = new SingleRuleContext();
            context.setSourceMainType(srcMainType);
            ruleContext.setContext(context);
            ruleContext.setRule(rule);
            ConvertRuleCompiler ruleCompiler = new ConvertRuleCompiler(ruleContext);
            ruleContext.setRuleCompiler(ruleCompiler);
            HashMap<String, String> fieldAlias = new HashMap<String, String>();
            ArrayList<String> selectFields = new ArrayList<String>();
            String pkFieldName = srcMainType.getPrimaryKey().getName();
            fieldAlias.put(pkFieldName, pkFieldName);
            selectFields.add(pkFieldName);
            CRConditionCompiler runCondCompiler = ruleCompiler.compileRunCondition();
            IGetValueMode expressExecutor = runCondCompiler.getExpressionExecuter();
            IGetValueMode gridFilterExecutor = ruleContext.getRuleCompiler().getRuleCondCompiler().getGridFilterExecuter();
            LargeFundQueryFieldBuilder.addSourceFields(expressExecutor.getVars(), selectFields, fieldAlias);
            LargeFundQueryFieldBuilder.addSourceFields(gridFilterExecutor.getVars(), selectFields, fieldAlias);
            res.addAll(selectFields);
        }
        return res.isEmpty() ? "id" : StringUtils.join((Object[])res.toArray(), (String)",");
    }

    private static void addSourceFields(List<IVariableMode> vars, List<String> selectFldStrings, Map<String, String> fieldAlias) {
        for (IVariableMode var : vars) {
            if (!(var instanceof SourceFieldVariable) || fieldAlias.containsKey(var.getVar())) continue;
            SourceFieldVariable srcField = (SourceFieldVariable)var;
            String selectFldString = srcField.getFullPropName();
            selectFldStrings.add(selectFldString);
        }
    }

    private static DynamicObject getMatchingRule(String dealBizType) {
        QFilter filter = new QFilter("billtype", "=", (Object)dealBizType).and("enable", "=", (Object)true);
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"mon_matchrules", (String)FUNDUSE_MATCH_SET, (QFilter[])new QFilter[]{filter});
        if (rules.length == 0) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)dealBizType);
            String name = dataEntityType.getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5927\u989d\u8d44\u91d1\u7528\u9014\u5339\u914d\u89c4\u5219\u5931\u8d25,\u8bf7\u7ef4\u62a4\u5355\u636e\u7c7b\u578b:%1$s\u7684\u5339\u914d\u89c4\u5219\u3002", (String)"LargeFundUseMatchHelper_0", (String)"tmc-sar-common", (Object[])new Object[0]), name));
        }
        return rules[0];
    }

    public LargeFundQueryFieldBuilder() {
    }

    public LargeFundQueryFieldBuilder(String entityName, String org, String tradeDate, String acctBank, String currency, String payAmt, String recAmt, String oppUnitType, String oppUnit, String srcbillno, String billStatus, String remark) {
        this.entityName = entityName;
        this.org = org;
        this.tradeDate = tradeDate;
        this.acctBank = acctBank;
        this.currency = currency;
        this.payAmt = payAmt;
        this.recAmt = recAmt;
        this.oppUnitType = oppUnitType;
        this.oppUnit = oppUnit;
        this.srcbillno = srcbillno;
        this.billStatus = billStatus;
        this.remark = remark;
        this.resultAmt = "resultAmt";
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getOrg() {
        return this.org;
    }

    public void setOrg(String org) {
        this.org = org;
    }

    public String getTradeDate() {
        return this.tradeDate;
    }

    public String getAcctBank() {
        return this.acctBank;
    }

    public void setAcctBank(String acctBank) {
        this.acctBank = acctBank;
    }

    public String getBillStatus() {
        return this.billStatus;
    }

    public void setBillStatus(String billStatus) {
        this.billStatus = billStatus;
    }

    public void setTradeDate(String tradeDate) {
        this.tradeDate = tradeDate;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getPayAmt() {
        return this.payAmt;
    }

    public void setPayAmt(String payAmt) {
        this.payAmt = payAmt;
    }

    public String getRecAmt() {
        return this.recAmt;
    }

    public void setRecAmt(String recAmt) {
        this.recAmt = recAmt;
    }

    public String getOppUnitType() {
        return this.oppUnitType;
    }

    public void setOppUnitType(String oppUnitType) {
        this.oppUnitType = oppUnitType;
    }

    public String getOppUnit() {
        return this.oppUnit;
    }

    public void setOppUnit(String oppUnit) {
        this.oppUnit = oppUnit;
    }

    public String getSrcbillno() {
        return this.srcbillno;
    }

    public void setSrcbillno(String srcbillno) {
        this.srcbillno = srcbillno;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getResultAmt() {
        return this.resultAmt;
    }

    public void setResultAmt(String resultAmt) {
        this.resultAmt = resultAmt;
    }
}

