/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LargeFundHelper {
    public static Boolean existApplyAll(DynamicObject dynamicObject) {
        QFilter qFilter = new QFilter("applyall", "=", (Object)true).and("enable", "=", (Object)true);
        Object pkValue = dynamicObject.getPkValue();
        if (EmptyUtil.isNoEmpty((Object)pkValue)) {
            qFilter.and("id", "!=", pkValue);
        }
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"mon_largethreshold", (String)"id", (QFilter[])qFilter.toArray());
        return EmptyUtil.isNoEmpty((DynamicObjectCollection)ids);
    }

    public static List<String> getRepeatOrg(DynamicObject dynamicObject) {
        ArrayList<String> orgNames = new ArrayList<String>();
        DynamicObjectCollection applyOrgEntities = dynamicObject.getDynamicObjectCollection("applyorgentity");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)applyOrgEntities)) {
            for (DynamicObject applyOrgEntity : applyOrgEntities) {
                DynamicObject aoOrg = applyOrgEntity.getDynamicObject("ao_fundorg");
                String orgName = aoOrg.getString("name");
                Long pkValue = (Long)aoOrg.getPkValue();
                QFilter qFilter = new QFilter("applyorgentity.ao_fundorg.id", "=", (Object)pkValue).and("enable", "=", (Object)true).and("id", "!=", dynamicObject.getPkValue());
                DynamicObjectCollection ids = QueryServiceHelper.query((String)"mon_largethreshold", (String)"id", (QFilter[])qFilter.toArray());
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)ids)) continue;
                orgNames.add(orgName);
            }
        }
        return orgNames;
    }

    public static Boolean largeThresholdFundUseValidate(DynamicObject dynamicObject) {
        boolean byFundUse = dynamicObject.getBoolean("byfunduse");
        if (byFundUse) {
            return !EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObject.getDynamicObjectCollection("thresholdentity"));
        }
        return true;
    }

    public static Boolean largeThresholdDebtTypeValidate(DynamicObject dynamicObject) {
        boolean byDebtType = dynamicObject.getBoolean("bydebttype");
        if (byDebtType) {
            return !EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObject.getDynamicObjectCollection("debtthresholdentity"));
        }
        return true;
    }

    public static Boolean largeThresholdApplyOrgValidate(DynamicObject dynamicObject) {
        if (!dynamicObject.getBoolean("applyall") && EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObject.getDynamicObjectCollection("applyorgentity"))) {
            return false;
        }
        return true;
    }

    public static Map<String, Date> calPeriod(Date bizDate, DynamicObject largeParamSet) {
        Date reportEndDate;
        Date reportStartDate;
        String debtReportPeriod;
        switch (debtReportPeriod = largeParamSet.getString("debtreportperiod")) {
            case "day": {
                reportStartDate = bizDate;
                reportEndDate = bizDate;
                break;
            }
            case "month": {
                reportStartDate = DateUtils.getFirstDayOfMonth((Date)bizDate);
                reportEndDate = DateUtils.getLastDayOfMonth((Date)bizDate);
                break;
            }
            case "quarter": {
                reportStartDate = DateUtils.getFirstSeasonDate((Date)bizDate);
                reportEndDate = DateUtils.getQuarterEnd((Date)bizDate);
                break;
            }
            case "halfyear": {
                int month = DateUtils.getMonth((Date)bizDate);
                if (month < 7) {
                    reportStartDate = DateUtils.getFirstYearDate((Date)bizDate);
                    reportEndDate = DateUtils.getLastDateOfAnyMonth((Date)reportStartDate, (int)5);
                    break;
                }
                reportEndDate = DateUtils.getLastYearDate((Date)bizDate);
                reportStartDate = DateUtils.getFirstDateOfAnyMonth((Date)reportEndDate, (int)-6);
                break;
            }
            case "year": {
                reportStartDate = DateUtils.getFirstYearDate((Date)bizDate);
                reportEndDate = DateUtils.getLastYearDate((Date)bizDate);
                break;
            }
            default: {
                Map weekDate = DateUtils.getWeekDate((Date)bizDate);
                reportStartDate = (Date)weekDate.get("beginDate");
                reportEndDate = (Date)weekDate.get("endDate");
            }
        }
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        dateMap.put("bizdate", bizDate);
        dateMap.put("reportperiod_startdate", reportStartDate);
        dateMap.put("reportperiod_enddate", reportEndDate);
        return dateMap;
    }
}

