/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class LargeFundQueryHelper {
    private static final Log LOGGER = LogFactory.getLog(LargeFundQueryHelper.class);
    private static final String LARGETHRESHOLD_SET = "id,number,name,applyall,currency,byfunduse,defaultthreshold,bydebttype,defdebtthreshold";
    private static final String LARGEPARAM_SET = "id,offinternal,merge,otherunitsetentity,offinternalloan,debtreportperiod,otherunitsetentity.unittext";

    public static DynamicObject getFundThresholdInfo(DynamicObject org) {
        QFilter thresholdFilter = new QFilter("enable", "=", (Object)true);
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            thresholdFilter.and("applyall", "=", (Object)true);
        } else {
            thresholdFilter.and(new QFilter("applyorgentity.ao_fundorg", "=", org.getPkValue()).or("applyall", "=", (Object)true));
        }
        DynamicObjectCollection reportOrgSets = QueryServiceHelper.query((String)"mon_largethreshold", (String)LARGETHRESHOLD_SET, (QFilter[])thresholdFilter.toArray(), (String)"applyall asc", (int)1);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)reportOrgSets)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u5bf9\u8be5%s\u7ec4\u7ec7\u8fdb\u884c\u5927\u989d\u8d44\u91d1\u9608\u503c\u8bbe\u7f6e\u3002", (String)"LargeFundQueryHelper_0", (String)"tmc-sar-common", (Object[])new Object[0]), org.getString("name")));
        }
        return (DynamicObject)reportOrgSets.get(0);
    }

    public static Map<Long, Pair<Long, BigDecimal>> getFundThresholdAmtByOrg(DynamicObject org) {
        DynamicObject fundThresholdInfo = LargeFundQueryHelper.getFundThresholdInfo(org);
        HashMap<Long, Pair<Long, BigDecimal>> resultMap = new HashMap<Long, Pair<Long, BigDecimal>>();
        Long currencyId = fundThresholdInfo.getLong("currency");
        resultMap.put(999L, Pair.of((Object)currencyId, (Object)fundThresholdInfo.getBigDecimal("defaultthreshold")));
        if (fundThresholdInfo.getBoolean("byfunduse")) {
            DynamicObjectCollection entrys = QueryServiceHelper.query((String)"mon_largethreshold", (String)"thresholdentity,thresholdentity.ts_funduse,thresholdentity.ts_threshold", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fundThresholdInfo.getLong("id"))});
            for (DynamicObject entry : entrys) {
                resultMap.put(entry.getLong("thresholdentity.ts_funduse"), (Pair<Long, BigDecimal>)Pair.of((Object)currencyId, (Object)entry.getBigDecimal("thresholdentity.ts_threshold")));
            }
        }
        return resultMap;
    }

    public static Map<Long, Pair<Long, BigDecimal>> getDebtAmtByOrg(DynamicObject org) {
        DynamicObject fundThresholdInfo = LargeFundQueryHelper.getFundThresholdInfo(org);
        HashMap<Long, Pair<Long, BigDecimal>> resultMap = new HashMap<Long, Pair<Long, BigDecimal>>();
        Long currencyId = fundThresholdInfo.getLong("currency");
        resultMap.put(999L, Pair.of((Object)currencyId, (Object)fundThresholdInfo.getBigDecimal("defdebtthreshold")));
        if (fundThresholdInfo.getBoolean("bydebttype")) {
            DynamicObjectCollection entrys = QueryServiceHelper.query((String)"mon_largethreshold", (String)"debtthresholdentity, debtthresholdentity.dts_debttype, debtthresholdentity.dts_threshold", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fundThresholdInfo.getLong("id"))});
            for (DynamicObject entry : entrys) {
                resultMap.put(entry.getLong("debtthresholdentity.dts_debttype"), (Pair<Long, BigDecimal>)Pair.of((Object)currencyId, (Object)entry.getBigDecimal("debtthresholdentity.dts_threshold")));
            }
        }
        return resultMap;
    }

    public static DynamicObject getLargeParamSet() {
        return TmcDataServiceHelper.loadSingle((String)"mon_largeparamset", (String)LARGEPARAM_SET, (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
    }

    public static List<String> getBankRoll() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter functionFilter = new QFilter("fisbankroll", "=", (Object)"1");
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{enableFilter, functionFilter});
        ArrayList<String> orgNames = new ArrayList<String>(dynamicObjectMap.size());
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            orgNames.add(((DynamicObject)entry.getValue()).getString("name"));
        }
        return orgNames;
    }

    public static Object[] queryReportOrgIdsByOrg(Map<String, Object> data) {
        Set filterIds = (Set)data.get("reportOrg");
        QFilter qFilter = new QFilter("org.id", "in", (Object)filterIds);
        DynamicObjectCollection reportFundOrgs = QueryServiceHelper.query((String)"mon_reportfundorg", (String)"id", (QFilter[])qFilter.toArray());
        return reportFundOrgs.stream().map(i -> i.getLong("id")).toArray();
    }

    public static BigDecimal getRate(Long fromCurrencyId, Long toCurrencyId, Long orgId) {
        BigDecimal rate = BigDecimal.ONE;
        if (!fromCurrencyId.equals(toCurrencyId) && (rate = TmcBusinessBaseHelper.getExchangeRate((long)fromCurrencyId, (long)toCurrencyId, (long)orgId, (Date)DateUtils.getCurrentDate())) == null) {
            DynamicObject fromCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)fromCurrencyId)});
            DynamicObject toCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)toCurrencyId)});
            LOGGER.info("\u7ec4\u7ec7id\uff1a{}\uff0c\u539f\u5e01FromCurrencyId\uff1a{}\uff0c\u76ee\u6807\u5e01ToCurrencyId\uff1a{}", new Object[]{orgId, fromCurrencyId, toCurrencyId});
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s:\u6ca1\u6709\u7ef4\u62a4[%2$s]\u8f6c\u6362[%3$s]\u7684\u6c47\u7387", (String)"LargeFundQueryHelper_1", (String)"tmc-sar-common", (Object[])new Object[0]), TmcOrgDataHelper.getOrgById((long)orgId).getString("name"), fromCurrency.getString("name"), toCurrency.getString("name")));
        }
        return rate;
    }
}

