/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.sar.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.sar.common.builder.FormulaGetHandle;
import kd.tmc.sar.common.builder.SingleTaskContext;

public class LargeFundUseMatchHelper {
    private static final Log LOGGER = LogFactory.getLog(LargeFundUseMatchHelper.class);
    private static final String DEBT_MATCH_SET = "id,number,name,defdebttype,billtype,entryentity,entryentity.condition,entryentity.debttype,entryentity.conditiondata,entryentity.conditiondata_TAG";
    private static final String FUNDUSE_MATCH_SET = "id,number,name,deffunduse,billtype,entryentity,entryentity.condition,entryentity.funduse,entryentity.conditiondata,entryentity.conditiondata_TAG";

    public static Map<Long, DynamicObject> getMatchResult(String entityName, DynamicObjectCollection funddetailDatas) {
        DynamicObject matchingRule = LargeFundUseMatchHelper.getMatchingRule(entityName);
        DynamicObjectCollection ruleEntrys = matchingRule.getDynamicObjectCollection("entryentity");
        Map<String, DynamicProperty> fldProperties = LargeFundUseMatchHelper.getFilterProperties(entityName, funddetailDatas);
        LinkedHashMap<Long, DynamicObject> resultMap = new LinkedHashMap<Long, DynamicObject>(10);
        for (DynamicObject funddetailData : funddetailDatas) {
            resultMap.put(funddetailData.getLong("id"), matchingRule.getDynamicObject("deffunduse"));
            for (DynamicObject ruleEntry : ruleEntrys) {
                if (!LargeFundUseMatchHelper.isMatch(entityName, ruleEntry, funddetailData, fldProperties)) continue;
                resultMap.put(funddetailData.getLong("id"), ruleEntry.getDynamicObject("funduse"));
            }
        }
        return resultMap;
    }

    public static Map<Long, DynamicObject> getDebtMatchResult(String entityName, DynamicObjectCollection resultDatas) {
        DynamicObject matchingRule = LargeFundUseMatchHelper.getDebtMatchingRule(entityName);
        DynamicObjectCollection ruleEntrys = matchingRule.getDynamicObjectCollection("entryentity");
        Map<String, DynamicProperty> fldProperties = LargeFundUseMatchHelper.getFilterProperties(entityName, resultDatas);
        LinkedHashMap<Long, DynamicObject> resultMap = new LinkedHashMap<Long, DynamicObject>(10);
        for (DynamicObject resultData : resultDatas) {
            resultMap.put(resultData.getLong("id"), matchingRule.getDynamicObject("defdebttype"));
            for (DynamicObject ruleEntry : ruleEntrys) {
                if (!LargeFundUseMatchHelper.isMatch(entityName, ruleEntry, resultData, fldProperties)) continue;
                resultMap.put(resultData.getLong("id"), ruleEntry.getDynamicObject("debttype"));
            }
        }
        return resultMap;
    }

    private static boolean isMatch(String entityName, DynamicObject ruleEntry, DynamicObject bizbill, Map<String, DynamicProperty> fldProperties) {
        boolean isMatch = false;
        String filterStr = ruleEntry.getString("conditiondata_TAG");
        CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
        SingleTaskContext taskContext = new SingleTaskContext();
        taskContext.setSrcEntityType(mainEntityType);
        if (EmptyUtil.isNotEmpty((CharSequence)baseFilterStr)) {
            FormulaGetHandle<Boolean> basebillFilterHandle = new FormulaGetHandle<Boolean>(taskContext, baseFilterStr, Boolean.FALSE);
            isMatch = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, bizbill, null);
        }
        LOGGER.info("bizbill:{},baseFilterStr:{},isMatch:{}", new Object[]{bizbill.toString(), baseFilterStr, isMatch});
        return isMatch;
    }

    private static DynamicObject getMatchingRule(String dealBizType) {
        QFilter filter = new QFilter("billtype", "=", (Object)dealBizType).and("enable", "=", (Object)true);
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"mon_matchrules", (String)FUNDUSE_MATCH_SET, (QFilter[])new QFilter[]{filter});
        if (rules.length == 0) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)dealBizType);
            String name = dataEntityType.getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5927\u989d\u8d44\u91d1\u7528\u9014\u5339\u914d\u89c4\u5219\u5931\u8d25,\u8bf7\u7ef4\u62a4\u5355\u636e\u7c7b\u578b:%1$s\u7684\u5339\u914d\u89c4\u5219\u3002", (String)"LargeFundUseMatchHelper_0", (String)"tmc-sar-common", (Object[])new Object[0]), name));
        }
        return rules[0];
    }

    private static DynamicObject getDebtMatchingRule(String dealBizType) {
        QFilter filter = new QFilter("billtype", "=", (Object)dealBizType).and("enable", "=", (Object)true);
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"sar_debt_matchrules", (String)DEBT_MATCH_SET, (QFilter[])new QFilter[]{filter});
        if (rules.length == 0) {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)dealBizType);
            String name = dataEntityType.getDisplayName().getLocaleValue();
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u503a\u52a1\u7c7b\u578b\u5339\u914d\u89c4\u5219\u5931\u8d25,\u8bf7\u7ef4\u62a4\u5355\u636e\u7c7b\u578b:%1$s\u7684\u5339\u914d\u89c4\u5219\u3002", (String)"LargeFundUseMatchHelper_1", (String)"tmc-sar-common", (Object[])new Object[0]), name));
        }
        return rules[0];
    }

    private static Map<String, DynamicProperty> getFilterProperties(String entityName, DynamicObjectCollection info) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(10);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || (propName = property.getName()).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        DynamicObjectType dType = info.getDynamicObjectType();
        for (String prop : selProps) {
            fldProperties.put(prop, dType.getProperty(prop));
        }
        return fldProperties;
    }
}

